/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.runtime.sequence.storage.ArrayBasedSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.CompilerDirectives;
import java.util.Arrays;

public final class DoubleSequenceStorage
extends ArrayBasedSequenceStorage {
    private double[] values;

    public DoubleSequenceStorage() {
        this.values = new double[0];
    }

    public DoubleSequenceStorage(double[] elements) {
        this.values = elements;
        this.capacity = elements.length;
        this.length = elements.length;
    }

    public DoubleSequenceStorage(double[] elements, int length) {
        this.values = elements;
        this.capacity = elements.length;
        this.length = length;
    }

    public DoubleSequenceStorage(int capacity) {
        this.values = new double[capacity];
        this.capacity = capacity;
        this.length = 0;
    }

    private void increaseCapacityExactWithCopy(int newCapacity) {
        this.values = Arrays.copyOf(this.values, newCapacity);
        this.capacity = this.values.length;
    }

    public void ensureCapacity(int newCapacity) throws ArithmeticException {
        if (CompilerDirectives.injectBranchProbability((double)0.25, (newCapacity > this.capacity ? 1 : 0) != 0)) {
            this.increaseCapacityExactWithCopy(DoubleSequenceStorage.capacityFor(newCapacity));
        }
    }

    @Override
    public ArrayBasedSequenceStorage createEmpty(int newCapacity) {
        return new DoubleSequenceStorage(newCapacity);
    }

    public void reverse() {
        if (this.length > 0) {
            int head = 0;
            int tail = this.length - 1;
            int middle = (this.length - 1) / 2;
            while (head <= middle) {
                double temp = this.values[head];
                this.values[head] = this.values[tail];
                this.values[tail] = temp;
                ++head;
                --tail;
            }
        }
    }

    public double[] getInternalDoubleArray() {
        return this.values;
    }

    public double getDoubleItemNormalized(int idx) {
        return this.values[idx];
    }

    public void setDoubleItemNormalized(int idx, double value) {
        this.values[idx] = value;
    }

    public void insertDoubleItem(int idx, double value) {
        this.ensureCapacity(this.length + 1);
        for (int i = this.values.length - 1; i > idx; --i) {
            this.values[i] = this.values[i - 1];
        }
        this.values[idx] = value;
        ++this.length;
    }

    public int indexOfDouble(double value) {
        for (int i = 0; i < this.length; ++i) {
            if (Double.compare(this.values[i], value) != 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getIndicativeValue() {
        return 0.0;
    }

    @Override
    public Object getInternalArrayObject() {
        return this.values;
    }

    @Override
    public Object getCopyOfInternalArrayObject() {
        return Arrays.copyOf(this.values, this.length);
    }

    public Object[] getCopyOfInternalArray() {
        Object[] boxed = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            boxed[i] = this.values[i];
        }
        return boxed;
    }

    @Override
    public void setInternalArrayObject(Object arrayObject) {
        this.values = (double[])arrayObject;
    }

    @Override
    public SequenceStorage.StorageType getElementType() {
        return SequenceStorage.StorageType.Double;
    }
}

