/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.java.annotation;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.graphwalker.java.annotation.GraphWalker;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public final class AnnotationUtils {
    private static Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().addUrls(AnnotationUtils.getUrls()).addScanners(new Scanner[]{new TypeAnnotationsScanner()}));

    private AnnotationUtils() {
    }

    private static String getExtension(String path) {
        int position = path.lastIndexOf(46);
        return path.lastIndexOf(File.separator) > position ? "" : path.substring(position + 1);
    }

    private static boolean valid(URL url) {
        String extension = AnnotationUtils.getExtension(url.getPath());
        if ("".equals(extension)) {
            try {
                return Paths.get(url.toURI()).toFile().exists();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return "jar".equals(extension);
    }

    private static Collection<URL> getUrls() {
        HashSet<URL> filteredUrls = new HashSet<URL>();
        HashSet urls = new HashSet();
        urls.addAll(ClasspathHelper.forClassLoader());
        urls.addAll(ClasspathHelper.forJavaClassPath());
        for (URL url : urls) {
            if (!AnnotationUtils.valid(url)) continue;
            filteredUrls.add(url);
        }
        return filteredUrls;
    }

    public static Set<Class<?>> findTests() {
        return reflections.getTypesAnnotatedWith(GraphWalker.class);
    }

    public static <T extends Annotation> Set<T> getAnnotations(Class<?> clazz, Class<T> annotation) {
        HashSet annotations = new HashSet();
        for (Class<?> queryClass = clazz; null != queryClass; queryClass = queryClass.getSuperclass()) {
            AnnotationUtils.addAnnotation(queryClass, annotations, annotation);
            for (Class<?> interfaceClass : queryClass.getInterfaces()) {
                AnnotationUtils.addAnnotation(interfaceClass, annotations, annotation);
            }
        }
        return annotations;
    }

    private static <T extends Annotation> void addAnnotation(Class<?> clazz, Set<T> annotations, Class<T> annotation) {
        if (clazz.isAnnotationPresent(annotation)) {
            annotations.add(clazz.getAnnotation(annotation));
        }
    }

    public static void execute(Class<? extends Annotation> annotation, Object implementation) {
        for (Method method : implementation.getClass().getMethods()) {
            if (!method.isAnnotationPresent(annotation)) continue;
            try {
                method.invoke(implementation, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }
}

