/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.java.test;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class Configuration {
    private static final Set<String> DEFAULT = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("*")));
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();
    private File testClassesDirectory = new File("target/test-classes");
    private File classesDirectory = new File("target/classes");
    private File reportsDirectory = new File("target/graphwalker-reports");
    private Set<String> groups = new HashSet<String>();

    public Set<String> getIncludes() {
        return this.includes.isEmpty() ? DEFAULT : Collections.unmodifiableSet(this.includes);
    }

    public Configuration addInclude(String include) {
        this.includes.add(include);
        return this;
    }

    public Configuration addInclude(Set<String> include) {
        this.includes.addAll(include);
        return this;
    }

    public Set<String> getExcludes() {
        return Collections.unmodifiableSet(this.excludes);
    }

    public Configuration addExclude(String exclude) {
        this.excludes.add(exclude);
        return this;
    }

    public Configuration addExclude(Set<String> exclude) {
        this.excludes.addAll(exclude);
        return this;
    }

    public File getTestClassesDirectory() {
        return this.testClassesDirectory;
    }

    public Configuration setTestClassesDirectory(File testClassesDirectory) {
        this.testClassesDirectory = testClassesDirectory;
        return this;
    }

    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public Configuration setClassesDirectory(File classesDirectory) {
        this.classesDirectory = classesDirectory;
        return this;
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public Configuration setReportsDirectory(File reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
        return this;
    }

    public Set<String> getGroups() {
        return this.groups.isEmpty() ? DEFAULT : Collections.unmodifiableSet(this.groups);
    }

    public Configuration addGroup(String group) {
        this.groups.add(group);
        return this;
    }
}

