/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.java.source;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class SourceFile {
    private static final Path DEFAULT_PATH = Paths.get("/", new String[0]);
    private final Path inputPath;
    private final Path relativePath;
    private final Path outputPath;
    private final String packageName;

    public SourceFile(File file) {
        this(file.toPath(), DEFAULT_PATH, DEFAULT_PATH);
    }

    public SourceFile(File file, File baseDirectory, File outputDirectory) {
        this(file.toPath(), baseDirectory.toPath(), outputDirectory.toPath());
    }

    public SourceFile(Path inputPath) {
        this(inputPath, DEFAULT_PATH, DEFAULT_PATH);
    }

    public SourceFile(Path inputPath, Path basePath, Path outputPath) {
        this.inputPath = inputPath;
        this.relativePath = basePath.relativize(inputPath);
        this.packageName = null != this.relativePath.getParent() ? this.relativePath.getParent().toString().replace(File.separator, ".").replaceAll(" ", "_") : "";
        this.outputPath = outputPath.resolve(this.relativePath).resolveSibling(this.getFileName() + ".java");
    }

    public Path getInputPath() {
        return this.inputPath;
    }

    public Path getRelativePath() {
        return this.relativePath;
    }

    public Path getOutputPath() {
        return this.outputPath;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getFileName() {
        return this.removeExtension(this.inputPath.getFileName().toString());
    }

    private String removeExtension(String filename) {
        String ext = this.extension(filename);
        if ("".equals(ext)) {
            return filename;
        }
        int index = filename.lastIndexOf(ext) - 1;
        return filename.substring(0, index);
    }

    private String extension(String filename) {
        int lastDot;
        int lastSep = filename.lastIndexOf(File.separatorChar);
        if (lastSep < 0) {
            lastDot = filename.lastIndexOf(46);
        } else {
            lastDot = filename.substring(lastSep + 1).lastIndexOf(46);
            if (lastDot >= 0) {
                lastDot += lastSep + 1;
            }
        }
        if (lastDot >= 0 && lastDot > lastSep) {
            return filename.substring(lastDot + 1);
        }
        return "";
    }
}

