/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.java.test;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.graphwalker.java.test.Configuration;
import org.graphwalker.java.test.ContextConfiguration;
import org.graphwalker.java.test.MachineConfiguration;
import org.graphwalker.java.test.Reflections;
import org.graphwalker.java.test.Result;
import org.graphwalker.java.test.TestExecutor;

public final class Reflector {
    private final ClassLoader classLoader;
    private final Class<?> collectionClass;
    private final Class<?> executorClass;
    private final Class<?> configurationClass;
    private final Class<?> resultClass;
    private final Class<?> machineConfigurationClass;
    private final Class<?> contextConfigurationClass;
    private final Method setIncludes;
    private final Method setExcludes;
    private final Method setGroups;
    private final Method execute;
    private final Method reportResults;
    private final Method setErrors;
    private final Method getErrors;
    private final Method setResult;
    private final Method getResultsAsString;
    private final Method getMachineConfiguration;
    private final Method getContextConfigurations;
    private final Method getTestClassName;
    private final Method getPathGeneratorName;
    private final Method getStopConditionName;
    private final Method getStopConditionValue;
    private final Method setTestClassName;
    private final Method setPathGeneratorName;
    private final Method setStopConditionName;
    private final Method setStopConditionValue;
    private final Object executor;

    public Reflector(Configuration configuration, ClassLoader classLoader) {
        ClassLoader contextClassLoader = this.switchClassLoader(classLoader);
        this.classLoader = classLoader;
        this.collectionClass = Reflections.loadClass(classLoader, Collection.class);
        this.executorClass = Reflections.loadClass(classLoader, TestExecutor.class);
        this.configurationClass = Reflections.loadClass(classLoader, Configuration.class);
        this.resultClass = Reflections.loadClass(classLoader, Result.class);
        this.machineConfigurationClass = Reflections.loadClass(classLoader, MachineConfiguration.class);
        this.contextConfigurationClass = Reflections.loadClass(classLoader, ContextConfiguration.class);
        this.setIncludes = Reflections.getMethod(this.configurationClass, "setIncludes", this.collectionClass);
        this.setExcludes = Reflections.getMethod(this.configurationClass, "setExcludes", this.collectionClass);
        this.setGroups = Reflections.getMethod(this.configurationClass, "setGroups", this.collectionClass);
        this.execute = Reflections.getMethod(this.executorClass, "execute", Boolean.TYPE);
        this.reportResults = Reflections.getMethod(this.executorClass, "reportResults", File.class, Date.class, Properties.class);
        this.setErrors = Reflections.getMethod(Result.class, "setErrors", List.class);
        this.getErrors = Reflections.getMethod(this.resultClass, "getErrors", new Class[0]);
        this.setResult = Reflections.getMethod(Result.class, "setResults", String.class);
        this.getResultsAsString = Reflections.getMethod(this.resultClass, "getResultsAsString", new Class[0]);
        this.getMachineConfiguration = Reflections.getMethod(this.executorClass, "getMachineConfiguration", new Class[0]);
        this.getContextConfigurations = Reflections.getMethod(this.machineConfigurationClass, "getContextConfigurations", new Class[0]);
        this.getTestClassName = Reflections.getMethod(this.contextConfigurationClass, "getTestClassName", new Class[0]);
        this.getPathGeneratorName = Reflections.getMethod(this.contextConfigurationClass, "getPathGeneratorName", new Class[0]);
        this.getStopConditionName = Reflections.getMethod(this.contextConfigurationClass, "getStopConditionName", new Class[0]);
        this.getStopConditionValue = Reflections.getMethod(this.contextConfigurationClass, "getStopConditionValue", new Class[0]);
        this.setTestClassName = Reflections.getMethod(ContextConfiguration.class, "setTestClassName", String.class);
        this.setPathGeneratorName = Reflections.getMethod(ContextConfiguration.class, "setPathGeneratorName", String.class);
        this.setStopConditionName = Reflections.getMethod(ContextConfiguration.class, "setStopConditionName", String.class);
        this.setStopConditionValue = Reflections.getMethod(ContextConfiguration.class, "setStopConditionValue", String.class);
        this.executor = this.createExecutor(configuration);
        this.switchClassLoader(contextClassLoader);
    }

    private Object createExecutor(Configuration configuration) {
        Constructor<?> constructor = Reflections.getConstructor(this.classLoader, this.executorClass, this.configurationClass);
        return Reflections.newInstance(constructor, this.createConfiguration(configuration));
    }

    private Object createConfiguration(Configuration configuration) {
        Object newConfiguration = Reflections.newInstance(this.classLoader, this.configurationClass);
        Reflections.invoke(newConfiguration, this.setIncludes, configuration.getIncludes());
        Reflections.invoke(newConfiguration, this.setExcludes, configuration.getExcludes());
        Reflections.invoke(newConfiguration, this.setGroups, configuration.getGroups());
        return newConfiguration;
    }

    private ClassLoader switchClassLoader(ClassLoader classLoader) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        return contextClassLoader;
    }

    public Result execute() {
        ClassLoader contextClassLoader = this.switchClassLoader(this.classLoader);
        Result result = this.createResult(Reflections.invoke(this.executor, this.execute, true));
        this.switchClassLoader(contextClassLoader);
        return result;
    }

    private Result createResult(Object result) {
        Result newResult = new Result();
        Reflections.invoke(newResult, this.setErrors, Reflections.invoke(result, this.getErrors, new Object[0]));
        Reflections.invoke(newResult, this.setResult, Reflections.invoke(result, this.getResultsAsString, new Object[0]));
        return newResult;
    }

    public MachineConfiguration getMachineConfiguration() {
        ClassLoader contextClassLoader = this.switchClassLoader(this.classLoader);
        MachineConfiguration newMachineConfiguration = new MachineConfiguration();
        Object machineConfiguration = Reflections.invoke(this.executor, this.getMachineConfiguration, new Object[0]);
        for (Object contextConfiguration : (Collection)Reflections.invoke(machineConfiguration, this.getContextConfigurations, new Object[0])) {
            ContextConfiguration newContextConfiguration = new ContextConfiguration();
            Reflections.invoke(newContextConfiguration, this.setTestClassName, Reflections.invoke(contextConfiguration, this.getTestClassName, new Object[0]));
            Reflections.invoke(newContextConfiguration, this.setPathGeneratorName, Reflections.invoke(contextConfiguration, this.getPathGeneratorName, new Object[0]));
            Reflections.invoke(newContextConfiguration, this.setStopConditionName, Reflections.invoke(contextConfiguration, this.getStopConditionName, new Object[0]));
            Reflections.invoke(newContextConfiguration, this.setStopConditionValue, Reflections.invoke(contextConfiguration, this.getStopConditionValue, new Object[0]));
            newMachineConfiguration.addContextConfiguration(newContextConfiguration);
        }
        this.switchClassLoader(contextClassLoader);
        return newMachineConfiguration;
    }

    public void reportResults(File file, Date startTime, Properties properties) {
        ClassLoader contextClassLoader = this.switchClassLoader(this.classLoader);
        Reflections.invoke(this.executor, this.reportResults, file, startTime, properties);
        this.switchClassLoader(contextClassLoader);
    }
}

