/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.configuration;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.AuthenticationManager;
import org.hswebframework.web.authorization.AuthenticationRequest;
import org.hswebframework.web.authorization.basic.web.AuthorizedToken;
import org.hswebframework.web.authorization.basic.web.ParsedToken;
import org.hswebframework.web.authorization.basic.web.UserTokenForTypeParser;
import org.hswebframework.web.authorization.simple.PlainTextUsernamePasswordAuthenticationRequest;
import org.hswebframework.web.authorization.token.UserToken;
import org.hswebframework.web.authorization.token.UserTokenManager;

public class BasicAuthorizationTokenParser
implements UserTokenForTypeParser {
    private AuthenticationManager authenticationManager;
    private UserTokenManager userTokenManager;

    @Override
    public String getTokenType() {
        return "basic";
    }

    public BasicAuthorizationTokenParser(AuthenticationManager authenticationManager, UserTokenManager userTokenManager) {
        this.authenticationManager = authenticationManager;
        this.userTokenManager = userTokenManager;
    }

    @Override
    public ParsedToken parseToken(HttpServletRequest request) {
        String[] info;
        String authorization = request.getHeader("Authorization");
        if (authorization == null) {
            return null;
        }
        if (authorization.contains(" ") && (info = authorization.split("[ ]"))[0].equalsIgnoreCase(this.getTokenType())) {
            authorization = info[1];
        }
        try {
            String[] arr;
            Authentication authentication;
            final String usernameAndPassword = new String(Base64.decodeBase64((String)authorization));
            UserToken token = this.userTokenManager.getByToken(usernameAndPassword);
            if (token != null && token.isNormal()) {
                return new ParsedToken(){

                    @Override
                    public String getToken() {
                        return usernameAndPassword;
                    }

                    @Override
                    public String getType() {
                        return BasicAuthorizationTokenParser.this.getTokenType();
                    }
                };
            }
            if (usernameAndPassword.contains(":") && (authentication = this.authenticationManager.authenticate((AuthenticationRequest)new PlainTextUsernamePasswordAuthenticationRequest((arr = usernameAndPassword.split("[:]"))[0], arr[1]))) != null) {
                return new AuthorizedToken(){

                    @Override
                    public String getUserId() {
                        return authentication.getUser().getId();
                    }

                    @Override
                    public String getToken() {
                        return usernameAndPassword;
                    }

                    @Override
                    public String getType() {
                        return BasicAuthorizationTokenParser.this.getTokenType();
                    }

                    @Override
                    public long getMaxInactiveInterval() {
                        return 3600000L;
                    }
                };
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }
}

