/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.handler.access;

import java.util.LinkedList;
import java.util.List;
import org.hswebframework.web.authorization.access.DataAccessConfig;
import org.hswebframework.web.authorization.access.DataAccessController;
import org.hswebframework.web.authorization.access.DataAccessHandler;
import org.hswebframework.web.authorization.basic.handler.access.CustomDataAccessHandler;
import org.hswebframework.web.authorization.basic.handler.access.FieldFilterDataAccessHandler;
import org.hswebframework.web.authorization.basic.handler.access.FieldScopeDataAccessHandler;
import org.hswebframework.web.authorization.basic.handler.access.OwnCreatedDataAccessHandler;
import org.hswebframework.web.authorization.basic.handler.access.ScriptDataAccessHandler;
import org.hswebframework.web.authorization.define.AuthorizingContext;

public final class DefaultDataAccessController
implements DataAccessController {
    private DataAccessController parent;
    private List<DataAccessHandler> handlers = new LinkedList<DataAccessHandler>();

    public DefaultDataAccessController() {
        this(null);
    }

    public DefaultDataAccessController(DataAccessController parent) {
        if (parent == this) {
            throw new UnsupportedOperationException();
        }
        this.parent = parent;
        this.addHandler(new CustomDataAccessHandler()).addHandler(new OwnCreatedDataAccessHandler()).addHandler(new ScriptDataAccessHandler()).addHandler(new FieldFilterDataAccessHandler()).addHandler(new FieldScopeDataAccessHandler());
    }

    public boolean doAccess(DataAccessConfig access, AuthorizingContext context) {
        if (this.parent != null) {
            this.parent.doAccess(access, context);
        }
        return this.handlers.stream().filter(handler -> handler.isSupport(access)).allMatch(handler -> handler.handle(access, context));
    }

    public DefaultDataAccessController addHandler(DataAccessHandler handler) {
        this.handlers.add(handler);
        return this;
    }

    public void setHandlers(List<DataAccessHandler> handlers) {
        this.handlers = handlers;
    }

    public List<DataAccessHandler> getHandlers() {
        return this.handlers;
    }
}

