/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.handler.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.web.authorization.access.DataAccessConfig;
import org.hswebframework.web.authorization.access.DataAccessHandler;
import org.hswebframework.web.authorization.access.FieldScopeDataAccessConfig;
import org.hswebframework.web.authorization.basic.handler.access.InvokeResultUtils;
import org.hswebframework.web.authorization.define.AuthorizingContext;
import org.hswebframework.web.authorization.define.Phased;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.hswebframework.web.controller.QueryController;
import org.hswebframework.web.service.QueryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldScopeDataAccessHandler
implements DataAccessHandler {
    private PropertyUtilsBean propertyUtilsBean = BeanUtilsBean.getInstance().getPropertyUtils();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public boolean isSupport(DataAccessConfig access) {
        return access instanceof FieldScopeDataAccessConfig;
    }

    public boolean handle(DataAccessConfig access, AuthorizingContext context) {
        FieldScopeDataAccessConfig own = (FieldScopeDataAccessConfig)access;
        Object controller = context.getParamContext().getTarget();
        if (controller != null) {
            switch (access.getAction()) {
                case "query": 
                case "get": {
                    return this.doQueryAccess(own, context);
                }
                case "delete": 
                case "update": {
                    return this.doRWAccess(own, context, controller);
                }
            }
            this.logger.warn("action: {} not support now!", (Object)access.getAction());
        } else {
            this.logger.warn("target is null!");
        }
        return true;
    }

    protected boolean doRWAccess(FieldScopeDataAccessConfig access, AuthorizingContext context, Object controller) {
        Object id = context.getParamContext().getParameter(context.getDefinition().getDataAccessDefinition().getIdParameterName()).orElse(null);
        if (controller instanceof QueryController) {
            QueryService queryService = (QueryService)((QueryController)controller).getService();
            Object oldData = queryService.selectByPk(id);
            if (oldData != null) {
                try {
                    Object value = this.propertyUtilsBean.getProperty(oldData, access.getField());
                    return access.getScope().contains(value);
                }
                catch (Exception e) {
                    this.logger.error("can't read property {}", (Object)access.getField(), (Object)e);
                    return false;
                }
            }
        } else {
            this.logger.warn("controller is not instanceof QueryController");
        }
        return true;
    }

    protected boolean doQueryAccess(FieldScopeDataAccessConfig access, AuthorizingContext context) {
        QueryParamEntity entity;
        if (context.getDefinition().getPhased() == Phased.before) {
            entity = context.getParamContext().getParams().values().stream().filter(QueryParamEntity.class::isInstance).map(QueryParamEntity.class::cast).findAny().orElse(null);
            if (entity == null) {
                this.logger.warn("try validate query access, but query entity is null or not instance of org.hswebframework.web.commons.entity.Entity");
                return true;
            }
        } else {
            Object result = InvokeResultUtils.convertRealResult(context.getParamContext().getInvokeResult());
            if (result == null) {
                return true;
            }
            if (result instanceof Collection) {
                return ((Collection)result).stream().allMatch(obj -> this.propertyInScope(obj, access.getField(), access.getScope()));
            }
            return this.propertyInScope(result, access.getField(), access.getScope());
        }
        List oldParam = entity.getTerms();
        entity.setTerms(new ArrayList());
        entity.addTerm(this.createQueryTerm(access)).nest().setTerms(oldParam);
        return true;
    }

    protected boolean propertyInScope(Object obj, String property, Set<Object> scope) {
        if (null == obj) {
            return false;
        }
        try {
            String value = BeanUtilsBean.getInstance().getProperty(obj, property);
            if (null != value) {
                return scope.contains(value);
            }
        }
        catch (Exception ignore) {
            this.logger.warn("can not get property {} from {},{}", new Object[]{property, obj, ignore.getMessage()});
        }
        return true;
    }

    protected Term createQueryTerm(FieldScopeDataAccessConfig access) {
        Term term = new Term();
        term.setType(Term.Type.and);
        term.setColumn(access.getField());
        term.setTermType("in");
        term.setValue((Object)access.getScope());
        return term;
    }
}

