/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.web;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import org.hswebframework.web.WebUtil;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.AuthenticationManager;
import org.hswebframework.web.authorization.AuthenticationRequest;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.listener.event.AuthorizationBeforeEvent;
import org.hswebframework.web.authorization.listener.event.AuthorizationDecodeEvent;
import org.hswebframework.web.authorization.listener.event.AuthorizationExitEvent;
import org.hswebframework.web.authorization.listener.event.AuthorizationFailedEvent;
import org.hswebframework.web.authorization.listener.event.AuthorizationSuccessEvent;
import org.hswebframework.web.authorization.simple.PlainTextUsernamePasswordAuthenticationRequest;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.logging.AccessLogger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${hsweb.web.mappings.authorize:authorize}"})
@AccessLogger(value="\u6388\u6743")
@Api(tags={"\u6743\u9650-\u7528\u6237\u6388\u6743"}, value="\u6388\u6743")
public class AuthorizationController {
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    @GetMapping(value={"/login-out", "/sign-out", "/exit"})
    @Authorize
    @ApiOperation(value="\u9000\u51fa\u5f53\u524d\u767b\u5f55")
    public ResponseMessage exit(@ApiParam(hidden=true) Authentication authentication) {
        this.eventPublisher.publishEvent((ApplicationEvent)new AuthorizationExitEvent(authentication));
        return ResponseMessage.ok();
    }

    @GetMapping(value={"/me"})
    @Authorize
    @ApiOperation(value="\u5f53\u524d\u767b\u5f55\u7528\u6237\u6743\u9650\u4fe1\u606f")
    public ResponseMessage<Authentication> me(@ApiParam(hidden=true) Authentication authentication) {
        return ResponseMessage.ok((Object)authentication);
    }

    @PostMapping(value={"/login"}, consumes={"application/json"})
    @ApiOperation(value="\u7528\u6237\u540d\u5bc6\u7801\u767b\u5f55,json\u65b9\u5f0f")
    public ResponseMessage<Map<String, Object>> authorize(@ApiParam(example="{\"username\":\"admin\",\"password\":\"admin\"}") @RequestBody Map<String, String> parameter) {
        return this.doLogin(parameter.get("username"), parameter.get("password"), parameter);
    }

    @PostMapping(value={"/login"}, consumes={"application/x-www-form-urlencoded"})
    @ApiOperation(value="\u7528\u6237\u540d\u5bc6\u7801\u767b\u5f55,\u53c2\u6570\u65b9\u5f0f")
    public ResponseMessage<Map<String, Object>> authorize(@RequestParam @ApiParam(value="\u7528\u6237\u540d") String username, @RequestParam @ApiParam(value="\u5bc6\u7801") String password, @ApiParam(hidden=true) HttpServletRequest request) {
        return this.doLogin(username, password, WebUtil.getParameters((HttpServletRequest)request));
    }

    protected ResponseMessage<Map<String, Object>> doLogin(String username, String password, Map<String, ?> parameter) {
        Assert.hasLength((String)username, (String)"\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasLength((String)password, (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AuthorizationFailedEvent.Reason reason = AuthorizationFailedEvent.Reason.OTHER;
        Function<String, Object> parameterGetter = parameter::get;
        try {
            AuthorizationDecodeEvent decodeEvent = new AuthorizationDecodeEvent(username, password, parameterGetter);
            this.eventPublisher.publishEvent((ApplicationEvent)decodeEvent);
            username = decodeEvent.getUsername();
            password = decodeEvent.getPassword();
            AuthorizationBeforeEvent beforeEvent = new AuthorizationBeforeEvent(username, password, parameterGetter);
            this.eventPublisher.publishEvent((ApplicationEvent)beforeEvent);
            Authentication authentication = this.authenticationManager.authenticate((AuthenticationRequest)new PlainTextUsernamePasswordAuthenticationRequest(username, password));
            AuthorizationSuccessEvent event = new AuthorizationSuccessEvent(authentication, parameterGetter);
            event.getResult().put("userId", authentication.getUser().getId());
            this.eventPublisher.publishEvent((ApplicationEvent)event);
            return ResponseMessage.ok((Object)event.getResult());
        }
        catch (Exception e) {
            AuthorizationFailedEvent failedEvent = new AuthorizationFailedEvent(username, password, parameterGetter, reason);
            failedEvent.setException(e);
            this.eventPublisher.publishEvent((ApplicationEvent)failedEvent);
            throw failedEvent.getException();
        }
    }
}

