/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.web;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hswebframework.web.authorization.basic.aop.AopMethodAuthorizeDefinitionParser;
import org.hswebframework.web.authorization.basic.web.AuthorizedToken;
import org.hswebframework.web.authorization.basic.web.ParsedToken;
import org.hswebframework.web.authorization.basic.web.UserTokenForTypeParser;
import org.hswebframework.web.authorization.basic.web.UserTokenParser;
import org.hswebframework.web.authorization.define.AuthorizeDefinition;
import org.hswebframework.web.authorization.token.UserToken;
import org.hswebframework.web.authorization.token.UserTokenHolder;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class WebUserTokenInterceptor
extends HandlerInterceptorAdapter {
    private UserTokenManager userTokenManager;
    private List<UserTokenParser> userTokenParser;
    private AopMethodAuthorizeDefinitionParser parser;
    private boolean enableBasicAuthorization = false;

    public WebUserTokenInterceptor(UserTokenManager userTokenManager, List<UserTokenParser> userTokenParser, AopMethodAuthorizeDefinitionParser definitionParser) {
        this.userTokenManager = userTokenManager;
        this.userTokenParser = userTokenParser;
        this.parser = definitionParser;
        this.enableBasicAuthorization = userTokenParser.stream().filter(UserTokenForTypeParser.class::isInstance).anyMatch(parser -> "basic".equalsIgnoreCase(((UserTokenForTypeParser)parser).getTokenType()));
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        List tokens = this.userTokenParser.stream().map(parser -> parser.parseToken(request)).filter(Objects::nonNull).collect(Collectors.toList());
        if (tokens.isEmpty()) {
            HandlerMethod method;
            AuthorizeDefinition definition;
            if (this.enableBasicAuthorization && handler instanceof HandlerMethod && null != (definition = this.parser.parse((method = (HandlerMethod)handler).getBeanType(), method.getMethod()))) {
                response.addHeader("WWW-Authenticate", " Basic realm=\"\"");
            }
            return true;
        }
        for (ParsedToken parsedToken : tokens) {
            UserToken userToken = null;
            String token = parsedToken.getToken();
            if (this.userTokenManager.tokenIsLoggedIn(token)) {
                userToken = this.userTokenManager.getByToken(token);
            }
            if ((userToken == null || userToken.isExpired()) && parsedToken instanceof AuthorizedToken) {
                this.userTokenManager.signOutByToken(token);
                userToken = this.userTokenManager.signIn(parsedToken.getToken(), parsedToken.getType(), ((AuthorizedToken)parsedToken).getUserId(), ((AuthorizedToken)parsedToken).getMaxInactiveInterval());
            }
            if (null == userToken) continue;
            this.userTokenManager.touch(token);
            UserTokenHolder.setCurrent((UserToken)userToken);
        }
        return true;
    }
}

