/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.connection;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.maproulette.client.exception.MapRouletteException;
import org.maproulette.client.http.HttpResource;
import org.maproulette.client.http.PostResource;
import org.maproulette.client.http.ResourceFactory;

public class Query {
    private String methodName;
    private String data;
    private ContentType dataContentType;
    private final String uri;
    private final Map<String, String> queryParameters = new HashMap<String, String>();
    private final Map<String, String> headers = new HashMap<String, String>();

    public void addParameter(String key, String value) {
        this.queryParameters.put(key, value);
    }

    public void addHeader(String header, String value) {
        this.headers.put(header, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<String> execute(ResourceFactory factory, URIBuilder uriBuilder, Function<HttpResource, String> function) throws MapRouletteException {
        URIBuilder path = uriBuilder.setPath(this.uri);
        if (!this.queryParameters.isEmpty()) {
            this.queryParameters.forEach((arg_0, arg_1) -> ((URIBuilder)path).setParameter(arg_0, arg_1));
        }
        try (HttpResource resource = factory.resource(this.methodName, path.build());){
            String result;
            if (StringUtils.isNotEmpty((String)this.data) && resource instanceof PostResource) {
                ((PostResource)resource).setStringBody(this.data, this.dataContentType);
            }
            if (!this.headers.isEmpty()) {
                this.headers.forEach(resource::setHeader);
            }
            if ((result = function.apply(resource)).isEmpty()) {
                Optional<String> optional = Optional.empty();
                return optional;
            }
            Optional<String> optional = Optional.of(result);
            return optional;
        }
        catch (URISyntaxException e) {
            throw new MapRouletteException(e);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static String $default$methodName() {
        return "GET";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static String $default$data() {
        return "";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static ContentType $default$dataContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    Query(String methodName, String data, ContentType dataContentType, String uri) {
        this.methodName = methodName;
        this.data = data;
        this.dataContentType = dataContentType;
        this.uri = uri;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static QueryBuilder builder() {
        return new QueryBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getMethodName() {
        return this.methodName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getData() {
        return this.data;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ContentType getDataContentType() {
        return this.dataContentType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUri() {
        return this.uri;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public static class QueryBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean methodName$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String methodName$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean data$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String data$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean dataContentType$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ContentType dataContentType$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String uri;

        public QueryBuilder post(String uri) {
            this.uri(uri);
            this.methodName("POST");
            return this;
        }

        public QueryBuilder get(String uri) {
            this.uri(uri);
            this.methodName("GET");
            return this;
        }

        public QueryBuilder put(String uri) {
            this.uri(uri);
            this.methodName("PUT");
            return this;
        }

        public QueryBuilder delete(String uri) {
            this.uri(uri);
            this.methodName("DELETE");
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        QueryBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public QueryBuilder methodName(String methodName) {
            this.methodName$value = methodName;
            this.methodName$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public QueryBuilder data(String data) {
            this.data$value = data;
            this.data$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public QueryBuilder dataContentType(ContentType dataContentType) {
            this.dataContentType$value = dataContentType;
            this.dataContentType$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public QueryBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Query build() {
            String methodName$value = this.methodName$value;
            if (!this.methodName$set) {
                methodName$value = Query.$default$methodName();
            }
            String data$value = this.data$value;
            if (!this.data$set) {
                data$value = Query.$default$data();
            }
            ContentType dataContentType$value = this.dataContentType$value;
            if (!this.dataContentType$set) {
                dataContentType$value = Query.$default$dataContentType();
            }
            return new Query(methodName$value, data$value, dataContentType$value, this.uri);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Query.QueryBuilder(methodName$value=" + this.methodName$value + ", data$value=" + this.data$value + ", dataContentType$value=" + this.dataContentType$value + ", uri=" + this.uri + ")";
        }
    }
}

