/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.assignment;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.mapstruct.ap.internal.model.assignment.Assignment;
import org.mapstruct.ap.internal.model.assignment.AssignmentWrapper;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.Strings;

public class ArrayCopyWrapper
extends AssignmentWrapper {
    private final String targetPropertyName;
    private final Type arraysType;
    private final Type targetType;

    public ArrayCopyWrapper(Assignment decoratedAssignment, String targetPropertyName, Type arraysType, Type targetType, Collection<String> existingVariableNames) {
        super(decoratedAssignment);
        this.targetPropertyName = Strings.getSaveVariableName(targetPropertyName, existingVariableNames);
        this.arraysType = arraysType;
        this.targetType = targetType;
    }

    @Override
    public Set<Type> getImportTypes() {
        HashSet<Type> imported = new HashSet<Type>();
        imported.addAll(this.getAssignment().getImportTypes());
        imported.add(this.arraysType);
        imported.add(this.targetType);
        return imported;
    }

    public String getLocalVarName() {
        return Strings.getSaveVariableName(Strings.decapitalize(this.targetPropertyName), Collections.<String>emptyList());
    }
}

