/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.BeanMapping;
import org.mapstruct.ap.internal.model.source.IterableMapping;
import org.mapstruct.ap.internal.model.source.MapMapping;
import org.mapstruct.ap.internal.model.source.Mapping;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.TargetReference;
import org.mapstruct.ap.internal.model.source.ValueMapping;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.FormattingMessager;

public class MappingOptions {
    private Map<String, List<Mapping>> mappings;
    private IterableMapping iterableMapping;
    private MapMapping mapMapping;
    private BeanMapping beanMapping;
    private List<ValueMapping> valueMappings;
    private boolean fullyInitialized;

    public MappingOptions(Map<String, List<Mapping>> mappings, IterableMapping iterableMapping, MapMapping mapMapping, BeanMapping beanMapping, List<ValueMapping> valueMappings) {
        this.mappings = mappings;
        this.iterableMapping = iterableMapping;
        this.mapMapping = mapMapping;
        this.beanMapping = beanMapping;
        this.valueMappings = valueMappings;
    }

    public Map<String, List<Mapping>> getMappings() {
        return this.mappings;
    }

    public IterableMapping getIterableMapping() {
        return this.iterableMapping;
    }

    public MapMapping getMapMapping() {
        return this.mapMapping;
    }

    public BeanMapping getBeanMapping() {
        return this.beanMapping;
    }

    public List<ValueMapping> getValueMappings() {
        return this.valueMappings;
    }

    public void setMappings(Map<String, List<Mapping>> mappings) {
        this.mappings = mappings;
    }

    public void setIterableMapping(IterableMapping iterableMapping) {
        this.iterableMapping = iterableMapping;
    }

    public void setMapMapping(MapMapping mapMapping) {
        this.mapMapping = mapMapping;
    }

    public void setBeanMapping(BeanMapping beanMapping) {
        this.beanMapping = beanMapping;
    }

    public void setValueMappings(List<ValueMapping> valueMappings) {
        this.valueMappings = valueMappings;
    }

    public boolean isFullyInitialized() {
        return this.fullyInitialized;
    }

    public void markAsFullyInitialized() {
        this.fullyInitialized = true;
    }

    public void applyInheritedOptions(MappingOptions inherited, boolean isInverse, SourceMethod method, FormattingMessager messager, TypeFactory typeFactory) {
        if (null != inherited) {
            if (this.getIterableMapping() == null && inherited.getIterableMapping() != null) {
                this.setIterableMapping(inherited.getIterableMapping());
            }
            if (this.getMapMapping() == null && inherited.getMapMapping() != null) {
                this.setMapMapping(inherited.getMapMapping());
            }
            if (this.getBeanMapping() == null && inherited.getBeanMapping() != null) {
                this.setBeanMapping(inherited.getBeanMapping());
            }
            if (this.getValueMappings() == null) {
                if (inherited.getValueMappings() != null) {
                    this.setValueMappings(inherited.getValueMappings());
                } else {
                    this.setValueMappings(java.util.Collections.<ValueMapping>emptyList());
                }
            } else if (inherited.getValueMappings() != null) {
                for (ValueMapping inheritedValueMapping : inherited.getValueMappings()) {
                    ValueMapping valueMapping = isInverse ? inheritedValueMapping.reverse() : inheritedValueMapping;
                    if (valueMapping == null || this.getValueMappings().contains(valueMapping)) continue;
                    this.getValueMappings().add(valueMapping);
                }
            }
            HashMap<String, List<Mapping>> newMappings = new HashMap<String, List<Mapping>>();
            for (List<Mapping> lmappings : inherited.getMappings().values()) {
                for (Mapping mapping : lmappings) {
                    if (isInverse) {
                        mapping = mapping.reverse(method, messager, typeFactory);
                    }
                    if (mapping == null) continue;
                    ArrayList<Mapping> mappingsOfProperty = (ArrayList<Mapping>)newMappings.get(mapping.getTargetName());
                    if (mappingsOfProperty == null) {
                        mappingsOfProperty = new ArrayList<Mapping>();
                        newMappings.put(mapping.getTargetName(), mappingsOfProperty);
                    }
                    mappingsOfProperty.add(mapping.copyForInheritanceTo(method));
                }
            }
            newMappings.putAll(this.getMappings());
            this.filterNestedTargetIgnores(newMappings);
            this.setMappings(newMappings);
        }
        this.markAsFullyInitialized();
    }

    private void filterNestedTargetIgnores(Map<String, List<Mapping>> mappings) {
        HashSet<String> ignored = new HashSet<String>();
        for (Map.Entry<String, List<Mapping>> mappingEntry : mappings.entrySet()) {
            Mapping mapping = (Mapping)Collections.first((Collection)mappingEntry.getValue());
            if (!mapping.isIgnored() || !mapping.getTargetReference().isValid()) continue;
            ignored.add(mapping.getTargetName());
        }
        HashSet<String> toBeRemoved = new HashSet<String>();
        for (Map.Entry<String, List<Mapping>> mappingEntry : mappings.entrySet()) {
            Mapping mapping = (Mapping)Collections.first((Collection)mappingEntry.getValue());
            TargetReference targetReference = mapping.getTargetReference();
            if (!targetReference.isValid() || targetReference.getPropertyEntries().size() <= 1 || !ignored.contains(Collections.first(targetReference.getPropertyEntries()).getName())) continue;
            toBeRemoved.add(mappingEntry.getKey());
        }
        mappings.keySet().removeAll(toBeRemoved);
    }
}

