/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Completions;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import net.java.html.js.JavaScriptBody;
import net.java.html.js.JavaScriptResource;
import org.netbeans.html.boot.impl.JsCallback;

public final class JavaScriptProcesor
extends AbstractProcessor {
    private final Map<String, Map<String, ExecutableElement>> javacalls = new HashMap<String, Map<String, ExecutableElement>>();
    private final Map<String, Set<TypeElement>> bodies = new HashMap<String, Set<TypeElement>>();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> set = new HashSet<String>();
        set.add(JavaScriptBody.class.getName());
        set.add(JavaScriptResource.class.getName());
        return set;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Messager msg = this.processingEnv.getMessager();
        for (Element element : roundEnv.getElementsAnnotatedWith(JavaScriptBody.class)) {
            if (element.getKind() != ElementKind.METHOD && element.getKind() != ElementKind.CONSTRUCTOR) continue;
            ExecutableElement ee = (ExecutableElement)element;
            List<? extends VariableElement> params = ee.getParameters();
            JavaScriptBody jsb = element.getAnnotation(JavaScriptBody.class);
            if (jsb == null) continue;
            Set<TypeElement> classes = this.bodies.get(JavaScriptProcesor.findPkg(element));
            if (classes == null) {
                classes = new HashSet<TypeElement>();
                this.bodies.put(JavaScriptProcesor.findPkg(element), classes);
            }
            Element t = element.getEnclosingElement();
            while (!t.getKind().isClass() && !t.getKind().isInterface()) {
                t = t.getEnclosingElement();
            }
            classes.add((TypeElement)t);
            String[] arr = jsb.args();
            if (params.size() != arr.length) {
                msg.printMessage(Diagnostic.Kind.ERROR, "Number of args arguments does not match real arguments!", element);
            }
            if (!jsb.javacall() && jsb.body().contains(".@")) {
                msg.printMessage(Diagnostic.Kind.WARNING, "Usage of .@ usually requires javacall=true", element);
            }
            if (!jsb.javacall()) continue;
            VerifyCallback verify = new VerifyCallback(element);
            try {
                verify.parse(jsb.body());
            }
            catch (IllegalStateException ex) {
                msg.printMessage(Diagnostic.Kind.ERROR, ex.getLocalizedMessage(), element);
            }
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(JavaScriptResource.class)) {
            JavaScriptResource r = element.getAnnotation(JavaScriptResource.class);
            if (r == null) continue;
            String res = r.value().startsWith("/") ? r.value() : JavaScriptProcesor.findPkg(element).replace('.', '/') + "/" + r.value();
            try {
                FileObject os = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, "", res);
                os.openInputStream().close();
            }
            catch (IOException ex1) {
                try {
                    FileObject os2 = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", res);
                    os2.openInputStream().close();
                }
                catch (IOException ex2) {
                    msg.printMessage(Diagnostic.Kind.ERROR, "Cannot find " + res + " in " + res + " package", element);
                }
            }
        }
        if (roundEnv.processingOver()) {
            this.generateCallbackClass(this.javacalls);
            this.generateJavaScriptBodyList(this.bodies);
            this.javacalls.clear();
        }
        return true;
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element e, AnnotationMirror annotation, ExecutableElement member, String userText) {
        StringBuilder sb = new StringBuilder();
        if (e.getKind() == ElementKind.METHOD && member.getSimpleName().contentEquals("args")) {
            ExecutableElement ee = (ExecutableElement)e;
            String sep = "";
            sb.append("{ ");
            for (VariableElement variableElement : ee.getParameters()) {
                sb.append(sep).append('\"').append(variableElement.getSimpleName()).append('\"');
                sep = ", ";
            }
            sb.append(" }");
            return Collections.nCopies(1, Completions.of(sb.toString()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateJavaScriptBodyList(Map<String, Set<TypeElement>> bodies) {
        for (Map.Entry<String, Set<TypeElement>> entry : bodies.entrySet()) {
            String pkg = entry.getKey();
            Set<TypeElement> classes = entry.getValue();
            try {
                FileObject out = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, pkg, "net.java.html.js.classes", classes.iterator().next());
                OutputStream os = out.openOutputStream();
                try {
                    PrintWriter w = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
                    for (TypeElement type : classes) {
                        w.println(this.processingEnv.getElementUtils().getBinaryName(type));
                    }
                    w.flush();
                    w.close();
                }
                finally {
                    os.close();
                }
            }
            catch (IOException x) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write to " + entry.getKey() + ": " + x.toString());
            }
        }
    }

    private void generateCallbackClass(Map<String, Map<String, ExecutableElement>> process) {
        for (Map.Entry<String, Map<String, ExecutableElement>> pkgEn : process.entrySet()) {
            String pkgName = pkgEn.getKey();
            Map<String, ExecutableElement> map = pkgEn.getValue();
            StringBuilder source = new StringBuilder();
            source.append("package ").append(pkgName).append(";\n");
            source.append("public final class $JsCallbacks$ {\n");
            source.append("  static final $JsCallbacks$ VM = new $JsCallbacks$(null);\n");
            source.append("  private final org.apidesign.html.boot.spi.Fn.Presenter p;\n");
            source.append("  private $JsCallbacks$ last;\n");
            source.append("  private $JsCallbacks$(org.apidesign.html.boot.spi.Fn.Presenter p) {\n");
            source.append("    this.p = p;\n");
            source.append("  }\n");
            source.append("  final $JsCallbacks$ current() {\n");
            source.append("    org.apidesign.html.boot.spi.Fn.Presenter now = org.apidesign.html.boot.spi.Fn.activePresenter();\n");
            source.append("    if (now == p) return this;\n");
            source.append("    if (last != null && now == last.p) return last;\n");
            source.append("    return last = new $JsCallbacks$(now);\n");
            source.append("  }\n");
            for (Map.Entry<String, ExecutableElement> entry : map.entrySet()) {
                String mangled = entry.getKey();
                ExecutableElement m = entry.getValue();
                boolean isStatic = m.getModifiers().contains((Object)Modifier.STATIC);
                source.append("\n  public java.lang.Object ").append(mangled).append("(");
                String sep = "";
                if (!isStatic) {
                    source.append(((TypeElement)m.getEnclosingElement()).getQualifiedName());
                    source.append(" self");
                    sep = ", ";
                }
                int cnt = 0;
                StringBuilder convert = new StringBuilder();
                for (VariableElement variableElement : m.getParameters()) {
                    source.append(sep);
                    ++cnt;
                    TypeMirror t = variableElement.asType();
                    if (!t.getKind().isPrimitive()) {
                        source.append("Object");
                        convert.append("    if (p instanceof org.apidesign.html.boot.spi.Fn.FromJavaScript) {\n");
                        convert.append("      arg").append(cnt).append(" = ((org.apidesign.html.boot.spi.Fn.FromJavaScript)p).toJava(arg").append(cnt).append(");\n");
                        convert.append("    }\n");
                    } else {
                        source.append(t);
                    }
                    source.append(" arg").append(cnt);
                    sep = ", ";
                }
                source.append(") throws Throwable {\n");
                source.append((CharSequence)convert);
                if (this.processingEnv.getSourceVersion().compareTo(SourceVersion.RELEASE_7) >= 0) {
                    source.append("    try (java.io.Closeable a = org.apidesign.html.boot.spi.Fn.activate(p)) { \n");
                } else {
                    source.append("    java.io.Closeable a = org.apidesign.html.boot.spi.Fn.activate(p); try {\n");
                }
                source.append("    ");
                if (m.getReturnType().getKind() != TypeKind.VOID) {
                    source.append("Object $ret = ");
                }
                if (isStatic) {
                    source.append(((TypeElement)m.getEnclosingElement()).getQualifiedName());
                    source.append('.');
                } else {
                    source.append("self.");
                }
                source.append(m.getSimpleName());
                source.append("(");
                cnt = 0;
                sep = "";
                for (VariableElement variableElement : m.getParameters()) {
                    source.append(sep);
                    source.append("(").append(variableElement.asType());
                    source.append(")arg").append(++cnt);
                    sep = ", ";
                }
                source.append(");\n");
                if (m.getReturnType().getKind() == TypeKind.VOID) {
                    source.append("    return null;\n");
                } else {
                    source.append("    if (p instanceof org.apidesign.html.boot.spi.Fn.ToJavaScript) {\n");
                    source.append("      $ret = ((org.apidesign.html.boot.spi.Fn.ToJavaScript)p).toJavaScript($ret);\n");
                    source.append("    }\n");
                    source.append("    return $ret;\n");
                }
                if (this.processingEnv.getSourceVersion().compareTo(SourceVersion.RELEASE_7) >= 0) {
                    source.append("    }\n");
                } else {
                    source.append("    } finally {\n");
                    source.append("      a.close();\n");
                    source.append("    }\n");
                }
                source.append("  }\n");
            }
            source.append("}\n");
            String srcName = pkgName + ".$JsCallbacks$";
            try {
                Writer w = this.processingEnv.getFiler().createSourceFile(srcName, map.values().toArray(new Element[map.size()])).openWriter();
                w.write(source.toString());
                w.close();
            }
            catch (IOException ex) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Can't write " + srcName + ": " + ex.getMessage());
            }
        }
    }

    private static String findPkg(Element e) {
        while (e.getKind() != ElementKind.PACKAGE) {
            e = e.getEnclosingElement();
        }
        return ((PackageElement)e).getQualifiedName().toString();
    }

    private class VerifyCallback
    extends JsCallback {
        private final Element e;

        public VerifyCallback(Element e) {
            this.e = e;
        }

        @Override
        protected CharSequence callMethod(String ident, String fqn, String method, String params) {
            TypeElement type = JavaScriptProcesor.this.processingEnv.getElementUtils().getTypeElement(fqn);
            if (type == null) {
                JavaScriptProcesor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Callback to non-existing class " + fqn, this.e);
                return "";
            }
            ExecutableElement found = null;
            StringBuilder foundParams = new StringBuilder();
            for (Element element : type.getEnclosedElements()) {
                if (element.getKind() != ElementKind.METHOD || !element.getSimpleName().contentEquals(method)) continue;
                String paramTypes = this.findParamTypes((ExecutableElement)element);
                if (paramTypes.equals(params)) {
                    found = (ExecutableElement)element;
                    break;
                }
                foundParams.append(paramTypes).append("\n");
            }
            if (found == null) {
                if (foundParams.length() == 0) {
                    JavaScriptProcesor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Callback to class " + fqn + " with unknown method " + method, this.e);
                } else {
                    JavaScriptProcesor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Callback to " + fqn + "." + method + " with wrong parameters: " + params + ". Only known parameters are " + foundParams, this.e);
                }
            } else {
                TreeMap<String, ExecutableElement> mangledOnes = (TreeMap<String, ExecutableElement>)JavaScriptProcesor.this.javacalls.get(JavaScriptProcesor.findPkg(this.e));
                if (mangledOnes == null) {
                    mangledOnes = new TreeMap<String, ExecutableElement>();
                    JavaScriptProcesor.this.javacalls.put(JavaScriptProcesor.findPkg(this.e), mangledOnes);
                }
                String string = JsCallback.mangle(fqn, method, this.findParamTypes(found));
                mangledOnes.put(string, found);
            }
            return "";
        }

        /*
         * WARNING - void declaration
         */
        private String findParamTypes(ExecutableElement method) {
            ExecutableType t = (ExecutableType)method.asType();
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            block10: for (TypeMirror typeMirror : t.getParameterTypes()) {
                void var5_5;
                if (typeMirror.getKind().isPrimitive()) {
                    switch (typeMirror.getKind()) {
                        case INT: {
                            sb.append('I');
                            continue block10;
                        }
                        case BOOLEAN: {
                            sb.append('Z');
                            continue block10;
                        }
                        case BYTE: {
                            sb.append('B');
                            continue block10;
                        }
                        case CHAR: {
                            sb.append('C');
                            continue block10;
                        }
                        case SHORT: {
                            sb.append('S');
                            continue block10;
                        }
                        case DOUBLE: {
                            sb.append('D');
                            continue block10;
                        }
                        case FLOAT: {
                            sb.append('F');
                            continue block10;
                        }
                        case LONG: {
                            sb.append('J');
                            continue block10;
                        }
                    }
                    throw new IllegalStateException("Uknown " + (Object)((Object)typeMirror.getKind()));
                }
                while (var5_5.getKind() == TypeKind.ARRAY) {
                    sb.append('[');
                    TypeMirror typeMirror2 = ((ArrayType)var5_5).getComponentType();
                }
                sb.append('L');
                sb.append(var5_5.toString().replace('.', '/'));
                sb.append(';');
            }
            sb.append(')');
            return sb.toString();
        }
    }
}

