/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic;

import org.numenta.nupic.encoders.CoordinateEncoder;
import org.numenta.nupic.encoders.DateEncoder;
import org.numenta.nupic.encoders.Encoder;
import org.numenta.nupic.encoders.GeospatialCoordinateEncoder;
import org.numenta.nupic.encoders.RandomDistributedScalarEncoder;
import org.numenta.nupic.encoders.SDRCategoryEncoder;
import org.numenta.nupic.encoders.ScalarEncoder;

public enum FieldMetaType {
    STRING("string"),
    DATETIME("datetime"),
    INTEGER("int"),
    FLOAT("float"),
    BOOLEAN("bool"),
    LIST("list"),
    COORD("coord"),
    GEO("geo");

    private String displayString;

    private FieldMetaType(String s) {
        this.displayString = s;
    }

    public Encoder<?> newEncoder() {
        switch (this) {
            case LIST: 
            case STRING: {
                return SDRCategoryEncoder.builder().build();
            }
            case DATETIME: {
                return DateEncoder.builder().build();
            }
            case BOOLEAN: {
                return ScalarEncoder.builder().build();
            }
            case COORD: {
                return CoordinateEncoder.builder().build();
            }
            case GEO: {
                return GeospatialCoordinateEncoder.geobuilder().build();
            }
            case INTEGER: 
            case FLOAT: {
                return RandomDistributedScalarEncoder.builder().build();
            }
        }
        return null;
    }

    public <T> T decodeType(String input, Encoder<?> enc) {
        switch (this) {
            case LIST: 
            case STRING: {
                return (T)input;
            }
            case DATETIME: {
                return (T)((DateEncoder)enc).parse(input);
            }
            case BOOLEAN: {
                return (T)(Boolean.valueOf(input) == true ? new Integer(1) : new Integer(0));
            }
            case COORD: 
            case GEO: {
                return (T)new double[]{Double.parseDouble(input.split("\\;")[0]), Double.parseDouble(input.split("\\;")[1])};
            }
            case INTEGER: 
            case FLOAT: {
                return (T)new Double(input);
            }
        }
        return null;
    }

    public String display() {
        return this.displayString;
    }

    public static FieldMetaType fromString(Object s) {
        String val;
        switch (val = s.toString().toLowerCase()) {
            case "char": 
            case "string": 
            case "category": {
                return STRING;
            }
            case "date": 
            case "date time": 
            case "datetime": 
            case "time": {
                return DATETIME;
            }
            case "int": 
            case "integer": 
            case "long": {
                return INTEGER;
            }
            case "double": 
            case "float": 
            case "number": 
            case "numeral": 
            case "num": 
            case "scalar": 
            case "floating point": {
                return FLOAT;
            }
            case "bool": 
            case "boolean": {
                return BOOLEAN;
            }
            case "list": {
                return LIST;
            }
            case "geo": {
                return GEO;
            }
            case "coord": {
                return COORD;
            }
        }
        return FLOAT;
    }
}

