/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.algorithms;

import gnu.trove.list.TDoubleList;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.numenta.nupic.algorithms.AnomalyLikelihood;
import org.numenta.nupic.algorithms.MovingAverage;
import org.numenta.nupic.algorithms.Sample;
import org.numenta.nupic.util.ArrayUtils;

public abstract class Anomaly {
    public static final int VALUE_NONE = -1;
    public static final String KEY_MODE = "mode".intern();
    public static final String KEY_LEARNING_PERIOD = "claLearningPeriod";
    public static final String KEY_ESTIMATION_SAMPLES = "estimationSamples";
    public static final String KEY_USE_MOVING_AVG = "useMovingAverage";
    public static final String KEY_WINDOW_SIZE = "windowSize".intern();
    public static final String KEY_IS_WEIGHTED = "isWeighted";
    public static final String KEY_DIST = "distribution".intern();
    public static final String KEY_MVG_AVG = "movingAverage".intern();
    public static final String KEY_HIST_LIKE = "historicalLikelihoods".intern();
    public static final String KEY_HIST_VALUES = "historicalValues".intern();
    public static final String KEY_TOTAL = "total".intern();
    public static final String KEY_MEAN = "mean".intern();
    public static final String KEY_STDEV = "stdev".intern();
    public static final String KEY_VARIANCE = "variance".intern();
    protected MovingAverage movingAverage;
    protected boolean useMovingAverage;

    public Anomaly() {
        this(false, -1);
    }

    protected Anomaly(boolean useMovingAverage, int windowSize) {
        this.useMovingAverage = useMovingAverage;
        if (this.useMovingAverage) {
            if (windowSize < 1) {
                throw new IllegalArgumentException("Window size must be > 0, when using moving average.");
            }
            this.movingAverage = new MovingAverage(null, windowSize);
        }
    }

    public static Anomaly create() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(KEY_MODE, (Object)Mode.PURE);
        return Anomaly.create(params);
    }

    public static Anomaly create(Map<String, Object> params) {
        boolean useMovingAvg = (Boolean)params.getOrDefault(KEY_USE_MOVING_AVG, false);
        int windowSize = (Integer)params.getOrDefault(KEY_WINDOW_SIZE, -1);
        if (useMovingAvg && windowSize < 1) {
            throw new IllegalArgumentException("windowSize must be > 0, when using moving average.");
        }
        Mode mode = (Mode)((Object)params.get(KEY_MODE));
        if (mode == null) {
            throw new IllegalArgumentException("MODE cannot be null.");
        }
        switch (mode) {
            case PURE: {
                return new Anomaly(useMovingAvg, windowSize){

                    @Override
                    public double compute(int[] activeColumns, int[] predictedColumns, double inputValue, long timestamp) {
                        double retVal = 1.computeRawAnomalyScore(activeColumns, predictedColumns);
                        if (this.useMovingAverage) {
                            retVal = this.movingAverage.next(retVal);
                        }
                        return retVal;
                    }
                };
            }
            case LIKELIHOOD: 
            case WEIGHTED: {
                boolean isWeighted = (Boolean)params.getOrDefault(KEY_IS_WEIGHTED, false);
                int claLearningPeriod = (Integer)params.getOrDefault(KEY_LEARNING_PERIOD, -1);
                int estimationSamples = (Integer)params.getOrDefault(KEY_ESTIMATION_SAMPLES, -1);
                return new AnomalyLikelihood(useMovingAvg, windowSize, isWeighted, claLearningPeriod, estimationSamples);
            }
        }
        return null;
    }

    public static double computeRawAnomalyScore(int[] activeColumns, int[] prevPredictedColumns) {
        double score = 0.0;
        int nActiveColumns = activeColumns.length;
        if (nActiveColumns > 0) {
            score = ArrayUtils.in1d(activeColumns, prevPredictedColumns).length;
            score = ((double)nActiveColumns - score) / (double)nActiveColumns;
        } else if (prevPredictedColumns.length > 0) {
            score = 1.0;
        }
        return score;
    }

    public abstract double compute(int[] var1, int[] var2, double var3, long var5);

    public class AveragedAnomalyRecordList {
        List<Sample> averagedRecords;
        TDoubleList historicalValues;
        double total;

        public AveragedAnomalyRecordList(List<Sample> averagedRecords, TDoubleList historicalValues, double total) {
            this.averagedRecords = averagedRecords;
            this.historicalValues = historicalValues;
            this.total = total;
        }

        public TDoubleList getMetrics() {
            TDoubleArrayList retVal = new TDoubleArrayList();
            for (Sample s : this.averagedRecords) {
                retVal.add(s.score);
            }
            return retVal;
        }

        public TDoubleList getSamples() {
            TDoubleArrayList retVal = new TDoubleArrayList();
            for (Sample s : this.averagedRecords) {
                retVal.add(s.value);
            }
            return retVal;
        }

        public int size() {
            return this.averagedRecords.size();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.averagedRecords == null ? 0 : this.averagedRecords.hashCode());
            result = 31 * result + (this.historicalValues == null ? 0 : this.historicalValues.hashCode());
            long temp = Double.doubleToLongBits(this.total);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AveragedAnomalyRecordList other = (AveragedAnomalyRecordList)obj;
            if (this.averagedRecords == null ? other.averagedRecords != null : !this.averagedRecords.equals(other.averagedRecords)) {
                return false;
            }
            if (this.historicalValues == null ? other.historicalValues != null : !this.historicalValues.equals(other.historicalValues)) {
                return false;
            }
            return Double.doubleToLongBits(this.total) == Double.doubleToLongBits(other.total);
        }
    }

    public static enum Mode {
        PURE,
        LIKELIHOOD,
        WEIGHTED;

    }
}

