/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.algorithms;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Arrays;
import org.numenta.nupic.algorithms.BitHistory;
import org.numenta.nupic.algorithms.CLAClassifier;
import org.numenta.nupic.util.Tuple;

public class CLAClassifierSerializer
extends JsonSerializer<CLAClassifier> {
    public void serialize(CLAClassifier cla, JsonGenerator jgen, SerializerProvider arg2) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        jgen.writeNumberField("alpha", cla.alpha);
        jgen.writeNumberField("actValueAlpha", cla.actValueAlpha);
        jgen.writeNumberField("learnIteration", cla.learnIteration);
        jgen.writeNumberField("recordNumMinusLearnIteration", cla.recordNumMinusLearnIteration);
        jgen.writeNumberField("maxBucketIdx", cla.maxBucketIdx);
        StringBuilder sb = new StringBuilder();
        for (int i : cla.steps.toArray()) {
            sb.append(i).append(",");
        }
        sb.setLength(sb.length() - 1);
        jgen.writeStringField("steps", sb.toString());
        sb = new StringBuilder();
        Object object = cla.patternNZHistory.iterator();
        while (object.hasNext()) {
            Tuple t = (Tuple)object.next();
            sb.append(t.get(0)).append("-").append(Arrays.toString((int[])t.get(1))).append(";");
        }
        sb.setLength(sb.length() - 1);
        jgen.writeStringField("patternNZHistory", sb.toString());
        sb = new StringBuilder();
        for (Tuple t : cla.activeBitHistory.keySet()) {
            sb.append(t.get(0)).append(",").append(t.get(1)).append("-");
            BitHistory bh = cla.activeBitHistory.get(t);
            sb.append(bh.id).append("=").append(bh.stats).append("=").append(bh.lastTotalUpdate).append(";");
        }
        sb.setLength(sb.length() - 1);
        jgen.writeStringField("activeBitHistory", sb.toString());
        jgen.writeArrayFieldStart("actualValues");
        for (Object o : cla.actualValues) {
            jgen.writeObject(o);
        }
        jgen.writeEndArray();
        jgen.writeEndObject();
    }
}

