/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.datagen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.numenta.nupic.util.MersenneTwister;

public class PatternMachine {
    protected int numPatterns = 100;
    protected int n;
    protected int w;
    protected Random random;
    protected Map<Integer, LinkedHashSet<Integer>> patterns;
    protected static final int SEED = 42;

    public PatternMachine(int n, int w) {
        this(n, w, 42);
    }

    public PatternMachine(int n, int w, int seed) {
        this.n = n;
        this.w = w;
        this.random = new MersenneTwister(new int[]{seed});
        this.patterns = new LinkedHashMap<Integer, LinkedHashSet<Integer>>();
        this.generate();
    }

    public void generate() {
        for (int i = 0; i < this.numPatterns; ++i) {
            LinkedHashSet<Integer> pattern = this.sample(new ArrayList<Integer>(this.xrange(0, this.n)), this.w);
            this.patterns.put(i, pattern);
        }
    }

    public LinkedHashSet<Integer> get(int key) {
        return this.patterns.get(key);
    }

    public LinkedHashSet<Integer> numbersForBit(int bit) {
        LinkedHashSet<Integer> retVal = new LinkedHashSet<Integer>();
        for (Integer i : this.patterns.keySet()) {
            if (!this.patterns.get(i).contains(bit)) continue;
            retVal.add(i);
        }
        return retVal;
    }

    public Map<Integer, Set<Integer>> numberMapForBits(Set<Integer> bits) {
        TreeMap<Integer, Set<Integer>> numberMap = new TreeMap<Integer, Set<Integer>>();
        for (Integer bit : bits) {
            LinkedHashSet<Integer> numbers = this.numbersForBit(bit);
            for (Integer number : numbers) {
                HashSet<Integer> set = null;
                set = (HashSet<Integer>)numberMap.get(number);
                if (set == null) {
                    set = new HashSet<Integer>();
                    numberMap.put(number, set);
                }
                set.add(bit);
            }
        }
        return numberMap;
    }

    public String prettyPrintPattern(Set<Integer> bits, int verbosity) {
        Map<Integer, Set<Integer>> numberMap = this.numberMapForBits(bits);
        String text = null;
        ArrayList<String> numberList = new ArrayList<String>();
        LinkedHashMap<Integer, LinkedHashSet<Integer>> numberItems = this.sortedMap(numberMap);
        for (Integer number : numberItems.keySet()) {
            String numberText = null;
            numberText = verbosity > 2 ? number + " (bits: " + numberItems.get(number) + ")" : (verbosity > 1 ? number + " (" + numberItems.get(number).size() + "bits)" : "" + number);
            numberList.add(numberText);
        }
        text = ((Object)numberList).toString();
        return text;
    }

    public LinkedHashMap<Integer, LinkedHashSet<Integer>> sortedMap(final Map<Integer, Set<Integer>> map) {
        LinkedHashMap<Integer, LinkedHashSet<Integer>> retVal = new LinkedHashMap<Integer, LinkedHashSet<Integer>>();
        ArrayList<Integer> sortByKeys = new ArrayList<Integer>(map.keySet());
        Collections.sort(sortByKeys, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                int len1;
                int len0 = ((Set)map.get(arg0)).size();
                return len0 == (len1 = ((Set)map.get(arg1)).size()) ? 0 : (len0 > len1 ? -1 : 1);
            }
        });
        for (Integer key : sortByKeys) {
            retVal.put(key, new LinkedHashSet(map.get(key)));
        }
        return retVal;
    }

    public LinkedHashSet<Integer> xrange(int start, int upperBounds) {
        LinkedHashSet<Integer> retVal = new LinkedHashSet<Integer>();
        for (int i = start; i < upperBounds; ++i) {
            retVal.add(i);
        }
        return retVal;
    }

    public LinkedHashSet<Integer> sample(List<Integer> population, int num) {
        ArrayList<Integer> retVal = new ArrayList<Integer>();
        int len = population.size();
        for (int i = 0; i < num; ++i) {
            int j = (int)(this.random.nextDouble() * (double)(len - i));
            retVal.add(population.get(j));
            population.set(j, population.get(len - i - 1));
        }
        Collections.sort(retVal);
        return new LinkedHashSet<Integer>(retVal);
    }
}

