/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.datagen;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.numenta.nupic.datagen.PatternMachine;

public class SequenceMachine {
    private PatternMachine patternMachine;
    public static final Set<Integer> NONE = new HashSet<Integer>(){
        private static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return "None";
        }
    };

    public SequenceMachine(PatternMachine pMachine) {
        this.patternMachine = pMachine;
    }

    public List<Set<Integer>> generateFromNumbers(List<Integer> numbers) {
        ArrayList<Set<Integer>> sequence = new ArrayList<Set<Integer>>();
        for (Integer i : numbers) {
            if (i == -1) {
                sequence.add(NONE);
                continue;
            }
            LinkedHashSet<Integer> pattern = this.patternMachine.get(i);
            sequence.add(pattern);
        }
        return sequence;
    }

    public String prettyPrintSequence(List<Set<Integer>> sequence, int verbosity) {
        String text = "";
        for (int i = 0; i < sequence.size(); ++i) {
            Set<Integer> pattern = sequence.get(i);
            if (pattern == NONE) {
                text = text + "<reset>";
                if (i >= sequence.size() - 1) continue;
                text = text + "\n";
                continue;
            }
            text = text + this.patternMachine.prettyPrintPattern(pattern, verbosity);
        }
        return text;
    }
}

