/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.encoders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.numenta.nupic.encoders.AdaptiveScalarEncoder;
import org.numenta.nupic.encoders.Encoder;
import org.numenta.nupic.encoders.EncoderResult;

public class DeltaEncoder
extends AdaptiveScalarEncoder {
    public double prevAbsolute = 0.0;
    public double prevDelta = 0.0;
    public boolean stateLock = false;

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void initEncoder(int w, double minVal, double maxVal, int n, double radius, double resolution) {
        super.initEncoder(w, minVal, maxVal, n, radius, resolution);
    }

    public static Builder deltaBuilder() {
        return new Builder();
    }

    @Override
    public void encodeIntoArray(Double input, int[] output) {
        if (!(input instanceof Double)) {
            throw new IllegalArgumentException(String.format("Expected a Double input but got input of type %s", input.toString()));
        }
        double delta = 0.0;
        if (input == Double.NaN) {
            output = new int[this.n];
            Arrays.fill(output, 0);
        } else {
            if (this.prevAbsolute == 0.0) {
                this.prevAbsolute = input;
            }
            delta = input - this.prevAbsolute;
            super.encodeIntoArray(input, output);
        }
        if (!this.stateLock) {
            this.prevAbsolute = input;
            this.prevDelta = delta;
        }
    }

    public boolean isStateLock() {
        return this.stateLock;
    }

    public void setStateLock(boolean stateLock) {
        this.stateLock = stateLock;
    }

    public void setFieldStats(String fieldName, String[] fieldParameters) {
    }

    @Override
    public boolean isDelta() {
        return true;
    }

    @Override
    public List<EncoderResult> getBucketInfo(int[] buckets) {
        return super.getBucketInfo(buckets);
    }

    @Override
    public List<EncoderResult> topDownCompute(int[] encoded) {
        if (this.prevAbsolute == 0.0 || this.prevDelta == 0.0) {
            int[] initialBuckets = new int[this.n];
            Arrays.fill(initialBuckets, 0);
            ArrayList<EncoderResult> encoderResultList = new ArrayList<EncoderResult>();
            EncoderResult encoderResult = new EncoderResult((Object)0, 0, initialBuckets);
            encoderResultList.add(encoderResult);
            return encoderResultList;
        }
        List<EncoderResult> erList = super.topDownCompute(encoded);
        if (this.prevAbsolute != 0.0) {
            double objVal = (Double)erList.get(0).getValue() + this.prevAbsolute;
            double objScalar = erList.get(0).getScalar().doubleValue() + this.prevAbsolute;
            ArrayList<EncoderResult> encoderResultList = new ArrayList<EncoderResult>();
            EncoderResult encoderResult = new EncoderResult((Object)objVal, objScalar, erList.get(0).getEncoding());
            encoderResultList.add(encoderResult);
            return encoderResultList;
        }
        return erList;
    }

    public static class Builder
    extends Encoder.Builder<Builder, DeltaEncoder> {
        private Builder() {
        }

        @Override
        public DeltaEncoder build() {
            this.encoder = new DeltaEncoder();
            super.build();
            ((DeltaEncoder)this.encoder).init();
            return (DeltaEncoder)this.encoder;
        }
    }
}

