/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.encoders;

import org.numenta.nupic.encoders.CoordinateEncoder;
import org.numenta.nupic.encoders.Encoder;
import org.numenta.nupic.util.Tuple;

public class GeospatialCoordinateEncoder
extends CoordinateEncoder {
    private int scale;
    private int timestep;

    public GeospatialCoordinateEncoder() {
        Tuple desc = new Tuple("longitude", 0);
        Tuple desc2 = new Tuple("lattitude", 1);
        Tuple desc3 = new Tuple("speed", 2);
        this.description.add(desc);
        this.description.add(desc2);
        this.description.add(desc3);
    }

    public static Builder geobuilder() {
        return new Builder();
    }

    @Override
    public void encodeIntoArray(Tuple inputData, int[] output) {
        double longitude = (Double)inputData.get(0);
        double lattitude = (Double)inputData.get(1);
        double speed = (Double)inputData.get(2);
        int[] coordinate = this.coordinateForPosition(longitude, lattitude);
        double radius = this.radiusForSpeed(speed);
        super.encodeIntoArray(new Tuple(coordinate, radius), output);
    }

    public int[] coordinateForPosition(double longitude, double lattitude) {
        double[] coordinate = this.toMercator(longitude, lattitude);
        coordinate[0] = coordinate[0] / (double)this.scale;
        coordinate[1] = coordinate[1] / (double)this.scale;
        return new int[]{(int)coordinate[0], (int)coordinate[1]};
    }

    protected double[] toMercator(double lon, double lat) {
        double x = lon * 2.003750834E7 / 180.0;
        double y = Math.log(Math.tan((90.0 + lat) * Math.PI / 360.0)) / (Math.PI / 180);
        y = y * 2.003750834E7 / 180.0;
        return new double[]{x, y};
    }

    protected double[] inverseMercator(double x, double y) {
        double lon = x / 2.003750834E7 * 180.0;
        double lat = y / 2.003750834E7 * 180.0;
        lat = 57.29577951308232 * (2.0 * Math.atan(Math.exp(lat * Math.PI / 180.0)) - 1.5707963267948966);
        return new double[]{lon, lat};
    }

    public double radiusForSpeed(double speed) {
        double overlap = 1.5;
        double coordinatesPerTimestep = speed * (double)this.timestep / (double)this.scale;
        int radius = (int)Math.round(coordinatesPerTimestep / 2.0 * overlap);
        int minRadius = (int)Math.ceil((Math.sqrt(this.w) - 1.0) / 2.0);
        return Math.max(radius, minRadius);
    }

    public static class Builder
    extends Encoder.Builder<Builder, GeospatialCoordinateEncoder> {
        private int scale;
        private int timestep;

        private Builder() {
        }

        @Override
        public GeospatialCoordinateEncoder build() {
            this.encoder = new GeospatialCoordinateEncoder();
            super.build();
            if (this.scale == 0 || this.timestep == 0) {
                throw new IllegalStateException("Scale or Timestep not set");
            }
            ((GeospatialCoordinateEncoder)this.encoder).scale = this.scale;
            ((GeospatialCoordinateEncoder)this.encoder).timestep = this.timestep;
            if (this.w <= 0 || this.w % 2 == 0) {
                throw new IllegalArgumentException("w must be odd, and must be a positive integer");
            }
            if (this.n <= 6 * this.w) {
                throw new IllegalArgumentException("n must be an int strictly greater than 6*w. For good results we recommend n be strictly greater than 11*w");
            }
            if (this.name == null || this.name.equals("None")) {
                this.name = "[" + this.n + ":" + this.w + "]";
            }
            return (GeospatialCoordinateEncoder)this.encoder;
        }

        public Builder scale(int scale) {
            this.scale = scale;
            return this;
        }

        public Builder timestep(int timestep) {
            this.timestep = timestep;
            return this;
        }
    }
}

