/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.encoders;

import gnu.trove.list.TDoubleList;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.numenta.nupic.FieldMetaType;
import org.numenta.nupic.encoders.DecodeResult;
import org.numenta.nupic.encoders.Encoder;
import org.numenta.nupic.encoders.EncoderResult;
import org.numenta.nupic.encoders.RangeList;
import org.numenta.nupic.encoders.ScalarEncoder;
import org.numenta.nupic.util.MinMax;
import org.numenta.nupic.util.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogEncoder
extends Encoder<Double> {
    private static final Logger LOG = LoggerFactory.getLogger(LogEncoder.class);
    private ScalarEncoder encoder;
    private double minScaledValue;
    private double maxScaledValue;

    LogEncoder() {
    }

    public static Encoder.Builder<Builder, LogEncoder> builder() {
        return new Builder();
    }

    public void init() {
        double lowLimit = 1.0E-7;
        if (this.getW() == 0) {
            this.setW(5);
        }
        if (this.getMaxVal() == 0.0) {
            this.setMaxVal(10000.0);
        }
        if (this.getMinVal() < lowLimit) {
            this.setMinVal(lowLimit);
        }
        if (this.getMinVal() >= this.getMaxVal()) {
            throw new IllegalStateException("Max val must be larger than min val or the lower limit for this encoder " + String.format("%.7f", lowLimit));
        }
        this.minScaledValue = Math.log10(this.getMinVal());
        this.maxScaledValue = Math.log10(this.getMaxVal());
        if (this.minScaledValue >= this.maxScaledValue) {
            throw new IllegalStateException("Max val must be larger, in log space, than min val.");
        }
        this.encoder = ((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)ScalarEncoder.builder().w(this.getW()).minVal(this.minScaledValue)).maxVal(this.maxScaledValue)).periodic(false)).n(this.getN())).radius(this.getRadius())).resolution(this.getResolution())).clipInput(this.clipInput())).forced(this.isForced())).name(this.getName())).build();
        this.setN(this.encoder.getN());
        this.setResolution(this.encoder.getResolution());
        this.setRadius(this.encoder.getRadius());
    }

    @Override
    public int getWidth() {
        return this.encoder.getWidth();
    }

    @Override
    public boolean isDelta() {
        return this.encoder.isDelta();
    }

    @Override
    public List<Tuple> getDescription() {
        return this.encoder.getDescription();
    }

    @Override
    public Set<FieldMetaType> getDecoderOutputFieldTypes() {
        return this.encoder.getDecoderOutputFieldTypes();
    }

    private Double getScaledValue(double input) {
        if (input == Double.NaN) {
            return null;
        }
        double val = input;
        if (val < this.getMinVal()) {
            val = this.getMinVal();
        } else if (val > this.getMaxVal()) {
            val = this.getMaxVal();
        }
        return Math.log10(val);
    }

    @Override
    public int[] getBucketIndices(double input) {
        Double scaledVal = this.getScaledValue(input);
        if (scaledVal == null) {
            return new int[0];
        }
        return this.encoder.getBucketIndices(scaledVal);
    }

    @Override
    public void encodeIntoArray(Double input, int[] output) {
        Double scaledVal = this.getScaledValue(input);
        if (scaledVal == null) {
            Arrays.fill(output, 0);
        } else {
            this.encoder.encodeIntoArray(scaledVal, output);
            LOG.trace("input: " + input);
            LOG.trace(" scaledVal: " + scaledVal);
            LOG.trace(" output: " + Arrays.toString(output));
        }
    }

    @Override
    public DecodeResult decode(int[] encoded, String parentFieldName) {
        DecodeResult decodeResult = this.encoder.decode(encoded, parentFieldName);
        Map<String, RangeList> fields = decodeResult.getFields();
        if (fields.keySet().size() == 0) {
            return decodeResult;
        }
        RangeList inRanges = (RangeList)fields.values().toArray()[0];
        RangeList outRanges = new RangeList((List<MinMax>)new ArrayList<MinMax>(), "");
        for (MinMax minMax : inRanges.getRanges()) {
            MinMax scaledMinMax = new MinMax(Math.pow(10.0, minMax.min()), Math.pow(10.0, minMax.max()));
            outRanges.add(scaledMinMax);
        }
        String desc = "";
        int numRanges = outRanges.size();
        for (int i = 0; i < numRanges; ++i) {
            MinMax minMax = outRanges.getRange(i);
            desc = minMax.min() != minMax.max() ? desc + String.format("%.2f-%.2f", minMax.min(), minMax.max()) : desc + String.format("%.2f", minMax.min());
            if (i >= numRanges - 1) continue;
            desc = desc + ", ";
        }
        outRanges.setDescription(desc);
        String fieldName = !parentFieldName.equals("") ? String.format("%s.%s", parentFieldName, this.getName()) : this.getName();
        HashMap<String, RangeList> outFields = new HashMap<String, RangeList>();
        outFields.put(fieldName, outRanges);
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add(fieldName);
        return new DecodeResult((Map<String, RangeList>)outFields, (List<String>)fieldNames);
    }

    @Override
    public <S> List<S> getBucketValues(Class<S> t) {
        if (this.bucketValues == null) {
            List<S> scaledValues = this.encoder.getBucketValues(t);
            this.bucketValues = new ArrayList();
            for (S scaledValue : scaledValues) {
                double value = Math.pow(10.0, (Double)scaledValue);
                this.bucketValues.add(value);
            }
        }
        return this.bucketValues;
    }

    @Override
    public List<EncoderResult> getBucketInfo(int[] buckets) {
        EncoderResult scaledResult = this.encoder.getBucketInfo(buckets).get(0);
        double scaledValue = (Double)scaledResult.getValue();
        double value = Math.pow(10.0, scaledValue);
        return Arrays.asList(new EncoderResult((Object)value, value, scaledResult.getEncoding()));
    }

    @Override
    public List<EncoderResult> topDownCompute(int[] encoded) {
        EncoderResult scaledResult = this.encoder.topDownCompute(encoded).get(0);
        double scaledValue = (Double)scaledResult.getValue();
        double value = Math.pow(10.0, scaledValue);
        return Arrays.asList(new EncoderResult((Object)value, value, scaledResult.getEncoding()));
    }

    @Override
    public TDoubleList closenessScores(TDoubleList expValues, TDoubleList actValues, boolean fractional) {
        double closeness;
        TDoubleArrayList retVal = new TDoubleArrayList();
        double expValue = expValues.get(0) > 0.0 ? Math.log10(expValues.get(0)) : this.minScaledValue;
        double actValue = actValues.get(0) > 0.0 ? Math.log10(actValues.get(0)) : this.minScaledValue;
        if (fractional) {
            double err = Math.abs(expValue - actValue);
            double pctErr = err / (this.maxScaledValue - this.minScaledValue);
            pctErr = Math.min(1.0, pctErr);
            closeness = 1.0 - pctErr;
        } else {
            closeness = Math.abs(expValue - actValue);
        }
        retVal.add(closeness);
        return retVal;
    }

    public static class Builder
    extends Encoder.Builder<Builder, LogEncoder> {
        private Builder() {
        }

        @Override
        public LogEncoder build() {
            this.encoder = new LogEncoder();
            super.build();
            ((LogEncoder)this.encoder).init();
            return (LogEncoder)this.encoder;
        }
    }
}

