/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.encoders;

import java.util.Arrays;
import org.numenta.nupic.encoders.Encoder;
import org.numenta.nupic.encoders.PassThroughEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparsePassThroughEncoder
extends PassThroughEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparsePassThroughEncoder.class);

    private SparsePassThroughEncoder() {
    }

    public SparsePassThroughEncoder(int outputWidth, Integer outputBitsOnCount) {
        super(outputWidth, outputBitsOnCount);
        LOGGER.info("Building new SparsePassThroughEncoder instance, outputWidth: {} outputBitsOnCount: {}", (Object)outputWidth);
    }

    public static Encoder.Builder<Builder, SparsePassThroughEncoder> sparseBuilder() {
        return new Builder();
    }

    @Override
    public void encodeIntoArray(int[] input, int[] output) {
        int[] denseInput = new int[output.length];
        for (int i : input) {
            if (i > denseInput.length) {
                throw new IllegalArgumentException(String.format("Output bit count set too low, need at least %d bits", i));
            }
            denseInput[i] = 1;
        }
        super.encodeIntoArray(denseInput, output);
        LOGGER.trace("Input: {} \nOutput: {} \n", (Object)Arrays.toString(input), (Object)Arrays.toString(output));
    }

    public static class Builder
    extends Encoder.Builder<Builder, SparsePassThroughEncoder> {
        private Builder() {
        }

        @Override
        public SparsePassThroughEncoder build() {
            this.encoder = new SparsePassThroughEncoder();
            super.build();
            ((SparsePassThroughEncoder)this.encoder).init();
            return (SparsePassThroughEncoder)this.encoder;
        }
    }
}

