/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.examples.cortical_io.breakingnews;

import io.cortical.fx.webstyle.RadiusFlipPane;
import io.cortical.fx.webstyle.example.FingerprintPane;
import io.cortical.fx.webstyle.example.TriplePanel;
import io.cortical.rest.model.Fingerprint;
import io.cortical.rest.model.Metric;
import io.cortical.services.RetinaApis;
import io.cortical.twitter.Algorithm;
import io.cortical.twitter.Tweet;
import io.cortical.twitter.TweetUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.StringProperty;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.util.Pair;
import org.numenta.nupic.Parameters;
import org.numenta.nupic.examples.cortical_io.breakingnews.BreakingNewsDemoView;
import org.numenta.nupic.examples.cortical_io.breakingnews.StrictHackathonAlgorithm;
import org.numenta.nupic.network.Network;
import org.numenta.nupic.research.TemporalMemory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BreakingNewsDemo
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(BreakingNewsDemo.class);
    private static final String RETINA_NAME = "en_associative";
    private static final String RETINA_IP = "api.cortical.io";
    private String apiKey;
    private Stream<String> dataStream;
    private List<String> jsonList = new ArrayList<String>();
    private Algorithm algo;
    private int cursor = 0;
    private boolean isStopped = true;
    private BreakingNewsDemoView.Mode mode;
    private BreakingNewsDemoView view;
    private LinkedBlockingQueue<Pair<String, Integer>> queue = new LinkedBlockingQueue();
    private int recordNum;
    private ScrollPane mainViewScroll;

    public void runAlgorithm(Algorithm algo, Stream<String> input) {
        input.forEach(s -> this.runOne(algo, (String)s));
    }

    public void runOne(Algorithm algo, String jsonEntry) {
        algo.compute(Tweet.fromJson((String)jsonEntry, (int)this.recordNum++));
    }

    public Parameters getHTMParameters() {
        Parameters p = Parameters.getAllDefaultParameters();
        p.setParameterByKey(Parameters.KEY.GLOBAL_INHIBITIONS, true);
        p.setParameterByKey(Parameters.KEY.COLUMN_DIMENSIONS, new int[]{16384});
        p.setParameterByKey(Parameters.KEY.INPUT_DIMENSIONS, new int[]{16384});
        p.setParameterByKey(Parameters.KEY.CELLS_PER_COLUMN, 32);
        p.setParameterByKey(Parameters.KEY.NUM_ACTIVE_COLUMNS_PER_INH_AREA, 40.0);
        p.setParameterByKey(Parameters.KEY.POTENTIAL_PCT, 0.8);
        p.setParameterByKey(Parameters.KEY.SYN_PERM_CONNECTED, 0.1);
        p.setParameterByKey(Parameters.KEY.SYN_PERM_ACTIVE_INC, 1.0E-4);
        p.setParameterByKey(Parameters.KEY.SYN_PERM_INACTIVE_DEC, 5.0E-4);
        p.setParameterByKey(Parameters.KEY.MAX_BOOST, 1.0);
        p.setParameterByKey(Parameters.KEY.LEARNING_RADIUS, 2048);
        p.setParameterByKey(Parameters.KEY.CONNECTED_PERMANENCE, 0.5);
        p.setParameterByKey(Parameters.KEY.MAX_NEW_SYNAPSE_COUNT, 20);
        p.setParameterByKey(Parameters.KEY.INITIAL_PERMANENCE, 0.21);
        p.setParameterByKey(Parameters.KEY.PERMANENCE_INCREMENT, 0.1);
        p.setParameterByKey(Parameters.KEY.PERMANENCE_DECREMENT, 0.1);
        p.setParameterByKey(Parameters.KEY.MIN_THRESHOLD, 9);
        p.setParameterByKey(Parameters.KEY.ACTIVATION_THRESHOLD, 12);
        p.setParameterByKey(Parameters.KEY.CLIP_INPUT, false);
        return p;
    }

    public Stream<String> getFileStream(String path) {
        try {
            return Files.lines(new File(path).toPath());
        }
        catch (IOException e) {
            LOGGER.error("Failed to load indicated file: " + path);
            try {
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/BBCBreaking.txt");
                return new BufferedReader(new InputStreamReader(is)).lines();
            }
            catch (Exception ex) {
                LOGGER.error("Failed secondary attempt from jar.");
                return Arrays.stream(new String[0]);
            }
        }
    }

    public Stream<String> createDataStream() {
        if (this.dataStream != null) {
            this.dataStream.close();
        }
        this.dataStream = this.getFileStream("./src/main/resources/BBCBreaking.txt");
        this.dataStream = TweetUtilities.getSortedStream(this.dataStream);
        return this.dataStream;
    }

    public void start() {
        this.isStopped = false;
        if (this.jsonList == null || this.jsonList.isEmpty()) {
            this.jsonList = this.createDataStream().collect(Collectors.toList());
        }
        if (this.cursor == this.jsonList.size() - 1) {
            return;
        }
        if (this.mode == BreakingNewsDemoView.Mode.AUTO) {
            this.createRunner().start();
            new Thread(){

                @Override
                public void run() {
                    while (BreakingNewsDemo.this.cursor < BreakingNewsDemo.this.jsonList.size()) {
                        if (BreakingNewsDemo.this.isStopped) {
                            BreakingNewsDemo.this.stop();
                            break;
                        }
                        BreakingNewsDemo.this.queue.offer(new Pair(BreakingNewsDemo.this.jsonList.get(BreakingNewsDemo.this.cursor), (Object)BreakingNewsDemo.this.cursor));
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        BreakingNewsDemo.this.cursor++;
                    }
                }
            }.start();
        } else {
            this.view.runDisableProperty().set(false);
        }
    }

    public void stop() {
        this.isStopped = true;
        this.view.runDisableProperty().set(true);
    }

    public Thread createRunner() {
        return new Thread(() -> {
            while (!this.isStopped) {
                while (this.queue.size() > 0) {
                    try {
                        Pair<String, Integer> entry = this.queue.take();
                        this.runOne((String)entry.getKey(), (Integer)entry.getValue());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void runOne(String json, int index) {
        this.runOne(this.algo, json);
        double result = this.algo.getAnomaly();
        Tweet tweet = this.algo.getCurrentTweet();
        int[] prediction = this.algo.getPrevPrediction();
        Platform.runLater(() -> {
            this.updateTweetDisplay(tweet);
            this.updateChart(tweet, result);
            this.popuplateFingerPrintDisplay(tweet, prediction);
            this.logActivity(tweet);
        });
    }

    private void updateTweetDisplay(Tweet tweet) {
        ((TextArea)((Pair)this.view.inputPaneProperty().get()).getKey()).setText(tweet.getJson());
        ((TextArea)((Pair)this.view.inputPaneProperty().get()).getValue()).setText(tweet.getText());
        ((StringProperty)this.view.currentLabelProperty().get()).set((Object)("Current Tweet: " + tweet.getRecordNum()));
        ((Label)this.view.queueDisplayProperty().get()).textProperty().set((Object)("Processing Queue Size: " + this.queue.size()));
    }

    private void updateChart(Tweet tweet, double result) {
        String[] dateStr = TweetUtilities.getJsonNode((String)tweet.getJson()).get("created_at").asText().split("\\s");
        String day = dateStr[0].concat(", ").concat(dateStr[1]).concat(" ").concat(dateStr[2]);
        String time = dateStr[3];
        XYChart.Series series = (XYChart.Series)this.view.chartSeriesProperty().get();
        if (series.getData().size() == 6) {
            series.getData().remove(0);
        }
        series.getData().add((Object)new XYChart.Data((Object)(day + "\n" + time), (Object)result));
    }

    private void popuplateFingerPrintDisplay(Tweet tweet, int[] prediction) {
        TriplePanel panel = (TriplePanel)this.view.fingerprintPanelProperty().get();
        ((FingerprintPane)panel.getLeftPane()).setSDR(((Fingerprint)tweet.getFingerprints().get(0)).getPositions());
        if (prediction != null && prediction.length > 0) {
            ((FingerprintPane)panel.getRightPane()).setSDR(prediction);
            ((FingerprintPane)panel.getMiddlePane()).setSDR(((Fingerprint)tweet.getFingerprints().get(0)).getPositions());
            ((FingerprintPane)panel.getMiddlePane()).addSDR(prediction, 1);
        }
    }

    private void logActivity(Tweet tweet) {
        List sims = this.algo.getSimilarityHistory();
        if (sims != null && sims.size() > 0) {
            TextArea similarityArea = (TextArea)this.view.rightActivityPanelProperty().get();
            similarityArea.appendText("\n");
            similarityArea.appendText("==========================\n");
            similarityArea.appendText("[" + tweet.getRecordNum() + "] Similar Tweets:\n");
            for (Tweet t : sims) {
                String[] dStr = TweetUtilities.getJsonNode((String)t.getJson()).get("created_at").asText().split("\\s");
                String d = dStr[0].concat(", ").concat(dStr[1]).concat(" ").concat(dStr[2]);
                String ti = dStr[3];
                similarityArea.appendText("        [" + d + ", " + ti + "] " + t.getText() + "\n");
            }
        }
        TextArea activityArea = (TextArea)this.view.leftActivityPanelProperty().get();
        activityArea.appendText("\n");
        activityArea.appendText("==========================\n");
        activityArea.appendText("[" + tweet.getRecordNum() + "] Anomaly Score: " + tweet.getAnomaly() + "\n");
        Metric metric = this.algo.getSimilarities();
        if (metric != null) {
            activityArea.appendText("    Overlapping Left Right: " + metric.getOverlappingLeftRight() + "\n");
            activityArea.appendText("    Overlapping Right Left: " + metric.getOverlappingRightLeft() + "\n");
            activityArea.appendText("         Euclidean Distance: " + metric.getEuclideanDistance() + "\n");
        }
    }

    public Algorithm createAlgorithm() {
        Parameters p = this.getHTMParameters();
        Network network = Network.create("TestNetwork", p).add(Network.createRegion("R1").add(Network.createLayer("Layer 2/3", p).add(new TemporalMemory())));
        RetinaApis ra = new RetinaApis(RETINA_NAME, RETINA_IP, this.apiKey);
        this.algo = new StrictHackathonAlgorithm(ra, network);
        return this.algo;
    }

    public void configureView() {
        this.view = new BreakingNewsDemoView();
        this.view.autoModeProperty().addListener((v, o, n) -> {
            this.mode = n;
        });
        this.mode = (BreakingNewsDemoView.Mode)((Object)this.view.autoModeProperty().get());
        this.view.startActionProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                if (this.mode == BreakingNewsDemoView.Mode.AUTO) {
                    ++this.cursor;
                }
                this.start();
            } else {
                this.stop();
            }
        });
        this.view.runOneProperty().addListener((v, o, n) -> {
            this.cursor += n.intValue();
            this.runOne(this.jsonList.get(this.cursor), this.cursor);
        });
        this.view.flipStateProperty().addListener((v, o, n) -> ((RadiusFlipPane)this.view.flipPaneProperty().get()).flip());
        this.view.setPrefSize(1370.0, 1160.0);
        this.view.setMinSize(1370.0, 1160.0);
        this.mainViewScroll = new ScrollPane();
        this.mainViewScroll.setViewportBounds((Bounds)new BoundingBox(0.0, 0.0, 1370.0, 1160.0));
        this.mainViewScroll.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.mainViewScroll.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.mainViewScroll.setContent((Node)this.view);
        this.mainViewScroll.viewportBoundsProperty().addListener((v, o, n) -> this.view.setPrefSize(Math.max(1370.0, n.getMaxX()), Math.max(1160.0, n.getMaxY())));
        this.createDataStream();
        this.createAlgorithm();
    }

    public void showView(Stage stage) {
        Scene scene = new Scene((Parent)this.mainViewScroll, 1370.0, 1160.0, (Paint)Color.WHITE);
        stage.setScene(scene);
        stage.setMinWidth(1370.0);
        stage.show();
        Rectangle2D primScreenBounds = Screen.getPrimary().getVisualBounds();
        stage.setX((primScreenBounds.getWidth() - stage.getWidth()) / 2.0);
        stage.setY((primScreenBounds.getHeight() - stage.getHeight()) / 4.0);
    }

    public void start(Stage stage) throws Exception {
        Application.Parameters params = this.getParameters();
        List paramList = params.getUnnamed();
        if (paramList.size() < 1 || !((String)paramList.get(0)).startsWith("-K")) {
            throw new IllegalStateException("Demo must be started with arguments [-K]<your-api-key>");
        }
        this.apiKey = ((String)paramList.get(0)).substring(2);
        this.configureView();
        this.showView(stage);
    }

    public static void main(String[] args) {
        BreakingNewsDemo.launch((String[])args);
    }
}

