/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.examples.cortical_io.breakingnews;

import io.cortical.fx.webstyle.CorticalLogoBackground;
import io.cortical.fx.webstyle.LabelledRadiusPane;
import io.cortical.fx.webstyle.RadiusFlipPane;
import io.cortical.fx.webstyle.SegmentedButtonBar;
import io.cortical.fx.webstyle.example.DualPanel;
import io.cortical.fx.webstyle.example.FingerprintPane;
import io.cortical.fx.webstyle.example.LogoTitlePane;
import io.cortical.fx.webstyle.example.TriplePanel;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.util.Pair;

public class BreakingNewsDemoView
extends GridPane {
    private Button runOneBtn;
    private LineChart<String, Number> chart;
    private XYChart.Series<String, Number> series;
    private Mode mode = Mode.AUTO;
    private FlipState state = FlipState.ON_FRONT;
    private ObjectProperty<Pair<TextArea, TextArea>> inputPaneProperty = new SimpleObjectProperty();
    private BooleanProperty startActionProperty = new SimpleBooleanProperty(false);
    private ObjectProperty<Mode> autoModeProperty = new SimpleObjectProperty((Object)this.mode);
    private IntegerProperty runOneProperty = new SimpleIntegerProperty(-1);
    private ObjectProperty<XYChart.Series<String, Number>> chartSeriesProperty = new SimpleObjectProperty();
    private BooleanProperty runDisableProperty = new SimpleBooleanProperty(true);
    private ObjectProperty<RadiusFlipPane> flipPaneProperty = new SimpleObjectProperty();
    private ObjectProperty<FlipState> flipStateProperty = new SimpleObjectProperty((Object)this.state);
    private ObjectProperty<TriplePanel> fingerprintPanelProperty = new SimpleObjectProperty();
    private ObjectProperty<TextArea> leftActivityPanelProperty = new SimpleObjectProperty();
    private ObjectProperty<TextArea> rightActivityPanelProperty = new SimpleObjectProperty();
    private ObjectProperty<StringProperty> currentLabelProperty = new SimpleObjectProperty();
    private ObjectProperty<Label> queueDisplayProperty = new SimpleObjectProperty();

    public BreakingNewsDemoView() {
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)}));
        HBox h = new HBox();
        h.prefWidthProperty().bind((ObservableValue)this.widthProperty().divide(20));
        h.setFillHeight(true);
        HBox h2 = new HBox();
        h2.prefWidthProperty().bind((ObservableValue)this.widthProperty().divide(20));
        h2.setFillHeight(true);
        StackPane stack = new StackPane();
        stack.prefWidthProperty().bind((ObservableValue)this.widthProperty().multiply(0.9));
        stack.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        CorticalLogoBackground backGround = new CorticalLogoBackground((Region)stack);
        backGround.setOpacity(0.2);
        VBox vBox = new VBox();
        vBox.setSpacing(20.0);
        vBox.prefWidthProperty().bind((ObservableValue)stack.widthProperty());
        vBox.prefHeightProperty().bind((ObservableValue)new SimpleDoubleProperty(100.0));
        LogoTitlePane header = new LogoTitlePane();
        header.setTitleText("Breaking News");
        header.setSubTitleText("a Twitter trend tracking demo...");
        HBox buttonBar = this.createSegmentedButtonBar();
        DualPanel inputPane = this.createInputPane();
        inputPane.panelHeightProperty().setValue((Number)105);
        LabelledRadiusPane chartPane = new LabelledRadiusPane("Trend");
        chartPane.getChildren().add(this.createChart(chartPane));
        SegmentedButtonBar log = this.createShowLogButton(vBox);
        BorderPane logButton = new BorderPane();
        logButton.prefWidthProperty().bind((ObservableValue)vBox.widthProperty());
        logButton.setPrefHeight(10.0);
        logButton.setCenter((Node)log);
        TriplePanel fpDisplay = this.createFingerprintDisplay();
        LabelledRadiusPane loggerPane = this.createActivityPane();
        loggerPane.prefWidthProperty().bind((ObservableValue)fpDisplay.widthProperty());
        loggerPane.prefHeightProperty().bind((ObservableValue)fpDisplay.heightProperty());
        RadiusFlipPane flip = new RadiusFlipPane((Region)fpDisplay, (Region)loggerPane);
        fpDisplay.prefWidthProperty().bind((ObservableValue)vBox.widthProperty());
        this.flipPaneProperty.set((Object)flip);
        vBox.getChildren().addAll((Object[])new Node[]{header, buttonBar, inputPane, chartPane, logButton, flip});
        stack.getChildren().addAll((Object[])new Node[]{backGround, vBox});
        this.add((Node)h, 0, 0);
        this.add((Node)stack, 1, 0);
        this.add((Node)h2, 2, 0);
    }

    public SegmentedButtonBar createShowLogButton(VBox vBox) {
        Button logButton = new Button("Show Activity");
        logButton.getStyleClass().add((Object)"only");
        logButton.setStyle("-fx-font-size: 10; -fx-padding: 4 12 4 12; -fx-height: 10;");
        logButton.setPrefHeight(10.0);
        logButton.setPrefWidth(150.0);
        vBox.widthProperty().addListener((v, o, n) -> logButton.setLayoutX(n.doubleValue() / 2.0 - 75.0));
        logButton.setOnAction(e -> {
            this.state = this.state == FlipState.ON_FRONT ? FlipState.ON_BACK : FlipState.ON_FRONT;
            this.flipStateProperty.set((Object)this.state);
            logButton.setText(this.state == FlipState.ON_FRONT ? "Show Activity" : "Show Fingerprints");
        });
        SegmentedButtonBar buttonBar3 = new SegmentedButtonBar();
        buttonBar3.getChildren().addAll((Object[])new Node[]{logButton});
        buttonBar3.setPrefHeight(10.0);
        return buttonBar3;
    }

    public TriplePanel createFingerprintDisplay() {
        FingerprintPane left2 = this.createFingerprintPane("Fingerprint");
        FingerprintPane middle2 = this.createFingerprintPane("Comparison");
        FingerprintPane right2 = this.createFingerprintPane("Prediction");
        right2.setColorIndex(1);
        TriplePanel fpDisplay = new TriplePanel();
        fpDisplay.setSpacing(10.0);
        fpDisplay.panelHeightProperty().setValue((Number)435);
        fpDisplay.setLeftPane((LabelledRadiusPane)left2);
        fpDisplay.setMiddlePane((LabelledRadiusPane)middle2);
        fpDisplay.setRightPane((LabelledRadiusPane)right2);
        this.fingerprintPanelProperty.set((Object)fpDisplay);
        return fpDisplay;
    }

    public DualPanel createInputPane() {
        DualPanel retVal = new DualPanel();
        LabelledRadiusPane left = new LabelledRadiusPane("Input Tweet");
        TextArea lArea = new TextArea();
        lArea.setWrapText(true);
        lArea.setFont(Font.font((String)"Helvetica", (FontWeight)FontWeight.MEDIUM, (double)16.0));
        lArea.layoutYProperty().bind((ObservableValue)left.labelHeightProperty().add(10));
        left.layoutBoundsProperty().addListener((v, o, n) -> {
            lArea.setLayoutX(10.0);
            lArea.setPrefWidth(n.getWidth() - 20.0);
            lArea.setPrefHeight(n.getHeight() - left.labelHeightProperty().get() - 20.0);
        });
        Label queueLabel = new Label("Processing Queue Size:");
        queueLabel.layoutXProperty().bind((ObservableValue)lArea.widthProperty().subtract(queueLabel.getLayoutBounds().getWidth() + 330.0));
        queueLabel.setLayoutY(lArea.getLayoutY() - queueLabel.getLayoutBounds().getHeight() - 35.0);
        queueLabel.setFont(Font.font((String)"Helvetica", (FontWeight)FontWeight.BOLD, (double)12.0));
        queueLabel.setTextFill((Paint)Color.rgb((int)0, (int)70, (int)107));
        this.queueDisplayProperty.set((Object)queueLabel);
        Label curLabel = new Label("Current Tweet:");
        curLabel.layoutXProperty().bind((ObservableValue)lArea.widthProperty().subtract(curLabel.getLayoutBounds().getWidth() + 110.0));
        curLabel.setLayoutY(lArea.getLayoutY() - curLabel.getLayoutBounds().getHeight() - 35.0);
        curLabel.setFont(Font.font((String)"Helvetica", (FontWeight)FontWeight.BOLD, (double)12.0));
        curLabel.setTextFill((Paint)Color.rgb((int)0, (int)70, (int)107));
        this.currentLabelProperty.set((Object)curLabel.textProperty());
        left.getChildren().addAll((Object[])new Node[]{lArea, queueLabel, curLabel});
        LabelledRadiusPane right = new LabelledRadiusPane("Scrubbed Tweet");
        TextArea rArea = new TextArea();
        rArea.setWrapText(true);
        rArea.setFont(Font.font((String)"Helvetica", (FontWeight)FontWeight.MEDIUM, (double)16.0));
        rArea.layoutYProperty().bind((ObservableValue)right.labelHeightProperty().add(10));
        right.layoutBoundsProperty().addListener((v, o, n) -> {
            rArea.setLayoutX(10.0);
            rArea.setPrefWidth(n.getWidth() - 20.0);
            rArea.setPrefHeight(n.getHeight() - right.labelHeightProperty().get() - 20.0);
        });
        right.getChildren().add((Object)rArea);
        retVal.setLeftPane(left);
        retVal.setRightPane(right);
        this.inputPaneProperty.set((Object)new Pair((Object)lArea, (Object)rArea));
        return retVal;
    }

    public HBox createSegmentedButtonBar() {
        ToggleButton button1 = new ToggleButton("Start");
        button1.getStyleClass().addAll((Object[])new String[]{"first"});
        button1.setOnAction(e -> Platform.runLater(() -> {
            if (this.mode == Mode.MANUAL) {
                this.runOneBtn.setDisable(false);
            }
            this.startActionProperty.set(true);
        }));
        ToggleButton button2 = new ToggleButton("Stop");
        button2.getStyleClass().addAll((Object[])new String[]{"last"});
        button2.setOnAction(e -> Platform.runLater(() -> this.startActionProperty.set(false)));
        ToggleButton button3 = new ToggleButton("Auto");
        button3.getStyleClass().addAll((Object[])new String[]{"first"});
        button3.setOnAction(e -> Platform.runLater(() -> {
            this.mode = Mode.AUTO;
            this.autoModeProperty.set((Object)this.mode);
        }));
        ToggleButton button4 = new ToggleButton("Manual");
        button4.getStyleClass().addAll((Object[])new String[]{"last"});
        button4.setOnAction(e -> Platform.runLater(() -> {
            this.mode = Mode.MANUAL;
            this.autoModeProperty.set((Object)this.mode);
        }));
        Button button5 = this.runOneBtn = new Button("Run One");
        button5.getStyleClass().addAll((Object[])new String[]{"only"});
        button5.setDisable(true);
        button5.setOnAction(e -> Platform.runLater(() -> this.runOneProperty.set(this.runOneProperty.get() + 1)));
        this.runDisableProperty.addListener((v, o, n) -> button5.setDisable(n.booleanValue()));
        ToggleGroup group = new ToggleGroup();
        group.getToggles().addAll((Object[])new Toggle[]{button1, button2});
        group.selectToggle((Toggle)button2);
        ToggleGroup group2 = new ToggleGroup();
        group2.getToggles().addAll((Object[])new Toggle[]{button3, button4});
        group2.selectToggle((Toggle)button3);
        group2.selectedToggleProperty().addListener((v, o, n) -> {
            if (n == null) {
                return;
            }
            if (n.equals(button4)) {
                Platform.runLater(() -> {
                    this.mode = Mode.MANUAL;
                    group.selectToggle((Toggle)button2);
                    this.startActionProperty.set(false);
                });
            } else {
                Platform.runLater(() -> {
                    this.mode = Mode.AUTO;
                    this.startActionProperty.set(false);
                    group.selectToggle((Toggle)button2);
                    button5.setDisable(true);
                });
            }
        });
        HBox displayBox = new HBox();
        displayBox.setSpacing(20.0);
        displayBox.setAlignment(Pos.CENTER);
        SegmentedButtonBar buttonBar = new SegmentedButtonBar();
        buttonBar.getChildren().addAll((Object[])new Node[]{button1, button2});
        SegmentedButtonBar buttonBar2 = new SegmentedButtonBar();
        buttonBar2.getChildren().addAll((Object[])new Node[]{button3, button4});
        SegmentedButtonBar buttonBar3 = new SegmentedButtonBar();
        buttonBar3.getChildren().addAll((Object[])new Node[]{button5});
        displayBox.getChildren().addAll((Object[])new Node[]{buttonBar, buttonBar2, buttonBar3});
        return displayBox;
    }

    public LineChart<String, Number> createChart(LabelledRadiusPane pane) {
        CategoryAxis xAxis = new CategoryAxis();
        NumberAxis yAxis = new NumberAxis();
        this.chart = new LineChart((Axis)xAxis, (Axis)yAxis);
        this.chart.setTitle("Tweet Trend Analysis");
        this.chart.setCreateSymbols(false);
        this.chart.setLegendVisible(false);
        xAxis.setLabel("Time of Tweet");
        yAxis.setUpperBound(1.0);
        yAxis.setLowerBound(0.0);
        yAxis.setLabel("Anomaly\n  Score");
        yAxis.setForceZeroInRange(true);
        this.series = new XYChart.Series();
        this.series.setName("Tweet Data");
        this.chart.getData().add(this.series);
        this.chartSeriesProperty.set(this.series);
        Node line = this.series.getNode().lookup(".chart-series-line");
        line.setStyle("-fx-stroke: rgb(20, 164, 220)");
        this.chart.setPrefWidth(1200.0);
        this.chart.setPrefHeight(275.0);
        this.chart.setLayoutY(pane.labelHeightProperty().get() + 10.0);
        return this.chart;
    }

    public LabelledRadiusPane createActivityPane() {
        LabelledRadiusPane retVal = new LabelledRadiusPane("Activity Monitor");
        HBox h = new HBox();
        h.setFillHeight(true);
        h.setSpacing(15.0);
        h.setPadding(new Insets(0.0, 10.0, 10.0, 15.0));
        h.prefWidthProperty().bind((ObservableValue)retVal.widthProperty());
        h.layoutYProperty().bind((ObservableValue)retVal.labelHeightProperty().add(20));
        TextArea area = new TextArea();
        area.prefWidthProperty().bind((ObservableValue)h.widthProperty().subtract(30).divide(2));
        area.prefHeightProperty().bind((ObservableValue)retVal.heightProperty().subtract(60));
        area.setLayoutY(retVal.labelHeightProperty().add(0).get());
        this.leftActivityPanelProperty.set((Object)area);
        TextArea area2 = new TextArea();
        area2.prefWidthProperty().bind((ObservableValue)h.widthProperty().subtract(60).divide(2));
        area2.prefHeightProperty().bind((ObservableValue)retVal.heightProperty().subtract(60));
        area2.setLayoutY(retVal.labelHeightProperty().add(0).get());
        area2.textProperty().addListener((v, o, n) -> {
            area2.setScrollTop(Double.MAX_VALUE);
            area2.setScrollLeft(Double.MAX_VALUE);
        });
        this.rightActivityPanelProperty.set((Object)area2);
        h.getChildren().addAll((Object[])new Node[]{area, area2});
        Label l = new Label("Output");
        l.setFont(Font.font((String)"Helvetica", (FontWeight)FontWeight.BOLD, (double)14.0));
        l.setTextFill((Paint)Color.rgb((int)0, (int)70, (int)107));
        l.layoutXProperty().bind((ObservableValue)area.widthProperty().divide(2).add(area.getLayoutX()).subtract(l.getWidth()));
        l.setLayoutY(area.getLayoutY() - l.getHeight());
        Label l2 = new Label("Similar Tweets");
        l2.setFont(Font.font((String)"Helvetica", (FontWeight)FontWeight.BOLD, (double)14.0));
        l2.setTextFill((Paint)Color.rgb((int)0, (int)70, (int)107));
        area2.layoutBoundsProperty().addListener((v, o, n) -> l2.setLayoutX(area.getWidth() + 60.0 + area2.getWidth() / 2.0 - l2.getWidth()));
        l2.setLayoutY(area2.getLayoutY() - l.getHeight());
        retVal.getChildren().addAll((Object[])new Node[]{h, l, l2});
        return retVal;
    }

    public FingerprintPane createFingerprintPane(String text) {
        FingerprintPane pane = new FingerprintPane();
        pane.setLabelText(text);
        return pane;
    }

    public ObjectProperty<XYChart.Series<String, Number>> chartSeriesProperty() {
        return this.chartSeriesProperty;
    }

    public BooleanProperty startActionProperty() {
        return this.startActionProperty;
    }

    public ObjectProperty<Mode> autoModeProperty() {
        return this.autoModeProperty;
    }

    public IntegerProperty runOneProperty() {
        return this.runOneProperty;
    }

    public BooleanProperty runDisableProperty() {
        return this.runDisableProperty;
    }

    public ObjectProperty<Pair<TextArea, TextArea>> inputPaneProperty() {
        return this.inputPaneProperty;
    }

    public ObjectProperty<RadiusFlipPane> flipPaneProperty() {
        return this.flipPaneProperty;
    }

    public ObjectProperty<FlipState> flipStateProperty() {
        return this.flipStateProperty;
    }

    public ObjectProperty<TriplePanel> fingerprintPanelProperty() {
        return this.fingerprintPanelProperty;
    }

    public ObjectProperty<TextArea> leftActivityPanelProperty() {
        return this.leftActivityPanelProperty;
    }

    public ObjectProperty<TextArea> rightActivityPanelProperty() {
        return this.rightActivityPanelProperty;
    }

    public ObjectProperty<StringProperty> currentLabelProperty() {
        return this.currentLabelProperty;
    }

    public ObjectProperty<Label> queueDisplayProperty() {
        return this.queueDisplayProperty;
    }

    static enum FlipState {
        ON_FRONT,
        ON_BACK;

    }

    static enum Mode {
        AUTO,
        MANUAL;

    }
}

