/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.examples.cortical_io.breakingnews;

import com.fasterxml.jackson.core.JsonProcessingException;
import gnu.trove.list.array.TIntArrayList;
import io.cortical.rest.model.Fingerprint;
import io.cortical.rest.model.Metric;
import io.cortical.services.RetinaApis;
import io.cortical.services.api.client.ApiException;
import io.cortical.twitter.Algorithm;
import io.cortical.twitter.Tweet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Semaphore;
import org.numenta.nupic.network.Inference;
import org.numenta.nupic.network.Network;
import org.numenta.nupic.util.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Subscriber;

public class StrictHackathonAlgorithm
implements Algorithm {
    private static final Logger LOGGER = LoggerFactory.getLogger(StrictHackathonAlgorithm.class);
    private static final int SDR_WIDTH = 16384;
    private static final double SPARSITY = 0.02;
    private RetinaApis retinaApis;
    private Network htmNetwork;
    private Metric similarities;
    private int[] currentPrediction;
    private int[] prevPrediction;
    private double anomaly;
    private double prevAnomaly;
    private List<Tweet> processedTweets;
    private List<Tweet> anomalousTweets;
    private List<Tweet> highSimilarityTweets;
    private Tweet currentTweet;
    private Semaphore semaphore;
    private Random rng;

    public StrictHackathonAlgorithm(RetinaApis retinaApis, Network htmNetwork) {
        this.retinaApis = retinaApis;
        this.htmNetwork = htmNetwork;
        this.processedTweets = new ArrayList<Tweet>();
        this.anomalousTweets = new ArrayList<Tweet>();
        this.highSimilarityTweets = new ArrayList<Tweet>();
        this.semaphore = new Semaphore(1, false);
        this.rng = new Random();
        if (htmNetwork != null) {
            this.listenToNetwork(htmNetwork);
        }
    }

    public void listenToNetwork(Network network) {
        if (network == null) {
            throw new IllegalArgumentException("Cannot listen to null Network.");
        }
        this.htmNetwork = network;
        network.observe().subscribe((Subscriber)new Subscriber<Inference>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(Inference t) {
                StrictHackathonAlgorithm.access$002(StrictHackathonAlgorithm.this, StrictHackathonAlgorithm.this.subsample(t.getSDR()));
                StrictHackathonAlgorithm.this.semaphore.release();
            }
        });
    }

    public Tweet getCurrentTweet() {
        return this.currentTweet;
    }

    public void compute(Tweet tweet) {
        this.currentTweet = tweet;
        List tweetFp = Collections.emptyList();
        try {
            tweetFp = this.retinaApis.textApi().getFingerprints(tweet.getText());
            tweet.setFingerprints(tweetFp);
            this.processedTweets.add(tweet);
        }
        catch (ApiException e) {
            System.out.println("failed tweet: " + tweet.getText() + "\nfailed json: " + tweet.getJson());
            e.printStackTrace();
            return;
        }
        if (this.currentPrediction != null && this.currentPrediction.length > 0 && !tweetFp.isEmpty() && this.currentPrediction.length > this.prevPrediction.length / 2) {
            this.similarities = this.compare(((Fingerprint)tweetFp.get(0)).getPositions(), this.currentPrediction);
            this.anomaly = 1.0 - Math.max(this.similarities.getOverlappingLeftRight(), this.similarities.getOverlappingRightLeft());
        } else {
            this.anomaly = 1.0;
            this.similarities = null;
        }
        this.prevPrediction = this.currentPrediction;
        if (this.anomaly > this.prevAnomaly + 0.2) {
            this.anomalousTweets.add(tweet);
        } else if (this.anomaly < this.prevAnomaly - 0.2) {
            this.inspectTweetHistory(tweet, this.processedTweets.subList(Math.max(0, this.processedTweets.size() - 20), this.processedTweets.size()));
        }
        this.prevAnomaly = this.anomaly;
        tweet.setAnomaly(this.anomaly);
        if (((Fingerprint)tweetFp.get(0)).getPositions().length > 300) {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                LOGGER.error("Could not acquire lock to proceed with processing next tweet", (Throwable)e);
            }
            this.htmNetwork.compute(((Fingerprint)tweetFp.get(0)).getPositions());
        }
    }

    double getSparsity(int[] sdr) {
        double sparsity = (double)sdr.length / 16384.0;
        return sparsity;
    }

    int[] subsample(int[] input) {
        double sparsity = this.getSparsity(input);
        if (sparsity > 0.02) {
            input = ArrayUtils.sample(328, new TIntArrayList(input), this.rng);
        }
        return input;
    }

    void inspectTweetHistory(Tweet tweet, List<Tweet> pastTweets) {
        this.highSimilarityTweets.clear();
        for (Tweet pastTweet : pastTweets) {
            Metric sims = this.compare(((Fingerprint)tweet.getFingerprints().get(0)).getPositions(), ((Fingerprint)pastTweet.getFingerprints().get(0)).getPositions());
            double anomaly = 1.0 - Math.max(sims.getOverlappingLeftRight(), sims.getOverlappingRightLeft());
            if (!(anomaly < 0.5)) continue;
            pastTweet.setAnomaly(anomaly);
            this.highSimilarityTweets.add(pastTweet);
        }
    }

    Metric compare(int[] tweetPositions, int[] htmPrediction) {
        String jsonTP = "{ \"positions\" : " + Arrays.toString(tweetPositions) + " }";
        String jsonHTM = "{ \"positions\" : " + Arrays.toString(htmPrediction) + " }";
        try {
            return this.retinaApis.compareApi().compare(jsonTP, jsonHTM);
        }
        catch (ApiException e) {
            LOGGER.error("Could not retreive comparison for last tweet and prediction.");
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Problem with json from last comparison:\n1. " + jsonTP + "\n2. " + jsonHTM);
        }
        return null;
    }

    public double getAnomaly() {
        return this.anomaly;
    }

    public double getPrevAnomaly() {
        return this.prevAnomaly;
    }

    public int[] getPrediction() {
        return this.currentPrediction;
    }

    public int[] getPrevPrediction() {
        return this.prevPrediction;
    }

    public Metric getSimilarities() {
        return this.similarities;
    }

    public List<Tweet> getSimilarityHistory() {
        return this.highSimilarityTweets;
    }

    public List<Tweet> getProcessedTweets() {
        return this.processedTweets;
    }

    static /* synthetic */ int[] access$002(StrictHackathonAlgorithm x0, int[] x1) {
        x0.currentPrediction = x1;
        return x1;
    }
}

