/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.examples.cortical_io.foxeats;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import gnu.trove.list.array.TIntArrayList;
import io.cortical.rest.model.Fingerprint;
import io.cortical.rest.model.Model;
import io.cortical.rest.model.Term;
import io.cortical.services.Expressions;
import io.cortical.services.RetinaApis;
import io.cortical.services.Terms;
import io.cortical.services.api.client.ApiException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.numenta.nupic.Parameters;
import org.numenta.nupic.datagen.ResourceLocator;
import org.numenta.nupic.examples.cortical_io.foxeats.FoxEatsDemoView;
import org.numenta.nupic.network.Network;
import org.numenta.nupic.network.sensor.FileSensor;
import org.numenta.nupic.research.TemporalMemory;
import org.numenta.nupic.util.ArrayUtils;
import org.numenta.nupic.util.MersenneTwister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FoxEatsDemo
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(FoxEatsDemo.class);
    private static final String RETINA_NAME = "en_associative";
    private static final String RETINA_IP = "api.cortical.io";
    private static final double SDR_WIDTH = 16384.0;
    private static final double SPARSITY = 0.02;
    static String cachePath = System.getProperty("user.home").concat(File.separator).concat(".cortical").concat(File.separator).concat("cache");
    private static final Random RANDOM = new MersenneTwister(42L);
    private ObjectProperty<String[]> phraseEntryProperty = new SimpleObjectProperty();
    private ObjectProperty<String[]> phraseEndedProperty = new SimpleObjectProperty();
    private String[] finalResult;
    private Callback<String[], Void> callback;
    private String apiKey = "";
    private String filePath;
    private List<String[]> input;
    private Map<String, Term> cache;
    private Terms termsApi;
    private Expressions exprApi;
    private Network network;

    public FoxEatsDemo() {
    }

    public FoxEatsDemo(String path) {
        this.filePath = "foxeat.csv";
        this.input = this.readInputData(this.filePath);
    }

    void setDataFilePath(String path) {
        this.filePath = path;
    }

    void setInputData(List<String[]> inputData) {
        this.input = inputData;
    }

    void setCachePath(String path) {
        cachePath = path;
    }

    File getCacheFile() {
        File f = new File(cachePath);
        if (!f.exists()) {
            try {
                new File(cachePath.substring(0, cachePath.lastIndexOf(File.separator))).mkdir();
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalStateException("Unable to write cache file.");
            }
            LOGGER.debug("Created cache file: " + cachePath);
        }
        return f;
    }

    Map<String, Term> getCache() {
        return this.cache;
    }

    Stream<String> getCacheStream() throws IOException {
        File f = this.getCacheFile();
        Stream<String> stream = Files.lines(f.toPath());
        return stream;
    }

    void loadCache() {
        if (this.cache == null) {
            this.cache = new HashMap<String, Term>();
        }
        String json = null;
        try {
            StringBuilder sb = new StringBuilder();
            this.getCacheStream().forEach(l -> sb.append((String)l));
            json = sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (json.isEmpty()) {
            LOGGER.debug("Term cache is empty.");
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        List<Object> terms = null;
        try {
            terms = Arrays.asList((Object[])mapper.readValue(json, Term[].class));
            if (terms == null) {
                LOGGER.debug("Term cache is empty or malformed.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (Term term : terms) {
            this.cache.put(term.getTerm(), term);
        }
        this.checkCache(true, true);
    }

    void writeCache() {
        File f = this.getCacheFile();
        try (PrintWriter pw = new PrintWriter(new FileWriter(f));){
            StringBuilder builderStr = new StringBuilder();
            int i = 0;
            for (Term t : this.cache.values()) {
                String termStr = Term.toJson((Model[])new Model[]{t});
                if (i > 0) {
                    termStr = termStr.substring(1).trim();
                }
                termStr = termStr.substring(0, termStr.length() - 1).trim();
                builderStr.append(termStr).append(",");
                ++i;
            }
            builderStr.setLength(builderStr.length() - 1);
            builderStr.append(" ]");
            pw.println(builderStr.toString());
            pw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void checkCache(boolean print, boolean failOnCheck) {
        int count = 0;
        for (String key : this.cache.keySet()) {
            if (print) {
                LOGGER.debug(count++ + ". key: " + key);
            }
            if (this.checkTerm(key, this.cache.get(key), print) || !failOnCheck) continue;
            throw new IllegalStateException("Term cache for key: " + key + " was invalid or missing data.");
        }
    }

    boolean checkTerm(String key, Term t, boolean print) {
        Fingerprint fp = t.getFingerprint();
        if (fp == null) {
            if (print) {
                LOGGER.debug("\tkey: " + key + ", missing fingerprint");
            }
            return false;
        }
        int[] pos = fp.getPositions();
        if (pos == null) {
            if (print) {
                LOGGER.debug("\tkey: " + key + ", has null positions");
            }
            return false;
        }
        if (pos.length < 1) {
            if (print) {
                LOGGER.debug("\tkey: " + key + ", had empty positions");
            }
            return false;
        }
        int sdrLen = pos.length;
        if (print) {
            LOGGER.debug("\tkey: " + key + ", term len: " + sdrLen);
        }
        return true;
    }

    boolean connectionValid(String apiKey) {
        try {
            this.apiKey = apiKey;
            RetinaApis ra = new RetinaApis(RETINA_NAME, RETINA_IP, this.apiKey);
            this.termsApi = ra.termsApi();
            this.exprApi = ra.expressionsApi();
            LOGGER.debug("Successfully initialized retinal api");
            return true;
        }
        catch (Exception e) {
            LOGGER.debug("Problem initializing retinal api");
            return false;
        }
    }

    List<Term> getTerms(String term, boolean includeFingerprint) throws ApiException, JsonProcessingException {
        return this.termsApi.getTerm(term, Boolean.valueOf(includeFingerprint));
    }

    List<Term> getSimilarTerms(Fingerprint fp) throws ApiException, JsonProcessingException {
        return this.exprApi.getSimilarTerms((Model)fp);
    }

    Term getClosestTerm(int[] sdr) {
        Fingerprint fp = new Fingerprint(sdr);
        try {
            List<Term> terms = this.getSimilarTerms(fp);
            for (int i = 0; i < terms.size(); ++i) {
                if (!this.cache.containsKey(terms.get(i).getTerm())) continue;
                terms.set(i, this.cache.get(terms.get(i).getTerm()));
            }
            Term retVal = null;
            if (terms != null && terms.size() > 0) {
                retVal = terms.get(0);
                if (this.checkTerm(retVal.getTerm(), retVal, true)) {
                    return retVal;
                }
                String string = retVal.getTerm();
                retVal = this.getTerms(retVal.getTerm(), true).get(0);
                this.cache.put(string, retVal);
                return retVal;
            }
        }
        catch (Exception e) {
            LOGGER.debug("Problem using Expressions API");
            e.printStackTrace();
        }
        return null;
    }

    int getSparsity(int[] sdr) {
        double sparsity = (double)sdr.length / 16384.0 * 100.0;
        return (int)sparsity;
    }

    int[] subsample(int[] input) {
        int sparsity = this.getSparsity(input);
        if (sparsity > 2) {
            input = ArrayUtils.sample(328, new TIntArrayList(input), RANDOM);
        }
        return input;
    }

    int[] getFingerprintSDR(String term) {
        return this.getFingerprintSDR(this.getFingerprint(term));
    }

    int[] getFingerprintSDR(Fingerprint fp) {
        return fp.getPositions();
    }

    Fingerprint getFingerprint(String term) {
        try {
            Term t;
            Term term2 = t = this.cache.get(term) == null ? this.getTerms(term, true).get(0) : this.cache.get(term);
            if (!this.checkTerm(t.getTerm(), t, true)) {
                throw new IllegalStateException("Checkterm failed: " + t.getTerm());
            }
            this.cache.put(t.getTerm(), t);
            return t.getFingerprint();
        }
        catch (Exception e) {
            LOGGER.debug("Problem retrieving fingerprint for term: " + term);
            return null;
        }
    }

    Iterator<String[]> inputIterator() {
        return this.input.iterator();
    }

    List<String[]> readInputData(String pathToFile) {
        Stream<String> stream = this.getInputDataStream(pathToFile);
        List<String[]> list = stream.map(l -> l.split("[\\s]*\\,[\\s]*")).collect(Collectors.toList());
        return list;
    }

    Stream<String> getInputDataStream(String pathToFile) {
        File inputFile = null;
        Stream<String> retVal = null;
        if (pathToFile.indexOf(File.separator) != -1) {
            inputFile = new File(pathToFile);
        } else {
            String path = ResourceLocator.path(pathToFile);
            if (path.indexOf("!") != -1) {
                path = path.substring("file:".length());
                return FileSensor.getJarEntryStream(path);
            }
            inputFile = new File(path);
        }
        try {
            if (!inputFile.exists()) {
                throw new FileNotFoundException(pathToFile);
            }
            retVal = Files.lines(inputFile.toPath(), Charset.forName("UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    Parameters createParameters() {
        Parameters tmParams = Parameters.getTemporalDefaultParameters();
        tmParams.setParameterByKey(Parameters.KEY.COLUMN_DIMENSIONS, new int[]{16384});
        tmParams.setParameterByKey(Parameters.KEY.CELLS_PER_COLUMN, 8);
        tmParams.setParameterByKey(Parameters.KEY.CONNECTED_PERMANENCE, 0.5);
        tmParams.setParameterByKey(Parameters.KEY.INITIAL_PERMANENCE, 0.4);
        tmParams.setParameterByKey(Parameters.KEY.MIN_THRESHOLD, 164);
        tmParams.setParameterByKey(Parameters.KEY.MAX_NEW_SYNAPSE_COUNT, 164);
        tmParams.setParameterByKey(Parameters.KEY.PERMANENCE_INCREMENT, 0.1);
        tmParams.setParameterByKey(Parameters.KEY.PERMANENCE_DECREMENT, 0.0);
        tmParams.setParameterByKey(Parameters.KEY.ACTIVATION_THRESHOLD, 164);
        return tmParams;
    }

    Network createNetwork() {
        Parameters temporalParams = this.createParameters();
        this.network = Network.create("Cortical.io API Demo", temporalParams).add(Network.createRegion("Region 1").add(Network.createLayer("Layer 2/3", temporalParams).add(new TemporalMemory())));
        return this.network;
    }

    String[] feedNetwork(final Network network, final Iterator<String[]> it) {
        new Thread(){

            @Override
            public void run() {
                while (it.hasNext()) {
                    String[] next = (String[])it.next();
                    if (!it.hasNext()) {
                        FoxEatsDemo.this.phraseEndedProperty.set((Object)next);
                        FoxEatsDemo.access$102(FoxEatsDemo.this, next);
                        break;
                    }
                    FoxEatsDemo.this.phraseEntryProperty.set((Object)next);
                    FoxEatsDemo.this.feedLine(network, next);
                }
                Platform.runLater(() -> FoxEatsDemo.this.callback.call((Object)FoxEatsDemo.this.finalResult));
            }
        }.start();
        return null;
    }

    String[] feedNetworkForTest(Network network, Iterator<String[]> it) {
        while (it.hasNext()) {
            String[] next = it.next();
            this.phraseEntryProperty.set((Object)next);
            if (!it.hasNext()) {
                this.phraseEndedProperty.set((Object)next);
                this.finalResult = next;
                break;
            }
            this.feedLine(network, next);
        }
        return this.finalResult;
    }

    void setCallBack(Callback<String[], Void> c) {
        this.callback = c;
    }

    void feedLine(Network network, String[] phrase) {
        for (String term : phrase) {
            int[] sdr = this.getFingerprintSDR(term);
            network.compute(sdr);
        }
        network.reset();
    }

    ObjectProperty<String[]> getPhraseEntryProperty() {
        return this.phraseEntryProperty;
    }

    ObjectProperty<String[]> getPhraseEndedProperty() {
        return this.phraseEndedProperty;
    }

    Term feedQuestion(Network network, String[] phrase) {
        for (int i = 0; i < 2; ++i) {
            int[] sdr = this.getFingerprintSDR(phrase[i]);
            network.compute(sdr);
        }
        int[] prediction = network.lookup("Region 1").lookup("Layer 2/3").getPredictedColumns();
        Term term = this.getClosestTerm(prediction);
        this.cache.put(term.getTerm(), term);
        return term;
    }

    public void start(Stage stage) throws Exception {
        Application.Parameters params = this.getParameters();
        List paramList = params.getUnnamed();
        if (paramList.size() < 1 || !((String)paramList.get(0)).startsWith("-K")) {
            throw new IllegalStateException("Demo must be started with arguments [-K]<your-api-key>");
        }
        FoxEatsDemoView view = new FoxEatsDemoView(this, params);
        Scene scene = new Scene((Parent)view, 900.0, 600.0, (Paint)Color.WHITE);
        stage.setScene(scene);
        stage.show();
        Rectangle2D primScreenBounds = Screen.getPrimary().getVisualBounds();
        stage.setX((primScreenBounds.getWidth() - stage.getWidth()) / 2.0);
        stage.setY((primScreenBounds.getHeight() - stage.getHeight()) / 4.0);
    }

    public static void main(String[] args) {
        FoxEatsDemo.launch((String[])args);
    }

    static /* synthetic */ String[] access$102(FoxEatsDemo x0, String[] x1) {
        x0.finalResult = x1;
        return x1;
    }
}

