/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.examples.cortical_io.foxeats;

import io.cortical.fx.webstyle.CorticalLogoBackground;
import io.cortical.fx.webstyle.LabelledRadiusPane;
import io.cortical.fx.webstyle.SegmentedButtonBar;
import io.cortical.fx.webstyle.example.LogoTitlePane;
import io.cortical.rest.model.Term;
import io.cortical.services.api.client.ApiException;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.util.Callback;
import org.numenta.nupic.examples.cortical_io.foxeats.FoxEatsDemo;
import org.numenta.nupic.network.Network;

public class FoxEatsDemoView
extends GridPane {
    private FoxEatsDemo demo;
    private String apiKey;
    private TextArea lArea;

    public FoxEatsDemoView(FoxEatsDemo demo, Application.Parameters params) {
        this.demo = demo;
        this.apiKey = ((String)params.getUnnamed().get(0)).substring(2).trim();
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)}));
        HBox h = new HBox();
        h.prefWidthProperty().bind((ObservableValue)this.widthProperty().divide(20));
        h.setFillHeight(true);
        HBox h2 = new HBox();
        h2.prefWidthProperty().bind((ObservableValue)this.widthProperty().divide(20));
        h2.setFillHeight(true);
        StackPane stack = new StackPane();
        stack.prefWidthProperty().bind((ObservableValue)this.widthProperty().multiply(0.9));
        stack.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        CorticalLogoBackground backGround = new CorticalLogoBackground((Region)stack);
        backGround.setOpacity(0.2);
        final VBox vBox = new VBox();
        vBox.setSpacing(20.0);
        vBox.prefWidthProperty().bind((ObservableValue)stack.widthProperty());
        vBox.prefHeightProperty().bind((ObservableValue)new SimpleDoubleProperty(100.0));
        LogoTitlePane header = new LogoTitlePane();
        header.setTitleText("What Does A Fox Eat?");
        header.setSubTitleText("an example of using Numenta's Hierarchical Temporal Memory with Cortical.io's Semantic Folding...");
        SegmentedButtonBar buttonBar = this.createSegmentedButtonBar();
        final LabelledRadiusPane inputPane = this.getDisplayPane();
        vBox.getChildren().addAll((Object[])new Node[]{header, buttonBar, inputPane});
        stack.getChildren().addAll((Object[])new Node[]{backGround, vBox});
        this.add((Node)h, 0, 0);
        this.add((Node)stack, 1, 0);
        this.add((Node)h2, 2, 0);
        Platform.runLater(() -> {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Platform.runLater(() -> {
                        FoxEatsDemoView.this.getScene().getWindow().setWidth(FoxEatsDemoView.this.getScene().getWindow().getWidth() + 10.0);
                        vBox.layoutBoundsProperty().addListener((v, o, n) -> inputPane.setPrefHeight(vBox.getLayoutBounds().getHeight() - inputPane.getLayoutY() - 50.0));
                    });
                }
            };
            t.start();
        });
    }

    public LabelledRadiusPane getDisplayPane() {
        LabelledRadiusPane left = new LabelledRadiusPane("Input Phrases");
        this.lArea = new TextArea();
        this.lArea.setWrapText(true);
        this.lArea.setFont(Font.font((String)"Helvetica", (FontWeight)FontWeight.MEDIUM, (double)16.0));
        this.lArea.layoutYProperty().bind((ObservableValue)left.labelHeightProperty().add(10));
        left.layoutBoundsProperty().addListener((v, o, n) -> {
            this.lArea.setLayoutX(10.0);
            this.lArea.setPrefWidth(n.getWidth() - 20.0);
            this.lArea.setPrefHeight(n.getHeight() - left.labelHeightProperty().get() - 20.0);
        });
        this.lArea.textProperty().addListener((v, o, n) -> {
            this.lArea.setScrollTop(Double.MAX_VALUE);
            this.lArea.setScrollLeft(Double.MAX_VALUE);
        });
        left.getChildren().add((Object)this.lArea);
        String smallTabs = "\t\t\t\t\t\t\t";
        String bigTabs = "\t\t\t\t\t\t\t\t";
        this.demo.getPhraseEntryProperty().addListener((v, o, n) -> Platform.runLater(() -> this.lArea.appendText("\n" + n[0] + (n[0].length() > 4 ? smallTabs : bigTabs) + n[1] + "\t\t\t\t\t\t\t\t" + n[2])));
        this.demo.getPhraseEndedProperty().addListener((v, o, n) -> Platform.runLater(() -> this.lArea.appendText("\n\nWhat does a fox eat?")));
        return left;
    }

    public SegmentedButtonBar createSegmentedButtonBar() {
        Button button1 = new Button("Start");
        button1.getStyleClass().addAll((Object[])new String[]{"only"});
        button1.setOnAction(e -> Platform.runLater(() -> this.startNetwork()));
        SegmentedButtonBar buttonBar = new SegmentedButtonBar();
        buttonBar.getChildren().addAll((Object[])new Node[]{button1});
        return buttonBar;
    }

    private void startNetwork() {
        this.demo.setDataFilePath("foxeat.csv");
        this.demo.setInputData(this.demo.readInputData("foxeat.csv"));
        this.demo.loadCache();
        boolean success = this.demo.connectionValid(this.apiKey);
        if (!success) {
            throw new RuntimeException(new ApiException());
        }
        Network network = this.demo.createNetwork();
        this.demo.feedNetwork(network, this.demo.inputIterator());
        this.demo.setCallBack((Callback<String[], Void>)((Callback)sa -> {
            Platform.runLater(() -> {
                Term answer = this.demo.feedQuestion(network, (String[])sa);
                this.lArea.appendText("\t\t\t\t\t\tAnswer: \t" + answer.getTerm());
                this.demo.writeCache();
            });
            return null;
        }));
    }
}

