/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.examples.napi;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.numenta.nupic.Parameters;
import org.numenta.nupic.algorithms.Anomaly;
import org.numenta.nupic.datagen.ResourceLocator;
import org.numenta.nupic.examples.napi.NetworkDemoHarness;
import org.numenta.nupic.network.Inference;
import org.numenta.nupic.network.Network;
import org.numenta.nupic.network.sensor.FileSensor;
import org.numenta.nupic.network.sensor.Sensor;
import org.numenta.nupic.network.sensor.SensorParams;
import org.numenta.nupic.research.SpatialPooler;
import org.numenta.nupic.research.TemporalMemory;
import rx.Subscriber;

public class NetworkAPIDemo {
    private Network network;
    private File outputFile;
    private PrintWriter pw;

    public NetworkAPIDemo(Mode mode) {
        switch (mode) {
            case BASIC: {
                this.network = this.createBasicNetwork();
                break;
            }
            case MULTILAYER: {
                this.network = this.createMultiLayerNetwork();
                break;
            }
            case MULTIREGION: {
                this.network = this.createMultiRegionNetwork();
            }
        }
        this.network.observe().subscribe(this.getSubscriber());
        try {
            this.outputFile = new File(System.getProperty("user.home").concat(File.separator).concat("network_demo_output.txt"));
            this.pw = new PrintWriter(new FileWriter(this.outputFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    Network createBasicNetwork() {
        Parameters p = NetworkDemoHarness.getParameters();
        p = p.union(NetworkDemoHarness.getNetworkDemoTestEncoderParams());
        return Network.create("Network API Demo", p).add(Network.createRegion("Region 1").add(Network.createLayer("Layer 2/3", p).alterParameter(Parameters.KEY.AUTO_CLASSIFY, Boolean.TRUE).add(Anomaly.create()).add(new TemporalMemory()).add(new SpatialPooler()).add(Sensor.create(FileSensor::create, SensorParams.create(SensorParams.Keys::path, "", ResourceLocator.path("rec-center-hourly.csv"))))));
    }

    Network createMultiLayerNetwork() {
        Parameters p = NetworkDemoHarness.getParameters();
        p = p.union(NetworkDemoHarness.getNetworkDemoTestEncoderParams());
        return Network.create("Network API Demo", p).add(Network.createRegion("Region 1").add(Network.createLayer("Layer 2/3", p).alterParameter(Parameters.KEY.AUTO_CLASSIFY, Boolean.TRUE).add(Anomaly.create()).add(new TemporalMemory())).add(Network.createLayer("Layer 4", p).add(new SpatialPooler())).add(Network.createLayer("Layer 5", p).add(Sensor.create(FileSensor::create, SensorParams.create(SensorParams.Keys::path, "", ResourceLocator.path("rec-center-hourly.csv"))))).connect("Layer 2/3", "Layer 4").connect("Layer 4", "Layer 5"));
    }

    Network createMultiRegionNetwork() {
        Parameters p = NetworkDemoHarness.getParameters();
        p = p.union(NetworkDemoHarness.getNetworkDemoTestEncoderParams());
        return Network.create("Network API Demo", p).add(Network.createRegion("Region 1").add(Network.createLayer("Layer 2/3", p).alterParameter(Parameters.KEY.AUTO_CLASSIFY, Boolean.TRUE).add(Anomaly.create()).add(new TemporalMemory())).add(Network.createLayer("Layer 4", p).add(new SpatialPooler())).connect("Layer 2/3", "Layer 4")).add(Network.createRegion("Region 2").add(Network.createLayer("Layer 2/3", p).alterParameter(Parameters.KEY.AUTO_CLASSIFY, Boolean.TRUE).add(Anomaly.create()).add(new TemporalMemory()).add(new SpatialPooler())).add(Network.createLayer("Layer 4", p).add(Sensor.create(FileSensor::create, SensorParams.create(SensorParams.Keys::path, "", ResourceLocator.path("rec-center-hourly.csv"))))).connect("Layer 2/3", "Layer 4")).connect("Region 1", "Region 2");
    }

    Subscriber<Inference> getSubscriber() {
        return new Subscriber<Inference>(){

            public void onCompleted() {
                try {
                    NetworkAPIDemo.this.pw.flush();
                    NetworkAPIDemo.this.pw.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                System.out.println("Stream completed, see output: " + NetworkAPIDemo.this.outputFile.getAbsolutePath());
            }

            public void onError(Throwable e) {
                e.printStackTrace();
            }

            public void onNext(Inference i) {
                NetworkAPIDemo.this.writeToFile(i, "consumption");
            }
        };
    }

    private void writeToFile(Inference infer, String classifierField) {
        try {
            StringBuilder sb = new StringBuilder().append(infer.getRecordNum()).append(", ").append(infer.getClassifierInput().get(classifierField).get("inputValue")).append(", ").append(infer.getAnomalyScore());
            this.pw.println(sb.toString());
            this.pw.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.pw.flush();
            this.pw.close();
        }
    }

    private void runNetwork() {
        this.network.start();
    }

    public static void main(String[] args) {
        NetworkAPIDemo demo = new NetworkAPIDemo(Mode.BASIC);
        demo.runNetwork();
    }

    static enum Mode {
        BASIC,
        MULTILAYER,
        MULTIREGION;

    }
}

