/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.examples.napi;

import java.util.HashMap;
import java.util.Map;
import org.numenta.nupic.Parameters;
import org.numenta.nupic.util.Tuple;

public class NetworkDemoHarness {
    public static Map<String, Map<String, Object>> setupMap(Map<String, Map<String, Object>> map, int n, int w, double min, double max, double radius, double resolution, Boolean periodic, Boolean clip, Boolean forced, String fieldName, String fieldType, String encoderType) {
        if (map == null) {
            map = new HashMap<String, Map<String, Object>>();
        }
        Map<String, Object> inner = null;
        inner = map.get(fieldName);
        if (inner == null) {
            inner = new HashMap<String, Object>();
            map.put(fieldName, inner);
        }
        inner.put("n", n);
        inner.put("w", w);
        inner.put("minVal", min);
        inner.put("maxVal", max);
        inner.put("radius", radius);
        inner.put("resolution", resolution);
        if (periodic != null) {
            inner.put("periodic", periodic);
        }
        if (clip != null) {
            inner.put("clipInput", clip);
        }
        if (forced != null) {
            inner.put("forced", forced);
        }
        if (fieldName != null) {
            inner.put("fieldName", fieldName);
        }
        if (fieldType != null) {
            inner.put("fieldType", fieldType);
        }
        if (encoderType != null) {
            inner.put("encoderType", encoderType);
        }
        return map;
    }

    public static Map<String, Map<String, Object>> getHotGymFieldEncodingMap() {
        Map<String, Map<String, Object>> fieldEncodings = NetworkDemoHarness.setupMap(null, 0, 0, 0.0, 0.0, 0.0, 0.0, null, null, null, "timestamp", "datetime", "DateEncoder");
        fieldEncodings = NetworkDemoHarness.setupMap(fieldEncodings, 25, 3, 0.0, 0.0, 0.0, 0.1, null, null, null, "consumption", "float", "RandomDistributedScalarEncoder");
        fieldEncodings.get("timestamp").put(Parameters.KEY.DATEFIELD_DOFW.getFieldName(), new Tuple(1, 1.0));
        fieldEncodings.get("timestamp").put(Parameters.KEY.DATEFIELD_TOFD.getFieldName(), new Tuple(5, 4.0));
        fieldEncodings.get("timestamp").put(Parameters.KEY.DATEFIELD_PATTERN.getFieldName(), "MM/dd/YY HH:mm");
        return fieldEncodings;
    }

    public static Map<String, Map<String, Object>> getNetworkDemoFieldEncodingMap() {
        Map<String, Map<String, Object>> fieldEncodings = NetworkDemoHarness.setupMap(null, 0, 0, 0.0, 0.0, 0.0, 0.0, null, null, null, "timestamp", "datetime", "DateEncoder");
        fieldEncodings = NetworkDemoHarness.setupMap(fieldEncodings, 50, 21, 0.0, 100.0, 0.0, 0.1, null, Boolean.TRUE, null, "consumption", "float", "ScalarEncoder");
        fieldEncodings.get("timestamp").put(Parameters.KEY.DATEFIELD_TOFD.getFieldName(), new Tuple(21, 9.5));
        fieldEncodings.get("timestamp").put(Parameters.KEY.DATEFIELD_PATTERN.getFieldName(), "MM/dd/YY HH:mm");
        return fieldEncodings;
    }

    public static Parameters getNetworkDemoTestEncoderParams() {
        Map<String, Map<String, Object>> fieldEncodings = NetworkDemoHarness.getNetworkDemoFieldEncodingMap();
        Parameters p = Parameters.getEncoderDefaultParameters();
        p.setParameterByKey(Parameters.KEY.GLOBAL_INHIBITIONS, true);
        p.setParameterByKey(Parameters.KEY.COLUMN_DIMENSIONS, new int[]{2048});
        p.setParameterByKey(Parameters.KEY.CELLS_PER_COLUMN, 32);
        p.setParameterByKey(Parameters.KEY.NUM_ACTIVE_COLUMNS_PER_INH_AREA, 40.0);
        p.setParameterByKey(Parameters.KEY.POTENTIAL_PCT, 0.8);
        p.setParameterByKey(Parameters.KEY.SYN_PERM_CONNECTED, 0.1);
        p.setParameterByKey(Parameters.KEY.SYN_PERM_ACTIVE_INC, 1.0E-4);
        p.setParameterByKey(Parameters.KEY.SYN_PERM_INACTIVE_DEC, 5.0E-4);
        p.setParameterByKey(Parameters.KEY.MAX_BOOST, 1.0);
        p.setParameterByKey(Parameters.KEY.MAX_NEW_SYNAPSE_COUNT, 20);
        p.setParameterByKey(Parameters.KEY.INITIAL_PERMANENCE, 0.21);
        p.setParameterByKey(Parameters.KEY.PERMANENCE_INCREMENT, 0.1);
        p.setParameterByKey(Parameters.KEY.PERMANENCE_DECREMENT, 0.1);
        p.setParameterByKey(Parameters.KEY.MIN_THRESHOLD, 9);
        p.setParameterByKey(Parameters.KEY.ACTIVATION_THRESHOLD, 12);
        p.setParameterByKey(Parameters.KEY.CLIP_INPUT, true);
        p.setParameterByKey(Parameters.KEY.FIELD_ENCODING_MAP, fieldEncodings);
        return p;
    }

    public static Parameters getHotGymTestEncoderParams() {
        Map<String, Map<String, Object>> fieldEncodings = NetworkDemoHarness.getHotGymFieldEncodingMap();
        Parameters p = Parameters.getEncoderDefaultParameters();
        p.setParameterByKey(Parameters.KEY.FIELD_ENCODING_MAP, fieldEncodings);
        return p;
    }

    public static Map<String, Map<String, Object>> getDayDemoFieldEncodingMap() {
        Map<String, Map<String, Object>> fieldEncodings = NetworkDemoHarness.setupMap(null, 8, 3, 0.0, 8.0, 0.0, 1.0, Boolean.TRUE, null, Boolean.TRUE, "dayOfWeek", "number", "ScalarEncoder");
        return fieldEncodings;
    }

    public static Parameters getDayDemoTestEncoderParams() {
        Map<String, Map<String, Object>> fieldEncodings = NetworkDemoHarness.getDayDemoFieldEncodingMap();
        Parameters p = Parameters.getEncoderDefaultParameters();
        p.setParameterByKey(Parameters.KEY.FIELD_ENCODING_MAP, fieldEncodings);
        return p;
    }

    public static Parameters getParameters() {
        Parameters parameters = Parameters.getAllDefaultParameters();
        parameters.setParameterByKey(Parameters.KEY.INPUT_DIMENSIONS, new int[]{8});
        parameters.setParameterByKey(Parameters.KEY.COLUMN_DIMENSIONS, new int[]{20});
        parameters.setParameterByKey(Parameters.KEY.CELLS_PER_COLUMN, 6);
        parameters.setParameterByKey(Parameters.KEY.POTENTIAL_RADIUS, 12);
        parameters.setParameterByKey(Parameters.KEY.POTENTIAL_PCT, 0.5);
        parameters.setParameterByKey(Parameters.KEY.GLOBAL_INHIBITIONS, false);
        parameters.setParameterByKey(Parameters.KEY.LOCAL_AREA_DENSITY, -1.0);
        parameters.setParameterByKey(Parameters.KEY.NUM_ACTIVE_COLUMNS_PER_INH_AREA, 5.0);
        parameters.setParameterByKey(Parameters.KEY.STIMULUS_THRESHOLD, 1.0);
        parameters.setParameterByKey(Parameters.KEY.SYN_PERM_INACTIVE_DEC, 0.01);
        parameters.setParameterByKey(Parameters.KEY.SYN_PERM_ACTIVE_INC, 0.1);
        parameters.setParameterByKey(Parameters.KEY.SYN_PERM_TRIM_THRESHOLD, 0.05);
        parameters.setParameterByKey(Parameters.KEY.SYN_PERM_CONNECTED, 0.1);
        parameters.setParameterByKey(Parameters.KEY.MIN_PCT_OVERLAP_DUTY_CYCLE, 0.1);
        parameters.setParameterByKey(Parameters.KEY.MIN_PCT_ACTIVE_DUTY_CYCLE, 0.1);
        parameters.setParameterByKey(Parameters.KEY.DUTY_CYCLE_PERIOD, 10);
        parameters.setParameterByKey(Parameters.KEY.MAX_BOOST, 10.0);
        parameters.setParameterByKey(Parameters.KEY.SEED, 42);
        parameters.setParameterByKey(Parameters.KEY.SP_VERBOSITY, 0);
        parameters.setParameterByKey(Parameters.KEY.INITIAL_PERMANENCE, 0.2);
        parameters.setParameterByKey(Parameters.KEY.CONNECTED_PERMANENCE, 0.8);
        parameters.setParameterByKey(Parameters.KEY.MIN_THRESHOLD, 5);
        parameters.setParameterByKey(Parameters.KEY.MAX_NEW_SYNAPSE_COUNT, 6);
        parameters.setParameterByKey(Parameters.KEY.PERMANENCE_INCREMENT, 0.05);
        parameters.setParameterByKey(Parameters.KEY.PERMANENCE_DECREMENT, 0.05);
        parameters.setParameterByKey(Parameters.KEY.ACTIVATION_THRESHOLD, 4);
        return parameters;
    }
}

