/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.examples.qt;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.numenta.nupic.Connections;
import org.numenta.nupic.Parameters;
import org.numenta.nupic.algorithms.CLAClassifier;
import org.numenta.nupic.encoders.ScalarEncoder;
import org.numenta.nupic.model.Cell;
import org.numenta.nupic.research.ComputeCycle;
import org.numenta.nupic.research.SpatialPooler;
import org.numenta.nupic.research.TemporalMemory;
import org.numenta.nupic.util.ArrayUtils;

public class QuickTest {
    static boolean isResetting = true;

    public static void main(String[] args) {
        Parameters params = QuickTest.getParameters();
        System.out.println(params);
        isResetting = true;
        ScalarEncoder.Builder dayBuilder = (ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)ScalarEncoder.builder().n(8).w(3)).radius(1.0)).minVal(1.0)).maxVal(8.0)).periodic(true)).forced(true)).resolution(1.0);
        ScalarEncoder encoder = dayBuilder.build();
        SpatialPooler sp = new SpatialPooler();
        TemporalMemory tm = new TemporalMemory();
        CLAClassifier classifier = new CLAClassifier((TIntList)new TIntArrayList(new int[]{1}), 0.1, 0.3, 0);
        Layer<Double> layer = QuickTest.getLayer(params, encoder, sp, tm, classifier);
        double i = 0.0;
        for (double x = 0.0; x < 10000.0; x += 1.0) {
            if (i == 0.0 && isResetting) {
                tm.reset(layer.getMemory());
            }
            QuickTest.runThroughLayer(layer, i + 1.0, isResetting ? (int)i : (int)x, (int)x);
            i = i == 6.0 ? 0.0 : i + 1.0;
        }
    }

    public static Parameters getParameters() {
        Parameters parameters = Parameters.getAllDefaultParameters();
        parameters.setParameterByKey(Parameters.KEY.INPUT_DIMENSIONS, new int[]{8});
        parameters.setParameterByKey(Parameters.KEY.COLUMN_DIMENSIONS, new int[]{20});
        parameters.setParameterByKey(Parameters.KEY.CELLS_PER_COLUMN, 6);
        parameters.setParameterByKey(Parameters.KEY.POTENTIAL_RADIUS, 12);
        parameters.setParameterByKey(Parameters.KEY.POTENTIAL_PCT, 0.5);
        parameters.setParameterByKey(Parameters.KEY.GLOBAL_INHIBITIONS, false);
        parameters.setParameterByKey(Parameters.KEY.LOCAL_AREA_DENSITY, -1.0);
        parameters.setParameterByKey(Parameters.KEY.NUM_ACTIVE_COLUMNS_PER_INH_AREA, 5.0);
        parameters.setParameterByKey(Parameters.KEY.STIMULUS_THRESHOLD, 1.0);
        parameters.setParameterByKey(Parameters.KEY.SYN_PERM_INACTIVE_DEC, 5.0E-4);
        parameters.setParameterByKey(Parameters.KEY.SYN_PERM_ACTIVE_INC, 0.0015);
        parameters.setParameterByKey(Parameters.KEY.SYN_PERM_TRIM_THRESHOLD, 0.05);
        parameters.setParameterByKey(Parameters.KEY.SYN_PERM_CONNECTED, 0.1);
        parameters.setParameterByKey(Parameters.KEY.MIN_PCT_OVERLAP_DUTY_CYCLE, 0.1);
        parameters.setParameterByKey(Parameters.KEY.MIN_PCT_ACTIVE_DUTY_CYCLE, 0.1);
        parameters.setParameterByKey(Parameters.KEY.DUTY_CYCLE_PERIOD, 10);
        parameters.setParameterByKey(Parameters.KEY.MAX_BOOST, 10.0);
        parameters.setParameterByKey(Parameters.KEY.SEED, 42);
        parameters.setParameterByKey(Parameters.KEY.SP_VERBOSITY, 0);
        parameters.setParameterByKey(Parameters.KEY.INITIAL_PERMANENCE, 0.2);
        parameters.setParameterByKey(Parameters.KEY.CONNECTED_PERMANENCE, 0.8);
        parameters.setParameterByKey(Parameters.KEY.MIN_THRESHOLD, 5);
        parameters.setParameterByKey(Parameters.KEY.MAX_NEW_SYNAPSE_COUNT, 6);
        parameters.setParameterByKey(Parameters.KEY.PERMANENCE_INCREMENT, 0.05);
        parameters.setParameterByKey(Parameters.KEY.PERMANENCE_DECREMENT, 0.05);
        parameters.setParameterByKey(Parameters.KEY.ACTIVATION_THRESHOLD, 4);
        return parameters;
    }

    public static <T> void runThroughLayer(Layer<T> l, T input, int recordNum, int sequenceNum) {
        l.input(input, recordNum, sequenceNum);
    }

    public static Layer<Double> getLayer(Parameters p, ScalarEncoder e, SpatialPooler s, TemporalMemory t, CLAClassifier c) {
        LayerImpl l = new LayerImpl(p, e, s, t, c);
        return l;
    }

    static class LayerImpl
    implements Layer<Double> {
        private Parameters params;
        private Connections memory = new Connections();
        private ScalarEncoder encoder;
        private SpatialPooler spatialPooler;
        private TemporalMemory temporalMemory;
        private Map<String, Object> classification = new LinkedHashMap<String, Object>();
        private int columnCount;
        private int cellsPerColumn;
        private int[] predictedColumns;
        private int[] actual;
        private int[] lastPredicted;

        public LayerImpl(Parameters p, ScalarEncoder e, SpatialPooler s, TemporalMemory t, CLAClassifier c) {
            this.params = p;
            this.encoder = e;
            this.spatialPooler = s;
            this.temporalMemory = t;
            this.params.apply(this.memory);
            this.spatialPooler.init(this.memory);
            this.temporalMemory.init(this.memory);
            this.columnCount = this.memory.getPotentialPools().getMaxIndex() + 1;
            this.cellsPerColumn = this.memory.getCellsPerColumn();
        }

        @Override
        public void input(Double value, int recordNum, int sequenceNum) {
            if (value.intValue() == 1) {
                // empty if block
            }
            int[] output = new int[this.columnCount];
            int[] encoding = this.encoder.encode(value);
            int bucketIdx = this.encoder.getBucketIndices(value)[0];
            this.spatialPooler.compute(this.memory, encoding, output, true, true);
            if (sequenceNum < 1400) {
                return;
            }
            this.actual = ArrayUtils.where(output, ArrayUtils.WHERE_1);
            int[] input = this.actual;
            ComputeCycle cc = this.temporalMemory.compute(this.memory, input, true);
            this.lastPredicted = this.predictedColumns;
            this.predictedColumns = this.getSDR(cc.predictiveCells());
            this.classification.put("bucketIdx", bucketIdx);
            this.classification.put("actValue", value);
        }

        public int[] inflateSDR(int[] SDR, int len) {
            int[] retVal = new int[len];
            for (int i : SDR) {
                retVal[i] = 1;
            }
            return retVal;
        }

        public int[] getSDR(Set<Cell> cells) {
            int[] retVal = new int[cells.size()];
            int i = 0;
            Iterator<Cell> it = cells.iterator();
            while (i < retVal.length) {
                retVal[i] = it.next().getIndex();
                int n = i++;
                retVal[n] = retVal[n] / this.cellsPerColumn;
            }
            Arrays.sort(retVal);
            retVal = ArrayUtils.unique(retVal);
            return retVal;
        }

        @Override
        public int[] getPredicted() {
            return this.lastPredicted;
        }

        @Override
        public int[] getActual() {
            return this.actual;
        }

        @Override
        public Connections getMemory() {
            return this.memory;
        }
    }

    static interface Layer<T> {
        public void input(T var1, int var2, int var3);

        public int[] getPredicted();

        public Connections getMemory();

        public int[] getActual();
    }
}

