/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.examples.sp;

import java.util.Arrays;
import java.util.Random;
import org.numenta.nupic.Connections;
import org.numenta.nupic.Parameters;
import org.numenta.nupic.research.SpatialPooler;
import org.numenta.nupic.util.ArrayUtils;
import org.numenta.nupic.util.Condition;

public class HelloSP {
    private SpatialPooler sp;
    private Parameters parameters;
    private Connections mem;
    private int[] inputArray;
    private int[] activeArray;
    private int inputSize = 1;
    private int columnNumber = 1;

    HelloSP(int[] inputDimensions, int[] columnDimensions) {
        for (int x : inputDimensions) {
            this.inputSize *= x;
        }
        for (int x : columnDimensions) {
            this.columnNumber *= x;
        }
        this.activeArray = new int[this.columnNumber];
        this.parameters = Parameters.getSpatialDefaultParameters();
        this.parameters.setParameterByKey(Parameters.KEY.INPUT_DIMENSIONS, inputDimensions);
        this.parameters.setParameterByKey(Parameters.KEY.COLUMN_DIMENSIONS, columnDimensions);
        this.parameters.setParameterByKey(Parameters.KEY.POTENTIAL_RADIUS, this.inputSize);
        this.parameters.setParameterByKey(Parameters.KEY.GLOBAL_INHIBITIONS, true);
        this.parameters.setParameterByKey(Parameters.KEY.NUM_ACTIVE_COLUMNS_PER_INH_AREA, 0.02 * (double)this.columnNumber);
        this.parameters.setParameterByKey(Parameters.KEY.SYN_PERM_ACTIVE_INC, 0.01);
        this.parameters.setParameterByKey(Parameters.KEY.SYN_PERM_TRIM_THRESHOLD, 0.005);
        this.sp = new SpatialPooler();
        this.mem = new Connections();
        this.parameters.apply(this.mem);
        this.sp.init(this.mem);
    }

    public void createInput() {
        int i;
        for (i = 0; i < 70; ++i) {
            System.out.print("-");
        }
        System.out.print("Creating a random input vector");
        for (i = 0; i < 70; ++i) {
            System.out.print("-");
        }
        System.out.println();
        this.inputArray = new int[this.inputSize];
        Random rand = new Random();
        for (int i2 = 0; i2 < this.inputSize; ++i2) {
            this.inputArray[i2] = rand.nextInt(2);
        }
    }

    public void run() {
        int i;
        for (i = 0; i < 80; ++i) {
            System.out.print("-");
        }
        System.out.print("Computing the SDR");
        for (i = 0; i < 70; ++i) {
            System.out.print("-");
        }
        System.out.println();
        this.sp.compute(this.mem, this.inputArray, this.activeArray, true, true);
        int[] res = ArrayUtils.where(this.activeArray, new Condition.Adapter<Object>(){

            @Override
            public boolean eval(int n) {
                return n > 0;
            }
        });
        System.out.println(Arrays.toString(res));
    }

    public void addNoise(double noiseLevel) {
        Random rand = new Random();
        int i = 0;
        while ((double)i < noiseLevel * (double)this.inputSize) {
            int randomPosition = rand.nextInt(this.inputSize);
            this.inputArray[randomPosition] = 1 - this.inputArray[randomPosition];
            ++i;
        }
    }

    public static void main(String[] args) {
        int i;
        HelloSP example = new HelloSP(new int[]{32, 32}, new int[]{64, 64});
        System.out.println("\n \nFollowing columns represent the SDR");
        System.out.println("Different set of columns each time since we randomize the input");
        System.out.println("Lesson - different input vectors give different SDRs\n\n");
        for (i = 0; i < 3; ++i) {
            example.createInput();
            example.run();
        }
        System.out.println("\n\nIdentical SDRs because we give identical inputs");
        System.out.println("Lesson - identical inputs give identical SDRs\n\n");
        for (i = 0; i < 75; ++i) {
            System.out.print("-");
        }
        System.out.print("Using identical input vectors");
        for (i = 0; i < 75; ++i) {
            System.out.print("-");
        }
        System.out.println();
        for (i = 0; i < 2; ++i) {
            example.run();
        }
        System.out.println("\n\nNow we are changing the input vector slightly.");
        System.out.println("We change a small percentage of 1s to 0s and 0s to 1s.");
        System.out.println("The resulting SDRs are similar, but not identical to the original SDR");
        System.out.println("Lesson - Similar input vectors give similar SDRs\n\n");
        for (i = 0; i < 75; ++i) {
            System.out.print("-");
        }
        System.out.print("After adding 10% noise to the input vector");
        for (i = 0; i < 75; ++i) {
            System.out.print("-");
        }
        example.addNoise(0.1);
        example.run();
        for (i = 0; i < 75; ++i) {
            System.out.print("-");
        }
        System.out.print("After adding another 20% noise to the input vector");
        for (i = 0; i < 75; ++i) {
            System.out.print("-");
        }
        example.addNoise(0.2);
        example.run();
    }
}

