/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.model;

import java.util.List;
import java.util.Set;
import org.numenta.nupic.Connections;
import org.numenta.nupic.model.Column;
import org.numenta.nupic.model.DistalDendrite;
import org.numenta.nupic.model.Synapse;

public class Cell
implements Comparable<Cell> {
    private final int index;
    final Integer boxedIndex;
    private final Column parentColumn;

    public Cell(Column column, int colSeq) {
        this.parentColumn = column;
        this.index = column.getIndex() * column.getNumCellsPerColumn() + colSeq;
        this.boxedIndex = new Integer(colSeq);
    }

    public int getIndex() {
        return this.index;
    }

    public Column getParentColumn() {
        return this.parentColumn;
    }

    public void addReceptorSynapse(Connections c, Synapse s) {
        c.getReceptorSynapses(this).add(s);
    }

    public Set<Synapse> getReceptorSynapses(Connections c) {
        return c.getReceptorSynapses(this);
    }

    public DistalDendrite createSegment(Connections c, int index) {
        DistalDendrite dd = new DistalDendrite(this, index);
        c.getSegments(this).add(dd);
        return dd;
    }

    public List<DistalDendrite> getSegments(Connections c) {
        return c.getSegments(this);
    }

    public String toString() {
        return "Cell: col=" + this.parentColumn.getIndex() + ", idx=" + this.index;
    }

    @Override
    public int compareTo(Cell arg0) {
        return this.boxedIndex.compareTo(arg0.boxedIndex);
    }
}

