/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.numenta.nupic.Connections;
import org.numenta.nupic.model.Cell;
import org.numenta.nupic.model.Pool;
import org.numenta.nupic.model.Segment;
import org.numenta.nupic.model.Synapse;

public class DistalDendrite
extends Segment {
    private Cell cell;
    private int index;
    private static final Set<Synapse> EMPTY_SYNAPSE_SET = Collections.emptySet();

    public DistalDendrite(Cell cell, int index) {
        this.cell = cell;
        this.index = index;
    }

    public Cell getParentCell() {
        return this.cell;
    }

    public Synapse createSynapse(Connections c, Cell sourceCell, double permanence, int index) {
        Pool pool = new Pool(1);
        Synapse s = super.createSynapse(c, c.getSynapses(this), sourceCell, pool, index, sourceCell.getIndex());
        pool.setPermanence(c, s, permanence);
        return s;
    }

    public List<Synapse> getAllSynapses(Connections c) {
        return c.getSynapses(this);
    }

    public Set<Synapse> getConnectedActiveSynapses(Map<DistalDendrite, Set<Synapse>> activeSynapsesForSegment, double permanenceThreshold) {
        LinkedHashSet<Synapse> connectedSynapses = null;
        if (!activeSynapsesForSegment.containsKey(this)) {
            return EMPTY_SYNAPSE_SET;
        }
        for (Synapse s : activeSynapsesForSegment.get(this)) {
            if (!(s.getPermanence() >= permanenceThreshold)) continue;
            if (connectedSynapses == null) {
                connectedSynapses = new LinkedHashSet<Synapse>();
            }
            connectedSynapses.add(s);
        }
        return connectedSynapses == null ? EMPTY_SYNAPSE_SET : connectedSynapses;
    }

    public void adaptSegment(Connections c, Set<Synapse> activeSynapses, double permanenceIncrement, double permanenceDecrement) {
        for (Synapse synapse : c.getSynapses(this)) {
            double permanence = synapse.getPermanence();
            permanence = activeSynapses.contains(synapse) ? (permanence += permanenceIncrement) : (permanence -= permanenceDecrement);
            permanence = permanence < 0.0 ? 0.0 : (permanence > 1.0 ? 1.0 : permanence);
            synapse.setPermanence(c, permanence);
        }
    }

    public Set<Cell> pickCellsToLearnOn(Connections c, int numPickCells, Set<Cell> prevWinners, Random random) {
        LinkedHashSet<Cell> candidates = new LinkedHashSet<Cell>(prevWinners);
        for (Synapse synapse : c.getSynapses(this)) {
            Cell sourceCell = synapse.getSourceCell();
            if (!candidates.contains(sourceCell)) continue;
            candidates.remove(sourceCell);
        }
        numPickCells = Math.min(numPickCells, candidates.size());
        ArrayList<Cell> cands = new ArrayList<Cell>(candidates);
        Collections.sort(cands);
        LinkedHashSet<Cell> cells = new LinkedHashSet<Cell>();
        for (int x = 0; x < numPickCells; ++x) {
            int i = random.nextInt(cands.size());
            cells.add((Cell)cands.remove(i));
        }
        return cells;
    }

    public String toString() {
        return "" + this.index;
    }
}

