/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.model;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import org.numenta.nupic.Connections;
import org.numenta.nupic.model.Synapse;
import org.numenta.nupic.util.ArrayUtils;

public class Pool {
    int size;
    private TIntHashSet synapseConnections = new TIntHashSet();
    private TIntObjectMap<Synapse> synapsesBySourceIndex = new TIntObjectHashMap();

    public Pool(int size) {
        this.size = size;
    }

    public double getPermanence(Synapse s) {
        return ((Synapse)this.synapsesBySourceIndex.get(s.getInputIndex())).getPermanence();
    }

    public void setPermanence(Connections c, Synapse s, double permanence) {
        this.updatePool(c, s, permanence);
        s.setPermanence(c, permanence);
    }

    public void updatePool(Connections c, Synapse s, double permanence) {
        int inputIndex = s.getInputIndex();
        if (this.synapsesBySourceIndex.get(inputIndex) == null) {
            this.synapsesBySourceIndex.put(inputIndex, (Object)s);
        }
        if (permanence > c.getSynPermConnected()) {
            this.synapseConnections.add(inputIndex);
        } else {
            this.synapseConnections.remove(inputIndex);
        }
    }

    public void resetConnections() {
        this.synapseConnections.clear();
    }

    public Synapse getSynapseWithInput(int inputIndex) {
        return (Synapse)this.synapsesBySourceIndex.get(inputIndex);
    }

    public double[] getSparsePermanences() {
        double[] retVal = new double[this.size];
        int[] keys = this.synapsesBySourceIndex.keys();
        int x = 0;
        int j = this.size - 1;
        while (x < this.size) {
            retVal[j] = ((Synapse)this.synapsesBySourceIndex.get(keys[x])).getPermanence();
            ++x;
            --j;
        }
        return retVal;
    }

    public double[] getDensePermanences(Connections c) {
        int[] keys;
        double[] retVal = new double[c.getNumInputs()];
        for (int inputIndex : keys = this.synapsesBySourceIndex.keys()) {
            retVal[inputIndex] = ((Synapse)this.synapsesBySourceIndex.get(inputIndex)).getPermanence();
        }
        return retVal;
    }

    public int[] getSparseConnections() {
        int[] keys = ArrayUtils.reverse(this.synapsesBySourceIndex.keys());
        return keys;
    }

    public int[] getDenseConnections(Connections c) {
        int[] retVal = new int[c.getNumInputs()];
        for (int inputIndex : this.synapseConnections.toArray()) {
            retVal[inputIndex] = 1;
        }
        return retVal;
    }
}

