/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.numenta.nupic.Connections;
import org.numenta.nupic.Parameters;
import org.numenta.nupic.algorithms.Anomaly;
import org.numenta.nupic.algorithms.CLAClassifier;
import org.numenta.nupic.algorithms.ClassifierResult;
import org.numenta.nupic.encoders.DateEncoder;
import org.numenta.nupic.encoders.Encoder;
import org.numenta.nupic.encoders.EncoderTuple;
import org.numenta.nupic.encoders.MultiEncoder;
import org.numenta.nupic.model.Cell;
import org.numenta.nupic.network.Inference;
import org.numenta.nupic.network.ManualInput;
import org.numenta.nupic.network.Network;
import org.numenta.nupic.network.Region;
import org.numenta.nupic.network.sensor.HTMSensor;
import org.numenta.nupic.network.sensor.Sensor;
import org.numenta.nupic.research.ComputeCycle;
import org.numenta.nupic.research.SpatialPooler;
import org.numenta.nupic.research.TemporalMemory;
import org.numenta.nupic.util.ArrayUtils;
import org.numenta.nupic.util.NamedTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Func1;
import rx.subjects.PublishSubject;

public class Layer<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Layer.class);
    private Network parentNetwork;
    private Region parentRegion;
    private Parameters params;
    private Connections connections;
    private HTMSensor<?> sensor;
    private MultiEncoder encoder;
    private SpatialPooler spatialPooler;
    private TemporalMemory temporalMemory;
    private Boolean autoCreateClassifiers;
    private Anomaly anomalyComputer;
    private PublishSubject<T> publisher = null;
    private Subscription subscription;
    private Observable<Inference> userObservable;
    private Inference currentInference;
    FunctionFactory factory;
    private int[] activeColumns;
    private int[] sparseActives;
    private int[] previousPrediction;
    private int[] currentPrediction;
    private int cellsPerColumn;
    private int recordNum = -1;
    private String name;
    private boolean isClosed;
    private boolean isHalted;
    private Layer<Inference> next;
    private Layer<Inference> previous;
    private List<Observer<Inference>> observers = new ArrayList<Observer<Inference>>();
    private List<Observer<Inference>> subscribers = Collections.synchronizedList(new ArrayList());
    private List<Object> addedItems = new ArrayList<Object>();
    private boolean hasGenericProcess;
    private List<EncoderTuple> encoderTuples;
    private Map<Class<T>, Observable<ManualInput>> observableDispatch = Collections.synchronizedMap(new HashMap());
    private Thread LAYER_THREAD;
    static final byte SPATIAL_POOLER = 1;
    static final byte TEMPORAL_MEMORY = 2;
    static final byte CLA_CLASSIFIER = 4;
    static final byte ANOMALY_COMPUTER = 8;
    private byte algo_content_mask = 0;

    public Layer(Network n) {
        this(n, n.getParameters());
    }

    public Layer(Network n, Parameters p) {
        this("[Layer " + System.currentTimeMillis() + "]", n, p);
    }

    public Layer(String name, Network n, Parameters p) {
        this.name = name;
        this.parentNetwork = n;
        this.params = p;
        this.connections = new Connections();
        this.autoCreateClassifiers = (Boolean)p.getParameterByKey(Parameters.KEY.AUTO_CLASSIFY);
        this.factory = new FunctionFactory();
        this.observableDispatch = this.createDispatchMap();
    }

    public void setNetwork(Network network) {
        this.parentNetwork = network;
    }

    public Layer(Parameters params, MultiEncoder e, SpatialPooler sp, TemporalMemory tm, Boolean autoCreateClassifiers, Anomaly a) {
        if (params == null) {
            throw new IllegalArgumentException("No parameters specified.");
        }
        if (params.getParameterByKey(Parameters.KEY.FIELD_ENCODING_MAP) == null && e != null) {
            throw new IllegalArgumentException("The passed in Parameters must contain a field encoding map specified by org.numenta.nupic.Parameters.KEY.FIELD_ENCODING_MAP");
        }
        this.params = params;
        this.encoder = e;
        this.spatialPooler = sp;
        this.temporalMemory = tm;
        this.autoCreateClassifiers = autoCreateClassifiers;
        this.anomalyComputer = a;
        this.connections = new Connections();
        this.factory = new FunctionFactory();
        this.observableDispatch = this.createDispatchMap();
        this.initializeMask();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Layer successfully created containing: {}{}{}{}{}", new Object[]{this.encoder == null ? "" : "MultiEncoder,", this.spatialPooler == null ? "" : "SpatialPooler,", this.temporalMemory == null ? "" : "TemporalMemory,", autoCreateClassifiers == null ? "" : "Auto creating CLAClassifiers for each input field.", this.anomalyComputer == null ? "" : "Anomaly"});
        }
    }

    public void setRegion(Region r) {
        this.parentRegion = r;
    }

    public Layer<T> close() {
        block17: {
            int columnLength;
            int inputLength;
            int product;
            block18: {
                if (this.isClosed) {
                    LOGGER.warn("Close called on Layer " + this.getName() + " which is already closed.");
                    return this;
                }
                this.params.apply(this.connections);
                if (this.sensor != null) {
                    this.encoder = this.encoder == null ? this.sensor.getEncoder() : this.encoder;
                    this.sensor.initEncoder(this.params);
                    this.connections.setNumInputs(this.encoder.getWidth());
                    if (this.parentNetwork != null && this.parentRegion != null) {
                        this.parentNetwork.setSensorRegion(this.parentRegion);
                    }
                }
                if (this.encoder == null) break block17;
                if (this.encoder.getEncoders(this.encoder) == null || this.encoder.getEncoders(this.encoder).size() < 1) {
                    if (this.params.getParameterByKey(Parameters.KEY.FIELD_ENCODING_MAP) == null || ((Map)this.params.getParameterByKey(Parameters.KEY.FIELD_ENCODING_MAP)).size() < 1) {
                        LOGGER.error("No field encoding map found for specified MultiEncoder");
                        throw new IllegalStateException("No field encoding map found for specified MultiEncoder");
                    }
                    this.encoder.addMultipleEncoders((Map)this.params.getParameterByKey(Parameters.KEY.FIELD_ENCODING_MAP));
                }
                product = 0;
                inputLength = 0;
                columnLength = 0;
                inputLength = ((int[])this.params.getParameterByKey(Parameters.KEY.INPUT_DIMENSIONS)).length;
                if (inputLength != (columnLength = ((int[])this.params.getParameterByKey(Parameters.KEY.COLUMN_DIMENSIONS)).length)) break block18;
                product = ArrayUtils.product((int[])this.params.getParameterByKey(Parameters.KEY.INPUT_DIMENSIONS));
                if (this.encoder.getWidth() == product) break block17;
            }
            LOGGER.warn("The number of Input Dimensions (" + inputLength + ") != number of Column Dimensions " + "(" + columnLength + ") --OR-- Encoder width (" + this.encoder.getWidth() + ") != product of dimensions (" + product + ") -- now attempting to fix it.");
            int[] inferredDims = this.inferInputDimensions(this.encoder.getWidth(), columnLength);
            if (inferredDims != null && inferredDims.length > 0 && this.encoder.getWidth() == ArrayUtils.product(inferredDims)) {
                LOGGER.info("Input dimension fix successful!");
                LOGGER.info("Using calculated input dimensions: " + Arrays.toString(inferredDims));
            }
            this.params.setInputDimensions(inferredDims);
            this.connections.setInputDimensions(inferredDims);
        }
        this.autoCreateClassifiers = this.autoCreateClassifiers != null && this.autoCreateClassifiers | (Boolean)this.params.getParameterByKey(Parameters.KEY.AUTO_CLASSIFY);
        if (this.autoCreateClassifiers != null && this.autoCreateClassifiers.booleanValue() && (this.factory.inference.getClassifiers() == null || this.factory.inference.getClassifiers().size() < 1)) {
            this.factory.inference.classifiers(this.makeClassifiers(this.encoder == null ? this.parentNetwork.getEncoder() : this.encoder));
            this.algo_content_mask = (byte)(this.algo_content_mask | 4);
        }
        if (this.parentRegion != null && this.parentRegion.getUpstreamRegion() != null) {
            int[] upstreamDims = this.parentRegion.getUpstreamRegion().getHead().getConnections().getColumnDimensions();
            this.params.setInputDimensions(upstreamDims);
            this.connections.setInputDimensions(upstreamDims);
        } else if (this.parentRegion != null && this.parentNetwork != null && this.parentRegion.equals(this.parentNetwork.getSensorRegion()) && this.encoder == null && this.spatialPooler != null) {
            Layer<Inference> curr = this;
            while ((curr = curr.getPrevious()) != null) {
                if (curr.getEncoder() == null) continue;
                int[] dims = (int[])curr.getParameters().getParameterByKey(Parameters.KEY.INPUT_DIMENSIONS);
                this.params.setInputDimensions(dims);
                this.connections.setInputDimensions(dims);
            }
        }
        if (this.spatialPooler != null) {
            int columnLength = 0;
            int inputLength = ((int[])this.params.getParameterByKey(Parameters.KEY.INPUT_DIMENSIONS)).length;
            if (inputLength != (columnLength = ((int[])this.params.getParameterByKey(Parameters.KEY.COLUMN_DIMENSIONS)).length)) {
                LOGGER.warn("The number of Input Dimensions (" + inputLength + ") is not same as the number of Column Dimensions " + "(" + columnLength + ") in Parameters!");
                return this;
            }
            this.spatialPooler.init(this.connections);
        }
        if (this.temporalMemory != null) {
            this.temporalMemory.init(this.connections);
        }
        this.activeColumns = new int[this.connections.getNumColumns()];
        this.cellsPerColumn = this.connections.getCellsPerColumn();
        this.isClosed = true;
        LOGGER.debug("Layer " + this.name + " content initialize mask = " + Integer.toBinaryString(this.algo_content_mask));
        return this;
    }

    public int[] inferInputDimensions(int inputWidth, int numColumnDims) {
        double flatSize = inputWidth;
        double numColDims = numColumnDims;
        double sliceArrangement = Math.pow(flatSize, 1.0 / numColDims);
        double remainder = sliceArrangement % (double)((int)sliceArrangement);
        int[] retVal = new int[(int)numColDims];
        if (remainder > 0.0) {
            int i = 0;
            while ((double)i < numColDims - 1.0) {
                retVal[i] = 1;
                ++i;
            }
            retVal[(int)numColDims - 1] = (int)flatSize;
        } else {
            int i = 0;
            while ((double)i < numColDims) {
                retVal[i] = (int)sliceArrangement;
                ++i;
            }
        }
        return retVal;
    }

    public Observable<Inference> observe() {
        if (this.userObservable == null) {
            this.userObservable = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Inference>(){

                public void call(Subscriber<? super Inference> t1) {
                    Layer.this.observers.add(t1);
                }
            });
        }
        return this.userObservable;
    }

    public Subscription subscribe(Observer<Inference> subscriber) {
        if (subscriber == null) {
            throw new IllegalArgumentException("Subscriber cannot be null.");
        }
        this.subscribers.add(subscriber);
        return this.createSubscription(subscriber);
    }

    public Layer<T> using(Connections c) {
        if (this.isClosed) {
            throw new IllegalStateException("Layer already \"closed\"");
        }
        this.connections = c;
        return this;
    }

    public Layer<T> using(Parameters p) {
        if (this.isClosed) {
            throw new IllegalStateException("Layer already \"closed\"");
        }
        this.params = p;
        return this;
    }

    public Layer<T> add(Sensor sensor) {
        if (this.isClosed) {
            throw new IllegalStateException("Layer already \"closed\"");
        }
        this.sensor = (HTMSensor)sensor;
        if (this.parentNetwork != null && this.parentRegion != null) {
            this.parentNetwork.setSensorRegion(this.parentRegion);
        }
        return this;
    }

    public Layer<T> add(MultiEncoder encoder) {
        if (this.isClosed) {
            throw new IllegalStateException("Layer already \"closed\"");
        }
        this.encoder = encoder;
        return this;
    }

    public Layer<T> add(SpatialPooler sp) {
        if (this.isClosed) {
            throw new IllegalStateException("Layer already \"closed\"");
        }
        this.addedItems.add(sp);
        this.algo_content_mask = (byte)(this.algo_content_mask | 1);
        this.spatialPooler = sp;
        return this;
    }

    public Layer<T> add(TemporalMemory tm) {
        if (this.isClosed) {
            throw new IllegalStateException("Layer already \"closed\"");
        }
        this.addedItems.add(tm);
        this.algo_content_mask = (byte)(this.algo_content_mask | 2);
        this.temporalMemory = tm;
        return this;
    }

    public Layer<T> add(Anomaly anomalyComputer) {
        if (this.isClosed) {
            throw new IllegalStateException("Layer already \"closed\"");
        }
        this.addedItems.add(anomalyComputer);
        this.algo_content_mask = (byte)(this.algo_content_mask | 8);
        this.anomalyComputer = anomalyComputer;
        return this;
    }

    public Layer<T> add(Func1<ManualInput, ManualInput> func) {
        if (this.isClosed) {
            throw new IllegalStateException("Layer already \"closed\"");
        }
        if (func == null) {
            throw new IllegalArgumentException("Cannot add a null Function");
        }
        this.hasGenericProcess = true;
        this.addedItems.add(func);
        return this;
    }

    public Layer<T> alterParameter(Parameters.KEY key, Object value) {
        if (this.isClosed) {
            throw new IllegalStateException("Layer already \"closed\"");
        }
        int[] inputDims = (int[])this.params.getParameterByKey(Parameters.KEY.INPUT_DIMENSIONS);
        this.params = this.params.copy();
        this.params.setParameterByKey(key, value);
        this.params.setParameterByKey(Parameters.KEY.INPUT_DIMENSIONS, inputDims);
        if (key == Parameters.KEY.AUTO_CLASSIFY) {
            this.autoCreateClassifiers = value == null ? false : (Boolean)value;
            this.algo_content_mask = (byte)(this.algo_content_mask | 4);
        }
        return this;
    }

    public HTMSensor<?> getSensor() {
        return this.sensor;
    }

    public Connections getConnections() {
        return this.connections;
    }

    public void compute(T t) {
        if (!this.isClosed) {
            this.close();
        }
        this.increment();
        if (!this.dispatchCompleted()) {
            this.completeDispatch(t);
        }
        this.publisher.onNext(t);
    }

    public void halt() {
        if (this.LAYER_THREAD == null) {
            this.publisher.onCompleted();
            if (this.next != null) {
                this.next.halt();
            }
        }
        this.isHalted = true;
    }

    public boolean isHalted() {
        return this.isHalted;
    }

    public void start() {
        if (!this.isClosed) {
            this.close();
        }
        if (this.sensor == null) {
            throw new IllegalStateException("A sensor must be added when the mode is not Network.Mode.MANUAL");
        }
        this.encoder = this.encoder == null ? this.sensor.getEncoder() : this.encoder;
        this.completeDispatch(new int[0]);
        this.LAYER_THREAD = new Thread("Sensor Layer [" + this.getName() + "] Thread"){

            @Override
            public void run() {
                LOGGER.debug("Layer [" + this.getName() + "] started Sensor output stream processing.");
                Layer.this.sensor.getOutputStream().filter(i -> {
                    if (Layer.this.isHalted) {
                        Layer.this.notifyComplete();
                        if (Layer.this.next != null) {
                            Layer.this.next.halt();
                        }
                        return false;
                    }
                    return true;
                }).forEach(intArray -> {
                    Layer.this.factory.inference.encoding((int[])intArray);
                    Layer.this.compute(intArray);
                    if (!Layer.this.sensor.hasNext()) {
                        Layer.this.notifyComplete();
                    }
                });
            }
        };
        this.LAYER_THREAD.start();
        LOGGER.debug("Start called on Layer thread {}", (Object)this.LAYER_THREAD);
    }

    public void next(Layer<Inference> l) {
        this.next = l;
    }

    public Layer<Inference> getNext() {
        return this.next;
    }

    public void previous(Layer<Inference> l) {
        this.previous = l;
    }

    public Layer<Inference> getPrevious() {
        return this.previous;
    }

    public boolean hasSensor() {
        return this.sensor != null;
    }

    public Thread getLayerThread() {
        if (this.LAYER_THREAD != null) {
            return this.LAYER_THREAD;
        }
        return Thread.currentThread();
    }

    public Parameters getParameters() {
        return this.params;
    }

    public int[] getPredictedColumns() {
        return this.currentPrediction;
    }

    public int[] getPreviousPredictedColumns() {
        return this.previousPrediction;
    }

    public int[] getActiveColumns() {
        return this.activeColumns;
    }

    int[] sparseActives(int[] activesInSparseForm) {
        this.sparseActives = activesInSparseForm;
        return this.sparseActives;
    }

    public int[] getSparseActives() {
        return this.sparseActives;
    }

    public Connections getMemory() {
        return this.connections;
    }

    public int getRecordNum() {
        return this.recordNum;
    }

    public Layer<T> resetRecordNum() {
        this.recordNum = 0;
        return this;
    }

    public void reset() {
        if (this.temporalMemory == null) {
            LOGGER.debug("Attempt to reset Layer: " + this.getName() + "without TemporalMemory");
        } else {
            this.temporalMemory.reset(this.connections);
            this.resetRecordNum();
        }
    }

    public boolean hasTemporalMemory() {
        return this.temporalMemory != null;
    }

    public Layer<T> increment() {
        ++this.recordNum;
        return this;
    }

    public Layer<T> skip(int count) {
        this.recordNum += count;
        return this;
    }

    Layer<T> name(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Inference getInference() {
        return this.currentInference;
    }

    public MultiEncoder getEncoder() {
        if (this.encoder != null) {
            return this.encoder;
        }
        if (this.hasSensor()) {
            return this.sensor.getEncoder();
        }
        MultiEncoder e = this.parentNetwork.getEncoder();
        if (e != null) {
            return e;
        }
        return null;
    }

    public <V> V[] getAllValues(String field, int step) {
        if (this.currentInference == null || this.currentInference.getClassifiers() == null) {
            throw new IllegalStateException("Predictions not available. Either classifiers unspecified or inferencing has not yet begun.");
        }
        ClassifierResult<Object> c = this.currentInference.getClassification(field);
        if (c == null) {
            LOGGER.debug("No ClassifierResult exists for the specified field: {}", (Object)field);
        }
        return c.getActualValues();
    }

    public double[] getAllPredictions(String field, int step) {
        if (this.currentInference == null || this.currentInference.getClassifiers() == null) {
            throw new IllegalStateException("Predictions not available. Either classifiers unspecified or inferencing has not yet begun.");
        }
        ClassifierResult<Object> c = this.currentInference.getClassification(field);
        if (c == null) {
            LOGGER.debug("No ClassifierResult exists for the specified field: {}", (Object)field);
        }
        return c.getStats(step);
    }

    public <K> K getMostProbableValue(String field, int step) {
        if (this.currentInference == null || this.currentInference.getClassifiers() == null) {
            throw new IllegalStateException("Predictions not available. Either classifiers unspecified or inferencing has not yet begun.");
        }
        ClassifierResult<Object> c = this.currentInference.getClassification(field);
        if (c == null) {
            LOGGER.debug("No ClassifierResult exists for the specified field: {}", (Object)field);
        }
        return (K)c.getMostProbableValue(step);
    }

    public int getMostProbableBucketIndex(String field, int step) {
        if (this.currentInference == null || this.currentInference.getClassifiers() == null) {
            throw new IllegalStateException("Predictions not available. Either classifiers unspecified or inferencing has not yet begun.");
        }
        ClassifierResult<Object> c = this.currentInference.getClassification(field);
        if (c == null) {
            LOGGER.debug("No ClassifierResult exists for the specified field: {}", (Object)field);
        }
        return c.getMostProbableBucketIndex(step);
    }

    void notifyComplete() {
        for (Observer<Inference> o : this.subscribers) {
            o.onCompleted();
        }
        for (Observer<Inference> o : this.observers) {
            o.onCompleted();
        }
        this.publisher.onCompleted();
    }

    byte getMask() {
        return this.algo_content_mask;
    }

    private void initializeMask() {
        this.algo_content_mask = (byte)(this.algo_content_mask | (this.spatialPooler == null ? (byte)0 : 1));
        this.algo_content_mask = (byte)(this.algo_content_mask | (this.temporalMemory == null ? 0 : 2));
        this.algo_content_mask = (byte)(this.algo_content_mask | (this.autoCreateClassifiers == null || this.autoCreateClassifiers == false ? 0 : 4));
        this.algo_content_mask = (byte)(this.algo_content_mask | (this.anomalyComputer == null ? 0 : 8));
    }

    private boolean dispatchCompleted() {
        return this.observableDispatch == null;
    }

    private void completeDispatch(T t) {
        Observable<ManualInput> sequence = this.resolveObservableSequence(t);
        sequence = this.mapEncoderBuckets(sequence);
        sequence = this.fillInSequence(sequence);
        this.subscribers.add(0, this.getDelegateObserver());
        this.subscription = sequence.subscribe(this.getDelegateSubscriber());
        this.observableDispatch.clear();
        this.observableDispatch = null;
        if (this.sensor == null) {
            this.sensor = this.parentNetwork == null ? null : this.parentNetwork.getSensor();
        } else if (this.parentNetwork != null) {
            this.parentNetwork.setSensor(this.sensor);
        }
    }

    private Map<Class<T>, Observable<ManualInput>> createDispatchMap() {
        Map<Class<T>, Observable<ManualInput>> observableDispatch = Collections.synchronizedMap(new HashMap());
        this.publisher = PublishSubject.create();
        observableDispatch.put(Map.class, this.factory.createMultiMapFunc(this.publisher));
        observableDispatch.put(ManualInput.class, this.factory.createManualInputFunc(this.publisher));
        observableDispatch.put(String[].class, this.factory.createEncoderFunc(this.publisher));
        observableDispatch.put(int[].class, this.factory.createVectorFunc(this.publisher));
        return observableDispatch;
    }

    private Observable<ManualInput> mapEncoderBuckets(Observable<ManualInput> sequence) {
        if (this.hasSensor()) {
            sequence = sequence.map(m -> {
                this.doEncoderBucketMapping((Inference)m, this.getSensor().getInputMap());
                return m;
            });
        }
        return sequence;
    }

    private Observable<ManualInput> resolveObservableSequence(T t) {
        Observable<ManualInput> sequenceStart = null;
        if (this.observableDispatch != null) {
            if (ManualInput.class.isAssignableFrom(t.getClass())) {
                sequenceStart = this.observableDispatch.get(ManualInput.class);
            } else if (Map.class.isAssignableFrom(t.getClass())) {
                sequenceStart = this.observableDispatch.get(Map.class);
            } else if (t.getClass().isArray()) {
                if (t.getClass().equals(String[].class)) {
                    sequenceStart = this.observableDispatch.get(String[].class);
                } else if (t.getClass().equals(int[].class)) {
                    sequenceStart = this.observableDispatch.get(int[].class);
                }
            }
        }
        return sequenceStart;
    }

    private void doEncoderBucketMapping(Inference inference, Map<String, Object> encoderInputMap) {
        if (this.encoderTuples == null) {
            this.encoderTuples = this.encoder.getEncoders(this.encoder);
        }
        int[] encoding = inference.getEncoding();
        for (EncoderTuple t : this.encoderTuples) {
            String name = t.getName();
            Encoder<?> e = t.getEncoder();
            int bucketIdx = -1;
            Object o = encoderInputMap.get(name);
            bucketIdx = DateTime.class.isAssignableFrom(o.getClass()) ? ((DateEncoder)e).getBucketIndices((DateTime)o)[0] : (Number.class.isAssignableFrom(o.getClass()) ? e.getBucketIndices((Double)o)[0] : e.getBucketIndices((String)o)[0]);
            int offset = t.getOffset();
            int[] tempArray = new int[e.getWidth()];
            System.arraycopy(encoding, offset, tempArray, 0, tempArray.length);
            inference.getClassifierInput().put(name, new NamedTuple(new String[]{"name", "inputValue", "bucketIdx", "encoding"}, new Object[]{name, o, bucketIdx, tempArray}));
        }
    }

    private Observable<ManualInput> fillInSequence(Observable<ManualInput> o) {
        if (this.hasGenericProcess) {
            return this.fillInOrderedSequence(o);
        }
        if (this.spatialPooler != null) {
            Integer skipCount = 0;
            skipCount = (Integer)this.params.getParameterByKey(Parameters.KEY.SP_PRIMER_DELAY);
            o = skipCount != null ? o.map(this.factory.createSpatialFunc(this.spatialPooler)).skip(skipCount.intValue()) : o.map(this.factory.createSpatialFunc(this.spatialPooler));
        }
        if (this.temporalMemory != null) {
            o = o.map(this.factory.createTemporalFunc(this.temporalMemory));
        }
        if (this.autoCreateClassifiers != null && this.autoCreateClassifiers.booleanValue()) {
            o = o.map(this.factory.createClassifierFunc());
        }
        if (this.anomalyComputer != null) {
            o = o.map(this.factory.createAnomalyFunc(this.anomalyComputer));
        }
        return o;
    }

    private Observable<ManualInput> fillInOrderedSequence(Observable<ManualInput> o) {
        for (Object node : this.addedItems) {
            if (node instanceof Func1) {
                o = o.map((Func1)node);
                continue;
            }
            if (node instanceof SpatialPooler) {
                Integer skipCount = 0;
                skipCount = (Integer)this.params.getParameterByKey(Parameters.KEY.SP_PRIMER_DELAY);
                if (skipCount != null) {
                    o = o.map(this.factory.createSpatialFunc(this.spatialPooler)).skip(skipCount.intValue());
                    continue;
                }
                o = o.map(this.factory.createSpatialFunc(this.spatialPooler));
                continue;
            }
            if (!(node instanceof TemporalMemory)) continue;
            o = o.map(this.factory.createTemporalFunc(this.temporalMemory));
        }
        if (this.autoCreateClassifiers != null && this.autoCreateClassifiers.booleanValue()) {
            o = o.map(this.factory.createClassifierFunc());
        }
        if (this.anomalyComputer != null) {
            o = o.map(this.factory.createAnomalyFunc(this.anomalyComputer));
        }
        return o;
    }

    private Subscription createSubscription(final Observer<Inference> sub) {
        return new Subscription(){
            private Observer<Inference> observer;
            {
                this.observer = sub;
            }

            public void unsubscribe() {
                Layer.this.subscribers.remove(this.observer);
                if (Layer.this.subscribers.isEmpty()) {
                    Layer.this.subscription.unsubscribe();
                }
            }

            public boolean isUnsubscribed() {
                return Layer.this.subscribers.contains(this.observer);
            }
        };
    }

    private Observer<Inference> getDelegateSubscriber() {
        return new Observer<Inference>(){

            public void onCompleted() {
                for (Observer o : Layer.this.subscribers) {
                    o.onCompleted();
                }
            }

            public void onError(Throwable e) {
                for (Observer o : Layer.this.subscribers) {
                    o.onError(e);
                }
            }

            public void onNext(Inference i) {
                Layer.this.currentInference = i;
                for (Observer o : Layer.this.subscribers) {
                    o.onNext((Object)i);
                }
            }
        };
    }

    private Observer<Inference> getDelegateObserver() {
        return new Observer<Inference>(){

            public void onCompleted() {
                for (Observer o : Layer.this.observers) {
                    o.onCompleted();
                }
            }

            public void onError(Throwable e) {
                for (Observer o : Layer.this.observers) {
                    o.onError(e);
                    e.printStackTrace();
                }
            }

            public void onNext(Inference i) {
                Layer.this.currentInference = i;
                for (Observer o : Layer.this.observers) {
                    o.onNext((Object)i);
                }
            }
        };
    }

    NamedTuple makeClassifiers(MultiEncoder encoder) {
        String[] names = new String[encoder.getEncoders(encoder).size()];
        CLAClassifier[] ca = new CLAClassifier[names.length];
        int i = 0;
        for (EncoderTuple et : encoder.getEncoders(encoder)) {
            names[i] = et.getName();
            ca[i] = new CLAClassifier();
            ++i;
        }
        return new NamedTuple(names, (Object[])ca);
    }

    private int[] spatialInput(int[] input) {
        if (input == null) {
            LOGGER.info("Layer ".concat(this.getName()).concat(" received null input"));
        } else if (input.length < 1) {
            LOGGER.info("Layer ".concat(this.getName()).concat(" received zero length bit vector"));
            return input;
        }
        this.spatialPooler.compute(this.connections, input, this.activeColumns, this.sensor == null || this.sensor.getMetaInfo().isLearn(), true);
        return this.activeColumns;
    }

    private int[] temporalInput(int[] input) {
        ComputeCycle cc = null;
        if (this.sensor != null) {
            if (this.sensor.getMetaInfo().isReset()) {
                this.temporalMemory.reset(this.connections);
            }
            cc = this.temporalMemory.compute(this.connections, input, this.sensor.getMetaInfo().isLearn());
        } else {
            cc = this.temporalMemory.compute(this.connections, input, true);
        }
        this.previousPrediction = this.currentPrediction;
        this.currentPrediction = this.getSDR(cc.predictiveCells());
        return this.currentPrediction;
    }

    private int[] getSDR(Set<Cell> cells) {
        int[] retVal = new int[cells.size()];
        int i = 0;
        Iterator<Cell> it = cells.iterator();
        while (i < retVal.length) {
            retVal[i] = it.next().getIndex();
            int n = i++;
            retVal[n] = retVal[n] / this.cellsPerColumn;
        }
        Arrays.sort(retVal);
        retVal = ArrayUtils.unique(retVal);
        return retVal;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parentRegion == null ? 0 : this.parentRegion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Layer other = (Layer)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.parentRegion == null ? other.parentRegion != null : !this.parentRegion.equals(other.parentRegion));
    }

    class FunctionFactory {
        ManualInput inference = new ManualInput();

        FunctionFactory() {
        }

        public Observable<ManualInput> createEncoderFunc(Observable<T> in) {
            return in.ofType(String[].class).compose((Observable.Transformer)new String2Inference());
        }

        public Observable<ManualInput> createMultiMapFunc(Observable<T> in) {
            return in.ofType(Map.class).compose((Observable.Transformer)new Map2Inference());
        }

        public Observable<ManualInput> createVectorFunc(Observable<T> in) {
            return in.ofType(int[].class).compose((Observable.Transformer)new Vector2Inference());
        }

        public Observable<ManualInput> createManualInputFunc(Observable<T> in) {
            return in.ofType(ManualInput.class).compose((Observable.Transformer)new Copy2Inference());
        }

        public Func1<ManualInput, ManualInput> createSpatialFunc(SpatialPooler sp) {
            return new Func1<ManualInput, ManualInput>(){
                int inputWidth = -1;

                public ManualInput call(ManualInput t1) {
                    if (t1.getSDR().length > 0 && ArrayUtils.isSparse(t1.getSDR())) {
                        if (this.inputWidth == -1) {
                            this.inputWidth = Layer.this.connections.getInputMatrix().getMaxIndex() + 1;
                        }
                        t1.sdr(ArrayUtils.asDense(t1.getSDR(), this.inputWidth));
                    }
                    return t1.sdr(Layer.this.spatialInput(t1.getSDR())).activeColumns(t1.getSDR());
                }
            };
        }

        public Func1<ManualInput, ManualInput> createTemporalFunc(TemporalMemory tm) {
            return new Func1<ManualInput, ManualInput>(){

                public ManualInput call(ManualInput t1) {
                    if (!ArrayUtils.isSparse(t1.getSDR())) {
                        t1 = t1.sdr(Layer.this.sparseActives(ArrayUtils.where(t1.getSDR(), ArrayUtils.WHERE_1))).sparseActives(t1.getSDR());
                    }
                    return t1.sdr(Layer.this.temporalInput(t1.getSDR())).predictedColumns(t1.getSDR());
                }
            };
        }

        public Func1<ManualInput, ManualInput> createClassifierFunc() {
            return new Func1<ManualInput, ManualInput>(){
                private Object bucketIdx;
                private Object actValue;
                Map<String, Object> inputMap = new HashMap<String, Object>(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object get(Object o) {
                        return o.equals("bucketIdx") ? bucketIdx : actValue;
                    }
                };

                public ManualInput call(ManualInput t1) {
                    Map<String, NamedTuple> ci = t1.getClassifierInput();
                    int recordNum = Layer.this.getRecordNum();
                    for (String key : ci.keySet()) {
                        NamedTuple inputs = ci.get(key);
                        this.bucketIdx = inputs.get("bucketIdx");
                        this.actValue = inputs.get("inputValue");
                        CLAClassifier c = (CLAClassifier)t1.getClassifiers().get(key);
                        ClassifierResult<Object> result = c.compute(recordNum, this.inputMap, t1.getSDR(), true, true);
                        t1.recordNum(recordNum).storeClassification((String)inputs.get("name"), result);
                    }
                    return t1;
                }
            };
        }

        public Func1<ManualInput, ManualInput> createAnomalyFunc(Anomaly an) {
            return new Func1<ManualInput, ManualInput>(){

                public ManualInput call(ManualInput t1) {
                    if (t1.getSparseActives() == null || t1.getPreviousPrediction() == null) {
                        return t1.anomalyScore(0.0);
                    }
                    return t1.anomalyScore(Layer.this.anomalyComputer.compute(t1.getSparseActives(), t1.getPreviousPrediction(), 0.0, 0L));
                }
            };
        }

        class Copy2Inference
        implements Observable.Transformer<ManualInput, ManualInput> {
            Copy2Inference() {
            }

            public Observable<ManualInput> call(Observable<ManualInput> t1) {
                return t1.map((Func1)new Func1<ManualInput, ManualInput>(){
                    NamedTuple swap;
                    boolean swapped;

                    public ManualInput call(ManualInput t1) {
                        if (!this.swapped) {
                            this.swap = FunctionFactory.this.inference.getClassifiers();
                            FunctionFactory.this.inference = t1;
                            FunctionFactory.this.inference.classifiers(this.swap);
                            this.swapped = true;
                        }
                        return FunctionFactory.this.inference.sdr(t1.getSDR()).recordNum(t1.getRecordNum()).layerInput(t1);
                    }
                });
            }
        }

        class Vector2Inference
        implements Observable.Transformer<int[], ManualInput> {
            Vector2Inference() {
            }

            public Observable<ManualInput> call(Observable<int[]> t1) {
                return t1.map((Func1)new Func1<int[], ManualInput>(){

                    public ManualInput call(int[] t1) {
                        return FunctionFactory.this.inference.sdr(t1).layerInput(t1);
                    }
                });
            }
        }

        class Map2Inference
        implements Observable.Transformer<Map, ManualInput> {
            Map2Inference() {
            }

            public Observable<ManualInput> call(Observable<Map> t1) {
                return t1.map((Func1)new Func1<Map, ManualInput>(){

                    public ManualInput call(Map t1) {
                        if (Layer.this.encoderTuples == null) {
                            Layer.this.encoderTuples = Layer.this.encoder.getEncoders(Layer.this.encoder);
                        }
                        int[] encoding = Layer.this.encoder.encode(t1);
                        FunctionFactory.this.inference.sdr(encoding).encoding(encoding);
                        Layer.this.doEncoderBucketMapping(FunctionFactory.this.inference, t1);
                        return FunctionFactory.this.inference.layerInput(t1);
                    }
                });
            }
        }

        class String2Inference
        implements Observable.Transformer<String[], ManualInput> {
            String2Inference() {
            }

            public Observable<ManualInput> call(Observable<String[]> t1) {
                return t1.map((Func1)new Func1<String[], ManualInput>(){

                    public ManualInput call(String[] t1) {
                        int[] sdr = new int[t1.length];
                        for (int i = 0; i < sdr.length; ++i) {
                            sdr[i] = Integer.parseInt(t1[i]);
                        }
                        return FunctionFactory.this.inference.sdr(sdr).layerInput(sdr);
                    }
                });
            }
        }
    }
}

