/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.network;

import java.util.HashMap;
import java.util.Map;
import org.numenta.nupic.algorithms.ClassifierResult;
import org.numenta.nupic.network.Inference;
import org.numenta.nupic.util.ArrayUtils;
import org.numenta.nupic.util.NamedTuple;

public class ManualInput
implements Inference {
    private int recordNum;
    private Map<String, NamedTuple> classifierInput;
    NamedTuple classifiers;
    private Object layerInput;
    private int[] sdr;
    private int[] encoding;
    private int[] activeColumns;
    private int[] sparseActives;
    private int[] previousPrediction;
    private int[] currentPrediction;
    private Map<String, ClassifierResult<Object>> classification;
    private double anomalyScore;
    private Object customObject;

    public ManualInput recordNum(int num) {
        this.recordNum = num;
        return this;
    }

    @Override
    public int getRecordNum() {
        return this.recordNum;
    }

    @Override
    public Object getCustomObject() {
        return this.customObject;
    }

    public ManualInput customObject(Object o) {
        this.customObject = o;
        return this;
    }

    @Override
    public Map<String, NamedTuple> getClassifierInput() {
        if (this.classifierInput == null) {
            this.classifierInput = new HashMap<String, NamedTuple>();
        }
        return this.classifierInput;
    }

    ManualInput classifierInput(Map<String, NamedTuple> classifierInput) {
        this.classifierInput = classifierInput;
        return this;
    }

    public ManualInput classifiers(NamedTuple tuple) {
        this.classifiers = tuple;
        return this;
    }

    @Override
    public NamedTuple getClassifiers() {
        return this.classifiers;
    }

    @Override
    public Object getLayerInput() {
        return this.layerInput;
    }

    ManualInput layerInput(Object inputValue) {
        this.layerInput = inputValue;
        return this;
    }

    @Override
    public int[] getSDR() {
        return this.sdr;
    }

    ManualInput sdr(int[] sdr) {
        this.sdr = sdr;
        return this;
    }

    @Override
    public int[] getEncoding() {
        return this.encoding;
    }

    ManualInput encoding(int[] sdr) {
        this.encoding = sdr;
        return this;
    }

    ManualInput copy() {
        ManualInput retVal = new ManualInput();
        retVal.classifierInput = new HashMap<String, NamedTuple>(this.classifierInput);
        retVal.classifiers = this.classifiers;
        retVal.layerInput = this.layerInput;
        retVal.sdr = this.sdr;
        retVal.classification = this.classification;
        retVal.anomalyScore = this.anomalyScore;
        return retVal;
    }

    @Override
    public ClassifierResult<Object> getClassification(String fieldName) {
        return this.classification.get(fieldName);
    }

    ManualInput storeClassification(String fieldName, ClassifierResult<Object> classification) {
        if (this.classification == null) {
            this.classification = new HashMap<String, ClassifierResult<Object>>();
        }
        this.classification.put(fieldName, classification);
        return this;
    }

    @Override
    public double getAnomalyScore() {
        return this.anomalyScore;
    }

    ManualInput anomalyScore(double d) {
        this.anomalyScore = d;
        return this;
    }

    @Override
    public int[] getActiveColumns() {
        return this.activeColumns;
    }

    public ManualInput activeColumns(int[] cols) {
        this.activeColumns = cols;
        return this;
    }

    @Override
    public int[] getSparseActives() {
        if (this.sparseActives == null && this.activeColumns != null) {
            this.sparseActives = ArrayUtils.where(this.activeColumns, ArrayUtils.WHERE_1);
        }
        return this.sparseActives;
    }

    public ManualInput sparseActives(int[] cols) {
        this.sparseActives = cols;
        return this;
    }

    @Override
    public int[] getPreviousPrediction() {
        return this.previousPrediction;
    }

    public ManualInput previousPrediction(int[] cols) {
        this.previousPrediction = cols;
        return this;
    }

    @Override
    public int[] getPredictedColumns() {
        return this.currentPrediction;
    }

    public ManualInput predictedColumns(int[] cols) {
        this.previousPrediction = this.currentPrediction;
        this.currentPrediction = cols;
        return this;
    }
}

