/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.network;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.numenta.nupic.network.Inference;
import org.numenta.nupic.network.Layer;
import org.numenta.nupic.network.ManualInput;
import org.numenta.nupic.network.Network;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;

public class Region {
    private static final Logger LOGGER = LoggerFactory.getLogger(Region.class);
    private Network network;
    private Region upstreamRegion;
    private Region downstreamRegion;
    private Map<String, Layer<Inference>> layers = new HashMap<String, Layer<Inference>>();
    private Observable<Inference> regionObservable;
    private Layer<?> tail;
    private Layer<?> head;
    private boolean assemblyClosed;
    private HashSet<Layer<Inference>> sources;
    private HashSet<Layer<Inference>> sinks;
    byte flagAccumulator = 0;
    boolean layersDistinct = true;
    private Object input;
    private String name;

    public Region(String name, Network network) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name may not be null or empty");
        }
        this.name = name;
        this.network = network;
    }

    public void setNetwork(Network network) {
        this.network = network;
        for (Layer<Inference> l : this.layers.values()) {
            l.setNetwork(network);
            if (l.hasSensor() && network != null) {
                network.setSensor(l.getSensor());
                network.setEncoder(l.getSensor().getEncoder());
                continue;
            }
            if (network == null || l.getEncoder() == null) continue;
            network.setEncoder(l.getEncoder());
        }
    }

    public Region close() {
        if (this.layers.size() < 1) {
            LOGGER.warn("Closing region: " + this.name + " before adding contents.");
            return this;
        }
        this.completeAssembly();
        Layer<Object> l = this.tail;
        do {
            l.close();
        } while ((l = l.getNext()) != null);
        return this;
    }

    public boolean isClosed() {
        return this.assemblyClosed;
    }

    public <T> void compute(T input) {
        if (!this.assemblyClosed) {
            this.close();
        }
        this.input = input;
        this.tail.compute(input);
    }

    public Object getInput() {
        return this.input;
    }

    public Region add(Layer<?> l) {
        String layerName;
        if (this.assemblyClosed) {
            throw new IllegalStateException("Cannot add Layers when Region has already been closed.");
        }
        if (this.sources == null) {
            this.sources = new HashSet();
            this.sinks = new HashSet();
        }
        if (l.hasSensor() && this.network != null) {
            this.network.setSensor(l.getSensor());
            this.network.setEncoder(l.getSensor().getEncoder());
        }
        if (this.layers.containsKey(layerName = this.name.concat(":").concat(l.getName()))) {
            throw new IllegalArgumentException("A Layer with the name: " + l.getName() + " has already been added to this Region.");
        }
        l.name(layerName);
        this.layers.put(l.getName(), l);
        l.setRegion(this);
        l.setNetwork(this.network);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Observable<Inference> observe() {
        if (this.regionObservable == null && !this.assemblyClosed) {
            this.close();
        }
        return this.regionObservable;
    }

    public void start() {
        if (!this.assemblyClosed) {
            this.close();
        }
        if (this.tail.hasSensor()) {
            LOGGER.info("Starting Region [" + this.getName() + "] input Layer thread.");
            this.tail.start();
        } else {
            LOGGER.warn("Start called on Region [" + this.getName() + "] with no effect due to no Sensor present.");
        }
    }

    public void halt() {
        LOGGER.debug("Stop called on Region [" + this.getName() + "]");
        if (this.tail != null) {
            this.tail.halt();
        }
        LOGGER.debug("Region [" + this.getName() + "] stopped.");
    }

    public void reset() {
        for (Layer<Inference> l : this.layers.values()) {
            if (!l.hasTemporalMemory()) continue;
            l.reset();
        }
    }

    public void resetRecordNum() {
        for (Layer<Inference> l : this.layers.values()) {
            l.resetRecordNum();
        }
    }

    Region connect(Region inputRegion) {
        inputRegion.observe().subscribe((Observer)new Observer<Inference>(){
            ManualInput localInf = new ManualInput();

            public void onCompleted() {
                Region.this.tail.notifyComplete();
            }

            public void onError(Throwable e) {
                e.printStackTrace();
            }

            public void onNext(Inference i) {
                this.localInf.sdr(i.getSDR()).recordNum(i.getRecordNum()).classifierInput(i.getClassifierInput()).layerInput(i.getSDR());
                if (i.getSDR().length > 0) {
                    Region.this.tail.compute(this.localInf);
                }
            }
        });
        this.upstreamRegion = inputRegion;
        inputRegion.downstreamRegion = this;
        return this;
    }

    public Region getUpstreamRegion() {
        return this.upstreamRegion;
    }

    public Region getDownstreamRegion() {
        return this.downstreamRegion;
    }

    public Layer<?> getHead() {
        return this.head;
    }

    public Layer<?> getTail() {
        return this.tail;
    }

    public Region connect(String toLayerName, String fromLayerName) {
        if (this.assemblyClosed) {
            throw new IllegalStateException("Cannot connect Layers when Region has already been closed.");
        }
        Layer<Inference> in = this.lookup(toLayerName);
        Layer<Inference> out = this.lookup(fromLayerName);
        if (in == null) {
            throw new IllegalArgumentException("Could not lookup (to) Layer with name: " + toLayerName);
        }
        if (out == null) {
            throw new IllegalArgumentException("Could not lookup (from) Layer with name: " + fromLayerName);
        }
        out.next(in);
        in.previous(out);
        this.connect(in, out);
        return this;
    }

    public Layer<?> lookup(String layerName) {
        if (layerName.indexOf(":") != -1) {
            return this.layers.get(layerName);
        }
        return this.layers.get(this.name.concat(":").concat(layerName));
    }

    private void completeAssembly() {
        if (!this.assemblyClosed) {
            HashSet<Layer<Inference>> temp;
            if (this.layers.size() == 0) {
                return;
            }
            if (this.layers.size() == 1) {
                this.tail = this.layers.values().iterator().next();
                this.head = this.tail;
            }
            if (this.tail == null) {
                temp = new HashSet<Layer<Inference>>(this.sources);
                temp.removeAll(this.sinks);
                if (temp.size() != 1) {
                    throw new IllegalArgumentException("Detected misconfigured Region too many or too few sinks.");
                }
                this.tail = (Layer)temp.iterator().next();
            }
            if (this.head == null) {
                temp = new HashSet<Layer<Inference>>(this.sinks);
                temp.removeAll(this.sources);
                if (temp.size() != 1) {
                    throw new IllegalArgumentException("Detected misconfigured Region too many or too few sources.");
                }
                this.head = (Layer)temp.iterator().next();
            }
            this.regionObservable = this.head.observe();
            this.assemblyClosed = true;
        }
    }

    <I extends Layer<Inference>, O extends Layer<Inference>> void connect(final I in, O out) {
        if (this.assemblyClosed) {
            throw new IllegalStateException("Cannot add Layers when Region has already been closed.");
        }
        HashSet<Layer<Inference>> all = new HashSet<Layer<Inference>>(this.sources);
        all.addAll(this.sinks);
        byte inMask = in.getMask();
        byte outMask = out.getMask();
        if (!all.contains(out)) {
            this.layersDistinct = (this.flagAccumulator & outMask) < 1;
            this.flagAccumulator = (byte)(this.flagAccumulator | outMask);
        }
        if (!all.contains(in)) {
            this.layersDistinct = (this.flagAccumulator & inMask) < 1;
            this.flagAccumulator = (byte)(this.flagAccumulator | inMask);
        }
        this.sources.add(out);
        this.sinks.add(in);
        out.subscribe((Observer<Inference>)new Subscriber<Inference>(){
            ManualInput localInf = new ManualInput();

            public void onCompleted() {
                in.notifyComplete();
            }

            public void onError(Throwable e) {
                e.printStackTrace();
            }

            public void onNext(Inference i) {
                if (Region.this.layersDistinct) {
                    in.compute(i);
                } else {
                    this.localInf.sdr(i.getSDR()).recordNum(i.getRecordNum()).layerInput(i.getSDR());
                    in.compute(this.localInf);
                }
            }
        });
    }
}

