/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.network.sensor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.numenta.nupic.ValueList;
import org.numenta.nupic.network.sensor.MetaStream;
import org.numenta.nupic.util.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedCsvStream<T>
implements MetaStream<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchedCsvStream.class);
    private Iterator<String[]> it;
    private int fence;
    private boolean isBatchOp;
    private boolean isTerminal;
    private BatchedCsvHeader header;
    private Stream<T> delegate;
    private int headerStateTracker = 0;

    public BatchedCsvStream(Stream<String> s, int headerLength) {
        this.it = s.map(line -> {
            ++this.headerStateTracker;
            return line.split("[\\s]*,[\\s]*", -1);
        }).iterator();
        this.fence = headerLength;
        this.makeHeader();
        LOGGER.debug("Created BatchedCsvStream");
    }

    private void makeHeader() {
        ArrayList<String[]> contents = new ArrayList<String[]>();
        int i = 0;
        while (i++ < this.fence) {
            String[] h = this.it.next();
            contents.add(h);
        }
        this.header = new BatchedCsvHeader(contents, this.fence);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Created Header:");
            for (Object[] objectArray : contents) {
                LOGGER.debug("\t" + Arrays.toString(objectArray));
            }
            LOGGER.debug("Successfully created BatchedCsvHeader.");
        }
    }

    @Override
    public boolean isTerminal() {
        return this.isTerminal;
    }

    public boolean isBatchOp() {
        return this.isBatchOp;
    }

    public void setBatchOp(boolean b) {
        this.isBatchOp = b;
    }

    public BatchedCsvHeader getHeader() {
        return this.header;
    }

    private Stream<String[]> continuation(boolean parallel) {
        if (this.it == null) {
            throw new IllegalStateException("You must first create a BatchCsvStream by calling batch(Stream, int, boolean, int)");
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(parallel ? this.it : this.getSequenceIterator(this.it), 1296), parallel);
    }

    private Iterator<String[]> getSequenceIterator(final Iterator<String[]> toWrap) {
        return new Iterator<String[]>(){
            private Iterator<String[]> delegate;
            private int seq;
            {
                this.delegate = toWrap;
                this.seq = 0;
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public String[] next() {
                BatchedCsvStream.this.isTerminal = true;
                String[] value = this.delegate.next();
                String[] retVal = new String[value.length + 1];
                System.arraycopy(value, 0, retVal, 1, value.length);
                retVal[0] = String.valueOf(this.seq++);
                return retVal;
            }
        };
    }

    public Stream<String[]> stream() {
        return this.delegate;
    }

    private static <T> BatchSpliterator batchedSpliterator(BatchedCsvStream<String[]> csv, int batchSize, boolean isParallel, int characteristics) {
        Spliterator toWrap = super.continuation(isParallel).spliterator();
        return new BatchSpliterator(characteristics, batchSize, toWrap.estimateSize()).setCSV(csv).setToWrap(toWrap);
    }

    private static <T> BatchSpliterator batchedSpliterator(BatchedCsvStream<String[]> csv, int batchSize, boolean isParallel) {
        Spliterator toWrap = super.continuation(isParallel).spliterator();
        return new BatchSpliterator(toWrap.characteristics(), batchSize, toWrap.estimateSize()).setCSV(csv).setToWrap(toWrap);
    }

    public static BatchedCsvStream<String[]> batch(Stream<String> stream, int batchSize, boolean isParallel, int headerLength) {
        BatchedCsvStream<String[]> csv = new BatchedCsvStream<String[]>(stream, headerLength);
        Stream<String[]> s = !isParallel ? super.continuation(isParallel) : StreamSupport.stream(BatchedCsvStream.batchedSpliterator(csv, batchSize, isParallel), isParallel);
        csv.delegate = s;
        return csv;
    }

    public static BatchedCsvStream<String[]> batch(Stream<String> stream, int batchSize, boolean isParallel, int headerLength, int characteristics) {
        BatchedCsvStream<String[]> csv = new BatchedCsvStream<String[]>(stream, headerLength);
        Stream<String[]> s = !isParallel ? super.continuation(isParallel) : StreamSupport.stream(BatchedCsvStream.batchedSpliterator(csv, batchSize, isParallel, characteristics), isParallel);
        csv.delegate = s;
        return csv;
    }

    @Override
    public ValueList getMeta() {
        return this.getHeader();
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.delegate.spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.delegate.isParallel();
    }

    @Override
    public Stream<T> sequential() {
        return (Stream)this.delegate.sequential();
    }

    @Override
    public Stream<T> parallel() {
        return (Stream)this.delegate.parallel();
    }

    @Override
    public Stream<T> unordered() {
        return (Stream)this.delegate.unordered();
    }

    @Override
    public Stream<T> onClose(Runnable closeHandler) {
        return (Stream)this.delegate.onClose(closeHandler);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Stream<T> filter(Predicate<? super T> predicate) {
        return this.delegate.filter(predicate);
    }

    @Override
    public <R> Stream<R> map(Function<? super T, ? extends R> mapper) {
        return this.delegate.map(mapper);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        return this.delegate.mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        return this.delegate.mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return this.delegate.mapToDouble(mapper);
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return this.delegate.flatMap(mapper);
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return this.delegate.flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return this.delegate.flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return this.delegate.flatMapToDouble(mapper);
    }

    @Override
    public Stream<T> distinct() {
        return this.delegate.distinct();
    }

    @Override
    public Stream<T> sorted() {
        return this.delegate.sorted();
    }

    @Override
    public Stream<T> sorted(Comparator<? super T> comparator) {
        return this.delegate.sorted(comparator);
    }

    @Override
    public Stream<T> peek(Consumer<? super T> action) {
        return this.delegate.peek(action);
    }

    @Override
    public Stream<T> limit(long maxSize) {
        return this.delegate.limit(maxSize);
    }

    @Override
    public Stream<T> skip(long n) {
        return this.delegate.skip(n);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.delegate.forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        this.delegate.forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.delegate.toArray(generator);
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.delegate.reduce(identity, accumulator);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.delegate.reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.delegate.reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.delegate.collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.delegate.collect(collector);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.delegate.min(comparator);
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.delegate.max(comparator);
    }

    @Override
    public long count() {
        return this.delegate.count();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.delegate.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.delegate.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.delegate.noneMatch(predicate);
    }

    @Override
    public Optional<T> findFirst() {
        return this.delegate.findFirst();
    }

    @Override
    public Optional<T> findAny() {
        return this.delegate.findAny();
    }

    public static void main(String[] args) {
        Stream<String> stream = Stream.of("timestamp,consumption", "datetime,float", "T,", "7/2/10 0:00,21.2", "7/2/10 1:00,16.4", "7/2/10 2:00,4.7", "7/2/10 3:00,4.7", "7/2/10 4:00,4.6", "7/2/10 5:00,23.5", "7/2/10 6:00,47.5", "7/2/10 7:00,45.4", "7/2/10 8:00,46.1", "7/2/10 9:00,41.5", "7/2/10 10:00,43.4", "7/2/10 11:00,43.8", "7/2/10 12:00,37.8", "7/2/10 13:00,36.6", "7/2/10 14:00,35.7", "7/2/10 15:00,38.9", "7/2/10 16:00,36.2", "7/2/10 17:00,36.6", "7/2/10 18:00,37.2", "7/2/10 19:00,38.2", "7/2/10 20:00,14.1");
        BatchedCsvStream csv = new BatchedCsvStream(stream, 3);
        System.out.println("Header: " + csv.getHeader());
        super.continuation(false).forEach(l -> System.out.println("line: " + Arrays.toString(l)));
    }

    public static class BatchedCsvHeader
    implements ValueList {
        private Tuple[] headerValues;

        public <T> BatchedCsvHeader(List<T> lines, int configuredHeaderLength) {
            if (configuredHeaderLength < 1 || lines == null || lines.size() < 1 || configuredHeaderLength > 1 && lines.size() != configuredHeaderLength) {
                throw new IllegalStateException("Actual Header was not the expected size: " + (configuredHeaderLength < 1 ? "> 1" : Integer.valueOf(configuredHeaderLength)) + ", but was: " + (lines == null ? "null" : Integer.valueOf(lines.size())));
            }
            this.headerValues = new Tuple[configuredHeaderLength];
            for (int i = 0; i < this.headerValues.length; ++i) {
                this.headerValues[i] = new Tuple((Object[])lines.get(i));
            }
        }

        @Override
        public Tuple getRow(int index) {
            if (index >= this.headerValues.length) {
                return null;
            }
            return this.headerValues[index];
        }

        @Override
        public int size() {
            return this.headerValues == null ? 0 : this.headerValues.length;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Stream.of(this.headerValues).forEach(l -> sb.append(l).append("\n"));
            return sb.toString();
        }
    }

    private static class BatchSpliterator
    implements Spliterator<String[]> {
        private final int batchSize;
        private final int characteristics;
        private int sequenceNum;
        private long est;
        private BatchedCsvStream<String[]> csv;
        private Spliterator<String[]> spliterator;

        public BatchSpliterator(int characteristics, int batchSize, long est) {
            this.characteristics = characteristics | 0x4000;
            this.batchSize = batchSize;
            this.est = est;
        }

        private BatchSpliterator setCSV(BatchedCsvStream<String[]> csv) {
            this.csv = csv;
            return this;
        }

        private BatchSpliterator setToWrap(Spliterator<String[]> toWrap) {
            this.spliterator = toWrap;
            return this;
        }

        @Override
        public boolean tryAdvance(Consumer<? super String[]> action) {
            boolean hasNext = this.spliterator.tryAdvance(action);
            if (hasNext) {
                ++this.sequenceNum;
            }
            return hasNext;
        }

        @Override
        public void forEachRemaining(Consumer<? super String[]> action) {
            this.spliterator.forEachRemaining(action);
        }

        @Override
        public Spliterator<String[]> trySplit() {
            SequencingConsumer holder = new SequencingConsumer();
            if (!this.tryAdvance(holder)) {
                return null;
            }
            this.csv.setBatchOp(true);
            Object[] lines = new Object[this.batchSize];
            int j = 0;
            do {
                lines[j] = holder.value;
            } while (++j < this.batchSize && this.tryAdvance(holder));
            if (this.est != Long.MAX_VALUE) {
                this.est -= (long)j;
            }
            return Spliterators.spliterator(lines, 0, j, this.characteristics | 0x40);
        }

        @Override
        public Comparator<? super String[]> getComparator() {
            if (this.hasCharacteristics(4) && ((BatchedCsvStream)this.csv).isBatchOp) {
                return (i, j) -> Long.valueOf(i[0]).compareTo(Long.valueOf(j[0]));
            }
            if (((BatchedCsvStream)this.csv).isBatchOp) {
                return null;
            }
            throw new IllegalStateException();
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        final class SequencingConsumer
        implements Consumer<String[]> {
            String[] value;

            SequencingConsumer() {
            }

            @Override
            public void accept(String[] value) {
                ((BatchedCsvStream)BatchSpliterator.this.csv).isTerminal = true;
                this.value = new String[value.length + 1];
                System.arraycopy(value, 0, this.value, 1, value.length);
                this.value[0] = String.valueOf(BatchSpliterator.this.sequenceNum);
            }
        }
    }
}

