/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.network.sensor;

import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.subjects.PublishSubject;
import rx.subjects.ReplaySubject;

public class Publisher {
    private static final int HEADER_SIZE = 3;
    private ReplaySubject<String> subject;

    public static Builder<PublishSubject<String>> builder() {
        return new Builder<PublishSubject<String>>();
    }

    public void onNext(String input) {
        this.subject.onNext((Object)input);
    }

    public void onComplete() {
        this.subject.onCompleted();
    }

    public void onError(Throwable e) {
        this.subject.onError(e);
    }

    public Subscription subscribe(Observer<String> observer) {
        return this.subject.subscribe(observer);
    }

    Observable<String> observable() {
        return this.subject;
    }

    public static class Builder<T> {
        private ReplaySubject<String> subject;
        String[] lines = new String[3];
        int cursor = 0;

        public Builder<PublishSubject<String>> addHeader(String s) {
            this.lines[this.cursor] = s;
            ++this.cursor;
            return this;
        }

        public Publisher build() {
            this.subject = ReplaySubject.createWithSize((int)3);
            for (int i = 0; i < 3; ++i) {
                if (this.lines[i] == null) {
                    throw new IllegalStateException("Header not properly formed (must contain 3 lines) see Header.java");
                }
                this.subject.onNext((Object)this.lines[i]);
            }
            Publisher p = new Publisher();
            p.subject = this.subject;
            return p;
        }
    }
}

