/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.network.sensor;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import org.numenta.nupic.ValueList;
import org.numenta.nupic.network.sensor.BatchedCsvStream;
import org.numenta.nupic.network.sensor.MetaStream;
import org.numenta.nupic.network.sensor.Sensor;
import org.numenta.nupic.network.sensor.SensorParams;

public class URISensor
implements Sensor<URI> {
    private static final int HEADER_SIZE = 3;
    private static final int BATCH_SIZE = 20;
    private static final boolean DEFAULT_PARALLEL_MODE = false;
    private BatchedCsvStream<String[]> stream;
    private SensorParams params;

    private URISensor(SensorParams params) {
        if (!params.hasKey("URI")) {
            throw new IllegalArgumentException("Passed improperly formed Tuple: no key for \"URI\"");
        }
        this.params = params;
        BufferedReader br = null;
        try {
            InputStream is = new URL((String)params.get("URI")).openStream();
            br = new BufferedReader(new InputStreamReader(is));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.stream = BatchedCsvStream.batch(br.lines(), 20, false, 3);
    }

    public static Sensor<URI> create(SensorParams p) {
        URISensor sensor = new URISensor(p);
        return sensor;
    }

    @Override
    public SensorParams getParams() {
        return this.params;
    }

    @Override
    public <K> MetaStream<K> getInputStream() {
        return this.stream;
    }

    @Override
    public ValueList getMetaInfo() {
        return this.stream.getMeta();
    }
}

