/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.research;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.numenta.nupic.Connections;
import org.numenta.nupic.model.Cell;
import org.numenta.nupic.model.Column;
import org.numenta.nupic.model.DistalDendrite;
import org.numenta.nupic.model.Synapse;

public class ComputeCycle {
    Set<Cell> activeCells = new LinkedHashSet<Cell>();
    Set<Cell> winnerCells = new LinkedHashSet<Cell>();
    Set<Cell> predictiveCells = new LinkedHashSet<Cell>();
    Set<Column> successfullyPredictedColumns = new LinkedHashSet<Column>();
    Set<DistalDendrite> activeSegments = new LinkedHashSet<DistalDendrite>();
    Set<DistalDendrite> learningSegments = new LinkedHashSet<DistalDendrite>();
    Map<DistalDendrite, Set<Synapse>> activeSynapsesForSegment = new LinkedHashMap<DistalDendrite, Set<Synapse>>();

    public ComputeCycle() {
    }

    public ComputeCycle(Connections c) {
        this.activeCells = new LinkedHashSet<Cell>(c.getActiveCells());
        this.winnerCells = new LinkedHashSet<Cell>(c.getWinnerCells());
        this.predictiveCells = new LinkedHashSet<Cell>(c.getPredictiveCells());
        this.successfullyPredictedColumns = new LinkedHashSet<Column>(c.getSuccessfullyPredictedColumns());
        this.activeSegments = new LinkedHashSet<DistalDendrite>(c.getActiveSegments());
        this.learningSegments = new LinkedHashSet<DistalDendrite>(c.getLearningSegments());
        this.activeSynapsesForSegment = new LinkedHashMap<DistalDendrite, Set<Synapse>>(c.getActiveSynapsesForSegment());
    }

    public Set<Cell> activeCells() {
        return this.activeCells;
    }

    public Set<Cell> winnerCells() {
        return this.winnerCells;
    }

    public Set<Cell> predictiveCells() {
        return this.predictiveCells;
    }

    public Set<Column> successfullyPredictedColumns() {
        return this.successfullyPredictedColumns;
    }

    public Set<DistalDendrite> learningSegments() {
        return this.learningSegments;
    }

    public Set<DistalDendrite> activeSegments() {
        return this.activeSegments;
    }

    public Map<DistalDendrite, Set<Synapse>> activeSynapsesForSegment() {
        return this.activeSynapsesForSegment;
    }
}

