/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.research;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.numenta.nupic.Connections;
import org.numenta.nupic.model.Cell;
import org.numenta.nupic.model.Column;
import org.numenta.nupic.model.DistalDendrite;
import org.numenta.nupic.model.Synapse;
import org.numenta.nupic.research.ComputeCycle;
import org.numenta.nupic.util.SparseObjectMatrix;

public class TemporalMemory {
    public void init(Connections c) {
        SparseObjectMatrix<Column> matrix = c.getMemory() == null ? new SparseObjectMatrix<Column>(c.getColumnDimensions()) : c.getMemory();
        c.setMemory(matrix);
        int numColumns = matrix.getMaxIndex() + 1;
        int cellsPerColumn = c.getCellsPerColumn();
        Cell[] cells = new Cell[numColumns * cellsPerColumn];
        Column colZero = matrix.getObject(0);
        for (int i = 0; i < numColumns; ++i) {
            Column column = colZero == null ? new Column(cellsPerColumn, i) : matrix.getObject(i);
            for (int j = 0; j < cellsPerColumn; ++j) {
                cells[i * cellsPerColumn + j] = column.getCell(j);
            }
            if (colZero != null) continue;
            matrix.set(i, column);
        }
        c.setCells(cells);
    }

    public ComputeCycle compute(Connections connections, int[] activeColumns, boolean learn) {
        ComputeCycle result = this.computeFn(connections, connections.getColumnSet(activeColumns), new LinkedHashSet<Cell>(connections.getPredictiveCells()), new LinkedHashSet<DistalDendrite>(connections.getActiveSegments()), new LinkedHashMap<DistalDendrite, Set<Synapse>>(connections.getActiveSynapsesForSegment()), new LinkedHashSet<Cell>(connections.getWinnerCells()), learn);
        connections.setActiveCells(result.activeCells());
        connections.setWinnerCells(result.winnerCells());
        connections.setPredictiveCells(result.predictiveCells());
        connections.setSuccessfullyPredictedColumns(result.successfullyPredictedColumns());
        connections.setActiveSegments(result.activeSegments());
        connections.setLearningSegments(result.learningSegments());
        connections.setActiveSynapsesForSegment(result.activeSynapsesForSegment());
        return result;
    }

    public ComputeCycle computeFn(Connections c, Set<Column> activeColumns, Set<Cell> prevPredictiveCells, Set<DistalDendrite> prevActiveSegments, Map<DistalDendrite, Set<Synapse>> prevActiveSynapsesForSegment, Set<Cell> prevWinnerCells, boolean learn) {
        ComputeCycle cycle = new ComputeCycle();
        this.activateCorrectlyPredictiveCells(cycle, prevPredictiveCells, activeColumns);
        this.burstColumns(cycle, c, activeColumns, cycle.successfullyPredictedColumns, prevActiveSynapsesForSegment);
        if (learn) {
            this.learnOnSegments(c, prevActiveSegments, cycle.learningSegments, prevActiveSynapsesForSegment, cycle.winnerCells, prevWinnerCells);
        }
        cycle.activeSynapsesForSegment = this.computeActiveSynapses(c, cycle.activeCells);
        this.computePredictiveCells(c, cycle, cycle.activeSynapsesForSegment);
        return cycle;
    }

    public void activateCorrectlyPredictiveCells(ComputeCycle c, Set<Cell> prevPredictiveCells, Set<Column> activeColumns) {
        for (Cell cell : prevPredictiveCells) {
            Column column = cell.getParentColumn();
            if (!activeColumns.contains(column)) continue;
            c.activeCells.add(cell);
            c.winnerCells.add(cell);
            c.successfullyPredictedColumns.add(column);
        }
    }

    public void burstColumns(ComputeCycle cycle, Connections c, Set<Column> activeColumns, Set<Column> predictedColumns, Map<DistalDendrite, Set<Synapse>> prevActiveSynapsesForSegment) {
        activeColumns.removeAll(predictedColumns);
        for (Column column : activeColumns) {
            List<Cell> cells = column.getCells();
            cycle.activeCells.addAll(cells);
            Object[] bestSegmentAndCell = this.getBestMatchingCell(c, column, prevActiveSynapsesForSegment);
            DistalDendrite bestSegment = (DistalDendrite)bestSegmentAndCell[0];
            Cell bestCell = (Cell)bestSegmentAndCell[1];
            if (bestCell != null) {
                cycle.winnerCells.add(bestCell);
            }
            int segmentCounter = c.getSegmentCount();
            if (bestSegment == null) {
                bestSegment = bestCell.createSegment(c, segmentCounter);
                c.setSegmentCount(segmentCounter + 1);
            }
            cycle.learningSegments.add(bestSegment);
        }
    }

    public void learnOnSegments(Connections c, Set<DistalDendrite> prevActiveSegments, Set<DistalDendrite> learningSegments, Map<DistalDendrite, Set<Synapse>> prevActiveSynapseSegments, Set<Cell> winnerCells, Set<Cell> prevWinnerCells) {
        double permanenceIncrement = c.getPermanenceIncrement();
        double permanenceDecrement = c.getPermanenceDecrement();
        ArrayList<DistalDendrite> prevAndLearning = new ArrayList<DistalDendrite>(prevActiveSegments);
        prevAndLearning.addAll(learningSegments);
        for (DistalDendrite dd : prevAndLearning) {
            boolean isLearningSegment = learningSegments.contains(dd);
            boolean isFromWinnerCell = winnerCells.contains(dd.getParentCell());
            Set<Synapse> activeSynapses = dd.getConnectedActiveSynapses(prevActiveSynapseSegments, 0.0);
            if (isLearningSegment || isFromWinnerCell) {
                dd.adaptSegment(c, activeSynapses, permanenceIncrement, permanenceDecrement);
            }
            int synapseCounter = c.getSynapseCount();
            int n = c.getMaxNewSynapseCount() - activeSynapses.size();
            if (!isLearningSegment || n <= 0) continue;
            Set<Cell> learnCells = dd.pickCellsToLearnOn(c, n, prevWinnerCells, c.getRandom());
            for (Cell sourceCell : learnCells) {
                dd.createSynapse(c, sourceCell, c.getInitialPermanence(), synapseCounter);
                ++synapseCounter;
            }
            c.setSynapseCount(synapseCounter);
        }
    }

    public void computePredictiveCells(Connections c, ComputeCycle cycle, Map<DistalDendrite, Set<Synapse>> activeDendrites) {
        for (DistalDendrite dd : activeDendrites.keySet()) {
            Set<Synapse> connectedActive = dd.getConnectedActiveSynapses(activeDendrites, c.getConnectedPermanence());
            if (connectedActive.size() < c.getActivationThreshold()) continue;
            cycle.activeSegments.add(dd);
            cycle.predictiveCells.add(dd.getParentCell());
        }
    }

    public Map<DistalDendrite, Set<Synapse>> computeActiveSynapses(Connections c, Set<Cell> cellsActive) {
        LinkedHashMap<DistalDendrite, Set<Synapse>> activesSynapses = new LinkedHashMap<DistalDendrite, Set<Synapse>>();
        for (Cell cell : cellsActive) {
            for (Synapse s : cell.getReceptorSynapses(c)) {
                LinkedHashSet<Synapse> set = null;
                set = (LinkedHashSet<Synapse>)activesSynapses.get(s.getSegment());
                if (set == null) {
                    set = new LinkedHashSet<Synapse>();
                    activesSynapses.put((DistalDendrite)s.getSegment(), set);
                }
                set.add(s);
            }
        }
        return activesSynapses;
    }

    public void reset(Connections connections) {
        connections.getActiveCells().clear();
        connections.getPredictiveCells().clear();
        connections.getActiveSegments().clear();
        connections.getActiveSynapsesForSegment().clear();
        connections.getWinnerCells().clear();
    }

    public Object[] getBestMatchingCell(Connections c, Column column, Map<DistalDendrite, Set<Synapse>> prevActiveSynapsesForSegment) {
        Object[] retVal = new Object[2];
        Cell bestCell = null;
        DistalDendrite bestSegment = null;
        int maxSynapses = 0;
        for (Cell cell : column.getCells()) {
            Set<Synapse> connectedActiveSynapses;
            DistalDendrite dd = this.getBestMatchingSegment(c, cell, prevActiveSynapsesForSegment);
            if (dd == null || (connectedActiveSynapses = dd.getConnectedActiveSynapses(prevActiveSynapsesForSegment, 0.0)).size() <= maxSynapses) continue;
            maxSynapses = connectedActiveSynapses.size();
            bestCell = cell;
            bestSegment = dd;
        }
        if (bestCell == null) {
            bestCell = column.getLeastUsedCell(c, c.getRandom());
        }
        retVal[0] = bestSegment;
        retVal[1] = bestCell;
        return retVal;
    }

    public DistalDendrite getBestMatchingSegment(Connections c, Cell cell, Map<DistalDendrite, Set<Synapse>> activeSynapseSegments) {
        int maxSynapses = c.getMinThreshold();
        DistalDendrite bestSegment = null;
        for (DistalDendrite dd : cell.getSegments(c)) {
            Set<Synapse> activeSyns = dd.getConnectedActiveSynapses(activeSynapseSegments, 0.0);
            if (activeSyns.size() < maxSynapses) continue;
            maxSynapses = activeSyns.size();
            bestSegment = dd;
        }
        return bestSegment;
    }

    protected int columnForCell(Connections c, int cellIndex) {
        return cellIndex / c.getCellsPerColumn();
    }

    public Cell getCell(Connections c, int index) {
        return c.getCells()[index];
    }

    public LinkedHashSet<Cell> getCells(Connections c, int[] cellIndexes) {
        LinkedHashSet<Cell> cellSet = new LinkedHashSet<Cell>();
        for (int cell : cellIndexes) {
            cellSet.add(this.getCell(c, cell));
        }
        return cellSet;
    }

    public LinkedHashSet<Column> getColumns(Connections c, int[] columnIndexes) {
        return c.getColumnSet(columnIndexes);
    }
}

