/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BeanUtil {
    private final Map<Class<?>, PropertyInfo[]> properties = new ConcurrentHashMap();
    private static final PropertyDescriptor[] EMPTY_PROPERTY_DESCRIPTOR = new PropertyDescriptor[0];
    private static BeanUtil INSTANCE = new BeanUtil();

    public static BeanUtil getInstance() {
        return INSTANCE;
    }

    private BeanUtil() {
    }

    public boolean setSimpleProperty(Object bean, String name, Object value) {
        PropertyInfo pi = this.getPropertyInfo(bean, name);
        if (pi != null) {
            this.setSimpleProperty(bean, pi, value);
            return true;
        }
        return false;
    }

    public void setSimplePropertyRequired(Object bean, String name, Object value) {
        this.setSimpleProperty(bean, this.getPropertyInfoRequired(bean, name), value);
    }

    public Object getSimpleProperty(Object bean, String name) {
        return this.getSimpleProperty(bean, this.getPropertyInfo(bean, name));
    }

    private Object getSimpleProperty(Object bean, PropertyInfo info) {
        if (info.getReadMethod() == null) {
            throw new IllegalArgumentException("Property '" + info.name + "' of bean " + bean.getClass().getName() + " does not have getter method");
        }
        return this.invokeMethod(info.getReadMethod(), bean, new Object[0]);
    }

    private void setSimpleProperty(Object bean, PropertyInfo info, Object value) {
        if (info.getWriteMethod() == null) {
            throw new IllegalArgumentException("Property '" + info.name + "' of bean " + bean.getClass().getName() + " does not have setter method");
        }
        this.invokeMethod(info.getWriteMethod(), bean, value);
    }

    private Object invokeMethod(Method m, Object instance, Object ... args) {
        if (instance == null) {
            throw new IllegalArgumentException("Can not invole Method '" + m + "' on null instance");
        }
        try {
            return m.invoke(instance, args);
        }
        catch (IllegalArgumentException e) {
            String msg = "Cannot invoke " + m.getDeclaringClass().getName() + "." + m.getName() + " - " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Cannot invoke " + m.getDeclaringClass().getName() + "." + m.getName() + " - " + e.getMessage();
            throw new RuntimeException(msg, e);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException() == null ? e : e.getTargetException();
            String msg = "Error invoking " + m.getDeclaringClass().getName() + "." + m.getName() + " - " + te.getMessage();
            throw new RuntimeException(msg, te);
        }
    }

    public PropertyInfo getPropertyInfo(Object bean, String name) {
        if (bean == null) {
            throw new IllegalArgumentException("Bean can not be null");
        }
        return this.getPropertyInfo(bean.getClass(), name);
    }

    public PropertyInfo getPropertyInfoRequired(Object bean, String name) {
        PropertyInfo result = this.getPropertyInfo(bean, name);
        if (result == null) {
            throw new IllegalArgumentException("Bean " + bean.getClass().getName() + " does not have property '" + name + "'");
        }
        return result;
    }

    public PropertyInfo getPropertyInfo(Class<?> beanClass, String name) {
        PropertyInfo[] infos;
        if (name == null) {
            throw new IllegalArgumentException("Property name is required and can not be null");
        }
        for (PropertyInfo info : infos = this.getPropertiesInfoForBean(beanClass)) {
            if (!name.equals(info.getName())) continue;
            return info;
        }
        return null;
    }

    public PropertyInfo[] getPropertiesInfoForBean(Class<?> beanClass) {
        PropertyDescriptor[] descriptors;
        if (beanClass == null) {
            throw new IllegalArgumentException("Bean class is required and can not be null");
        }
        PropertyInfo[] infos = this.properties.get(beanClass);
        if (infos != null) {
            return infos;
        }
        try {
            descriptors = Introspector.getBeanInfo(beanClass).getPropertyDescriptors();
            if (descriptors == null) {
                descriptors = EMPTY_PROPERTY_DESCRIPTOR;
            }
        }
        catch (IntrospectionException e) {
            descriptors = EMPTY_PROPERTY_DESCRIPTOR;
        }
        infos = new PropertyInfo[descriptors.length];
        for (int i = 0; i < descriptors.length; ++i) {
            infos[i] = this.createPropertyInfo(beanClass, descriptors[i]);
        }
        this.properties.put(beanClass, infos);
        return infos;
    }

    private PropertyInfo createPropertyInfo(Class<?> beanClass, PropertyDescriptor d) {
        return new PropertyInfo(beanClass, d.getName(), d.getPropertyType(), d.getReadMethod(), d.getWriteMethod());
    }

    private PropertyInfo createPropertyInfo(Class<?> beanClass, String propertyName, Class<?> propertyType) {
        return new PropertyInfo(beanClass, propertyName, propertyType, null, null);
    }

    public static class PropertyInfo {
        private final Class<?> beanClass;
        private final String name;
        private final Class<?> type;
        private final Method readMethod;
        private final Method writeMethod;

        PropertyInfo(Class<?> beanClass, String name, Class<?> type, Method readMethod, Method writeMethod) {
            this.beanClass = beanClass;
            this.name = name;
            this.type = type;
            this.readMethod = readMethod;
            this.writeMethod = writeMethod;
        }

        public Class<?> getBeanClass() {
            return this.beanClass;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Method getReadMethod() {
            return this.readMethod;
        }

        public Method getWriteMethod() {
            return this.writeMethod;
        }

        public String toString() {
            return "PropertyInfo{beanClass=" + this.beanClass + ", name='" + this.name + "'" + ", type=" + this.type + ", readMethod=" + this.readMethod + ", writeMethod=" + this.writeMethod + "}";
        }
    }
}

