/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.numenta.nupic.util.ArrayUtils;
import org.numenta.nupic.util.SparseMatrix;

public class SparseBinaryMatrix
extends SparseMatrix {
    private TIntIntMap sparseMap = new TIntIntHashMap();
    private int[] trueCounts;
    private Object backingArray;

    public SparseBinaryMatrix(int[] dimensions) {
        this(dimensions, false);
    }

    public SparseBinaryMatrix(int[] dimensions, boolean useColumnMajorOrdering) {
        super(dimensions, useColumnMajorOrdering);
        this.backingArray = Array.newInstance(Integer.TYPE, dimensions);
        this.trueCounts = new int[dimensions[0]];
    }

    private void back(int val, int ... coordinates) {
        ArrayUtils.setValue(this.backingArray, val, coordinates);
        this.trueCounts[coordinates[0]] = ArrayUtils.aggregateArray(((Object[])this.backingArray)[coordinates[0]]);
    }

    public Object getSlice(int ... coordinates) {
        Object slice = this.backingArray;
        for (int i = 0; i < coordinates.length; ++i) {
            slice = Array.get(slice, coordinates[i]);
        }
        if (!slice.getClass().isArray()) {
            throw new IllegalArgumentException("This method only returns the array holding the specified index: " + Arrays.toString(coordinates));
        }
        return slice;
    }

    public void rightVecSumAtNZ(int[] inputVector, int[] results) {
        for (int i = 0; i < this.dimensions[0]; ++i) {
            int[] slice = (int[])(this.dimensions.length > 1 ? this.getSlice(i) : this.backingArray);
            for (int j = 0; j < slice.length; ++j) {
                int n = i;
                results[n] = results[n] + inputVector[j] * slice[j];
            }
        }
    }

    public SparseBinaryMatrix set(int index, int value) {
        int[] coordinates = this.computeCoordinates(index);
        return this.set(value, coordinates);
    }

    public SparseBinaryMatrix set(int value, int ... coordinates) {
        this.sparseMap.put(this.computeIndex(coordinates), value);
        this.back(value, coordinates);
        return this;
    }

    public SparseBinaryMatrix set(int[] indexes, int[] values) {
        for (int i = 0; i < indexes.length; ++i) {
            this.set(indexes[i], values[i]);
        }
        return this;
    }

    public SparseBinaryMatrix setForTest(int index, int value) {
        this.sparseMap.put(index, value);
        return this;
    }

    public SparseBinaryMatrix set(int[] indexes, int[] values, boolean isTest) {
        for (int i = 0; i < indexes.length; ++i) {
            if (isTest) {
                this.setForTest(indexes[i], values[i]);
                continue;
            }
            this.set(indexes[i], values[i]);
        }
        return this;
    }

    public int getTrueCount(int index) {
        return this.trueCounts[index];
    }

    public void setTrueCount(int index, int count) {
        this.trueCounts[index] = count;
    }

    public int[] getTrueCounts() {
        return this.trueCounts;
    }

    public void clearStatistics(int row) {
        int[] slice = (int[])Array.get(this.backingArray, row);
        Arrays.fill(slice, 0);
        this.trueCounts[row] = 0;
        this.sparseMap.put(row, 0);
    }

    protected int[] values() {
        return this.sparseMap.values();
    }

    @Override
    public int getIntValue(int ... coordinates) {
        return this.sparseMap.get(this.computeIndex(coordinates));
    }

    @Override
    public int getIntValue(int index) {
        return this.sparseMap.get(index);
    }

    @Override
    public int[] getSparseIndices() {
        return SparseBinaryMatrix.reverse(this.sparseMap.keys());
    }

    public SparseBinaryMatrix or(SparseBinaryMatrix inputMatrix) {
        int[] mask = inputMatrix.getSparseIndices();
        int[] ones = new int[mask.length];
        Arrays.fill(ones, 1);
        return this.set(mask, ones);
    }

    public SparseBinaryMatrix or(TIntCollection onBitIndexes) {
        int[] ones = new int[onBitIndexes.size()];
        Arrays.fill(ones, 1);
        return this.set(onBitIndexes.toArray(), ones);
    }

    public SparseBinaryMatrix or(int[] onBitIndexes) {
        int[] ones = new int[onBitIndexes.length];
        Arrays.fill(ones, 1);
        return this.set(onBitIndexes, ones);
    }

    public boolean all(SparseBinaryMatrix matrix) {
        return this.sparseMap.keySet().containsAll(matrix.sparseMap.keys());
    }

    public boolean all(TIntCollection onBits) {
        return this.sparseMap.keySet().containsAll(onBits);
    }

    public boolean all(int[] onBits) {
        return this.sparseMap.keySet().containsAll(onBits);
    }

    public boolean any(SparseBinaryMatrix matrix) {
        for (int i : matrix.sparseMap.keys()) {
            if (!this.sparseMap.containsKey(i)) continue;
            return true;
        }
        return false;
    }

    public boolean any(TIntList onBits) {
        TIntIterator i = onBits.iterator();
        while (i.hasNext()) {
            if (!this.sparseMap.containsKey(i.next())) continue;
            return true;
        }
        return false;
    }

    public boolean any(int[] onBits) {
        for (int i : onBits) {
            if (!this.sparseMap.containsKey(i)) continue;
            return true;
        }
        return false;
    }
}

