/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.numenta.nupic.util.TypeFactory;

public abstract class SparseMatrix<T> {
    protected final int[] dimensionMultiples;
    protected final int[] dimensions;
    protected final int numDimensions;
    protected final boolean isColumnMajor;

    public SparseMatrix(int[] dimensions) {
        this(dimensions, false);
    }

    public SparseMatrix(int[] dimensions, boolean useColumnMajorOrdering) {
        this.dimensions = dimensions;
        this.numDimensions = dimensions.length;
        this.dimensionMultiples = this.initDimensionMultiples(useColumnMajorOrdering ? SparseMatrix.reverse(dimensions) : dimensions);
        this.isColumnMajor = useColumnMajorOrdering;
    }

    public int[] getDimensionMultiples() {
        return this.dimensionMultiples;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public int getNumDimensions() {
        return this.numDimensions;
    }

    protected <S extends SparseMatrix<T>> S set(int index, T object) {
        return null;
    }

    protected <S extends SparseMatrix<T>> S set(int index, int value) {
        return null;
    }

    protected <S extends SparseMatrix<T>> S set(int index, double value) {
        return null;
    }

    protected <S extends SparseMatrix<T>> S set(int[] coordinates, T object) {
        return null;
    }

    protected <S extends SparseMatrix<T>> S set(int value, int ... coordinates) {
        return null;
    }

    protected <S extends SparseMatrix<T>> S set(double value, int ... coordinates) {
        return null;
    }

    protected T getObject(int index) {
        return null;
    }

    protected int getIntValue(int index) {
        return -1;
    }

    protected double getDoubleValue(int index) {
        return -1.0;
    }

    protected abstract <V> V values();

    protected T get(int ... coordinates) {
        return null;
    }

    protected int getIntValue(int ... coordinates) {
        return -1;
    }

    protected double getDoubleValue(int ... coordinates) {
        return -1.0;
    }

    public int[] getSparseIndices() {
        return null;
    }

    public int[] get1DIndexes() {
        TIntArrayList results = new TIntArrayList(this.getMaxIndex() + 1);
        this.visit(this.dimensions, 0, new int[this.numDimensions], (TIntList)results);
        return results.toArray();
    }

    private void visit(int[] bounds, int currentDimension, int[] p, TIntList results) {
        for (int i = 0; i < bounds[currentDimension]; ++i) {
            p[currentDimension] = i;
            if (currentDimension == p.length - 1) {
                results.add(this.computeIndex(p));
                continue;
            }
            this.visit(bounds, currentDimension + 1, p, results);
        }
    }

    public int getMaxIndex() {
        return this.dimensions[0] * Math.max(1, this.dimensionMultiples[0]) - 1;
    }

    public T[] asDense(TypeFactory<T> factory) {
        Object[] retVal = (Object[])Array.newInstance(factory.typeClass(), this.dimensions);
        this.fill(factory, 0, this.dimensions, this.dimensions[0], retVal);
        return retVal;
    }

    protected Object[] fill(TypeFactory<T> f, int dimensionIndex, int[] dimensions, int count, Object[] arr) {
        if (dimensions.length == 1) {
            for (int i = 0; i < count; ++i) {
                arr[i] = f.make(this.dimensions);
            }
            return arr;
        }
        for (int i = 0; i < count; ++i) {
            int[] inner = this.copyInnerArray(dimensions);
            Object[] r = (Object[])Array.newInstance(f.typeClass(), inner);
            arr[i] = this.fill(f, dimensionIndex + 1, inner, this.dimensions[dimensionIndex + 1], r);
        }
        return arr;
    }

    protected int[] copyInnerArray(int[] array) {
        if (array.length == 1) {
            return array;
        }
        int[] retVal = new int[array.length - 1];
        System.arraycopy(array, 1, retVal, 0, array.length - 1);
        return retVal;
    }

    public static int[] reverse(int[] input) {
        int[] retVal = new int[input.length];
        int i = input.length - 1;
        int j = 0;
        while (i >= 0) {
            retVal[j] = input[i];
            --i;
            ++j;
        }
        return retVal;
    }

    protected int[] initDimensionMultiples(int[] dimensions) {
        int holder = 1;
        int len = dimensions.length;
        int[] dimensionMultiples = new int[this.numDimensions];
        for (int i = 0; i < len; ++i) {
            dimensionMultiples[len - 1 - i] = holder *= i == 0 ? 1 : dimensions[len - i];
        }
        return dimensionMultiples;
    }

    public int computeIndex(int[] coordinates) {
        return this.computeIndex(coordinates, true);
    }

    public int computeIndex(int[] coordinates, boolean doCheck) {
        if (doCheck) {
            this.checkDims(coordinates);
        }
        int[] localMults = this.isColumnMajor ? SparseMatrix.reverse(this.dimensionMultiples) : this.dimensionMultiples;
        int base = 0;
        for (int i = 0; i < coordinates.length; ++i) {
            base += localMults[i] * coordinates[i];
        }
        return base;
    }

    public int[] computeCoordinates(int index) {
        int[] returnVal = new int[this.numDimensions];
        int base = index;
        for (int i = 0; i < this.dimensionMultiples.length; ++i) {
            int quotient = base / this.dimensionMultiples[i];
            base %= this.dimensionMultiples[i];
            returnVal[i] = quotient;
        }
        return this.isColumnMajor ? SparseMatrix.reverse(returnVal) : returnVal;
    }

    protected void checkDims(int[] index) {
        if (index.length != this.numDimensions) {
            throw new IllegalArgumentException("Specified coordinates exceed the configured array dimensions input dimensions: " + index.length + " > number of configured dimensions: " + this.numDimensions);
        }
        for (int i = 0; i < index.length - 1; ++i) {
            if (index[i] < this.dimensions[i]) continue;
            throw new IllegalArgumentException("Specified coordinates exceed the configured array dimensions " + SparseMatrix.print1DArray(index) + " > " + SparseMatrix.print1DArray(this.dimensions));
        }
    }

    public static String print1DArray(Object aObject) {
        if (aObject.getClass().isArray()) {
            if (aObject instanceof Object[]) {
                return Arrays.toString((Object[])aObject);
            }
            int length = Array.getLength(aObject);
            Object[] objArr = new Object[length];
            for (int i = 0; i < length; ++i) {
                objArr[i] = Array.get(aObject, i);
            }
            return Arrays.toString(objArr);
        }
        return "[]";
    }
}

