/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic;

import com.cedarsoftware.util.DeepEquals;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.numenta.nupic.model.Connections;
import org.numenta.nupic.model.Persistable;
import org.numenta.nupic.util.ArrayUtils;
import org.numenta.nupic.util.BeanUtil;
import org.numenta.nupic.util.MersenneTwister;
import org.numenta.nupic.util.Tuple;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;

public class Parameters
implements Persistable {
    private static final long serialVersionUID = 1L;
    private static final Map<KEY, Object> DEFAULTS_ALL;
    private static final Map<KEY, Object> DEFAULTS_TEMPORAL;
    private static final Map<KEY, Object> DEFAULTS_SPATIAL;
    private static final Map<KEY, Object> DEFAULTS_ENCODER;
    private final Map<KEY, Object> paramMap = Collections.synchronizedMap(new ParametersMap());

    public int size() {
        return this.paramMap.size();
    }

    public static Parameters getAllDefaultParameters() {
        return Parameters.getParameters(DEFAULTS_ALL);
    }

    public static Parameters getTemporalDefaultParameters() {
        return Parameters.getParameters(DEFAULTS_TEMPORAL);
    }

    public static Parameters getSpatialDefaultParameters() {
        return Parameters.getParameters(DEFAULTS_SPATIAL);
    }

    public static Parameters getEncoderDefaultParameters() {
        return Parameters.getParameters(DEFAULTS_ENCODER);
    }

    private static Parameters getParameters(Map<KEY, Object> map) {
        Parameters result = new Parameters();
        for (KEY key : map.keySet()) {
            result.set(key, map.get((Object)key));
        }
        return result;
    }

    private Parameters() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(Object cn) {
        BeanUtil beanUtil = BeanUtil.getInstance();
        Set<KEY> presentKeys = this.paramMap.keySet();
        Map<KEY, Object> map = this.paramMap;
        synchronized (map) {
            for (KEY key : presentKeys) {
                if (cn instanceof Connections && (key == KEY.SYN_PERM_BELOW_STIMULUS_INC || key == KEY.SYN_PERM_TRIM_THRESHOLD)) continue;
                if (key == KEY.RANDOM) {
                    ((Random)this.get(key)).setSeed(((Integer)this.get(KEY.SEED)).intValue());
                }
                beanUtil.setSimpleProperty(cn, key.fieldName, this.get(key));
            }
        }
    }

    public Parameters union(Parameters p) {
        for (KEY k : p.paramMap.keySet()) {
            this.set(k, p.get(k));
        }
        return this;
    }

    public Set<KEY> keys() {
        Set<KEY> retVal = this.paramMap.keySet();
        return retVal;
    }

    public Parameters copy() {
        return new Parameters().union(this);
    }

    public static Parameters empty() {
        return new Parameters();
    }

    public void set(KEY key, Object value) {
        this.paramMap.put(key, value);
    }

    public Object get(KEY key) {
        return this.paramMap.get((Object)key);
    }

    public void clearParameter(KEY key) {
        this.paramMap.remove((Object)key);
    }

    public boolean logDiff(Object cn) {
        if (cn == null) {
            throw new IllegalArgumentException("cn Object is required and can not be null");
        }
        boolean result = false;
        BeanUtil beanUtil = BeanUtil.getInstance();
        BeanUtil.PropertyInfo[] properties = beanUtil.getPropertiesInfoForBean(cn.getClass());
        for (int i = 0; i < properties.length; ++i) {
            BeanUtil.PropertyInfo property = properties[i];
            String fieldName = property.getName();
            KEY propKey = KEY.getKeyByFieldName(property.getName());
            if (propKey == null) continue;
            Object paramValue = this.get(propKey);
            Object cnValue = beanUtil.getSimpleProperty(cn, fieldName);
            if (propKey == KEY.POTENTIAL_RADIUS) {
                System.out.println("Difference is OK: Property:" + fieldName + " is different - CN:" + cnValue + " | PARAM:" + paramValue);
                continue;
            }
            if ((paramValue == null || paramValue.equals(cnValue)) && (paramValue != null || cnValue == null)) continue;
            result = true;
            System.out.println("Property:" + fieldName + " is different - CONNECTIONS:" + cnValue + " | PARAMETERS:" + paramValue);
        }
        return result;
    }

    public void setRandom(Random r) {
        this.paramMap.put(KEY.RANDOM, r);
    }

    public void setColumnDimensions(int[] columnDimensions) {
        this.paramMap.put(KEY.COLUMN_DIMENSIONS, columnDimensions);
    }

    public void setCellsPerColumn(int cellsPerColumn) {
        this.paramMap.put(KEY.CELLS_PER_COLUMN, cellsPerColumn);
    }

    public void setActivationThreshold(int activationThreshold) {
        this.paramMap.put(KEY.ACTIVATION_THRESHOLD, activationThreshold);
    }

    public void setLearningRadius(int learningRadius) {
        this.paramMap.put(KEY.LEARNING_RADIUS, learningRadius);
    }

    public void setMinThreshold(int minThreshold) {
        this.paramMap.put(KEY.MIN_THRESHOLD, minThreshold);
    }

    public void setMaxSynapsesPerSegment(int maxSynapsesPerSegment) {
        this.paramMap.put(KEY.MAX_SYNAPSES_PER_SEGMENT, maxSynapsesPerSegment);
    }

    public void setMaxSegmentsPerCell(int maxSegmentsPerCell) {
        this.paramMap.put(KEY.MAX_SEGMENTS_PER_CELL, maxSegmentsPerCell);
    }

    public void setMaxNewSynapseCount(int count) {
        this.paramMap.put(KEY.MAX_NEW_SYNAPSE_COUNT, count);
    }

    public void setSeed(int seed) {
        this.paramMap.put(KEY.SEED, seed);
    }

    public void setInitialPermanence(double initialPermanence) {
        this.paramMap.put(KEY.INITIAL_PERMANENCE, initialPermanence);
    }

    public void setConnectedPermanence(double connectedPermanence) {
        this.paramMap.put(KEY.CONNECTED_PERMANENCE, connectedPermanence);
    }

    public void setPermanenceIncrement(double permanenceIncrement) {
        this.paramMap.put(KEY.PERMANENCE_INCREMENT, permanenceIncrement);
    }

    public void setPermanenceDecrement(double permanenceDecrement) {
        this.paramMap.put(KEY.PERMANENCE_DECREMENT, permanenceDecrement);
    }

    public void setInputDimensions(int[] inputDimensions) {
        this.paramMap.put(KEY.INPUT_DIMENSIONS, inputDimensions);
    }

    public void setPotentialRadius(int potentialRadius) {
        this.paramMap.put(KEY.POTENTIAL_RADIUS, potentialRadius);
    }

    public void setInhibitionRadius(int inhibitionRadius) {
        this.paramMap.put(KEY.INHIBITION_RADIUS, inhibitionRadius);
    }

    public void setPotentialPct(double potentialPct) {
        this.paramMap.put(KEY.POTENTIAL_PCT, potentialPct);
    }

    public void setGlobalInhibition(boolean globalInhibition) {
        this.paramMap.put(KEY.GLOBAL_INHIBITION, globalInhibition);
    }

    public void setLocalAreaDensity(double localAreaDensity) {
        this.paramMap.put(KEY.LOCAL_AREA_DENSITY, localAreaDensity);
    }

    public void setNumActiveColumnsPerInhArea(double numActiveColumnsPerInhArea) {
        this.paramMap.put(KEY.NUM_ACTIVE_COLUMNS_PER_INH_AREA, numActiveColumnsPerInhArea);
    }

    public void setStimulusThreshold(double stimulusThreshold) {
        this.paramMap.put(KEY.STIMULUS_THRESHOLD, stimulusThreshold);
    }

    public void setSynPermInactiveDec(double synPermInactiveDec) {
        this.paramMap.put(KEY.SYN_PERM_INACTIVE_DEC, synPermInactiveDec);
    }

    public void setSynPermActiveInc(double synPermActiveInc) {
        this.paramMap.put(KEY.SYN_PERM_ACTIVE_INC, synPermActiveInc);
    }

    public void setSynPermConnected(double synPermConnected) {
        this.paramMap.put(KEY.SYN_PERM_CONNECTED, synPermConnected);
    }

    public void setSynPermBelowStimulusInc(double synPermBelowStimulusInc) {
        this.paramMap.put(KEY.SYN_PERM_BELOW_STIMULUS_INC, synPermBelowStimulusInc);
    }

    public void setSynPermTrimThreshold(double synPermTrimThreshold) {
        this.paramMap.put(KEY.SYN_PERM_TRIM_THRESHOLD, synPermTrimThreshold);
    }

    public void setMinPctOverlapDutyCycles(double minPctOverlapDutyCycles) {
        this.paramMap.put(KEY.MIN_PCT_OVERLAP_DUTY_CYCLES, minPctOverlapDutyCycles);
    }

    public void setMinPctActiveDutyCycles(double minPctActiveDutyCycles) {
        this.paramMap.put(KEY.MIN_PCT_ACTIVE_DUTY_CYCLES, minPctActiveDutyCycles);
    }

    public void setDutyCyclePeriod(int dutyCyclePeriod) {
        this.paramMap.put(KEY.DUTY_CYCLE_PERIOD, dutyCyclePeriod);
    }

    public void setMaxBoost(double maxBoost) {
        this.paramMap.put(KEY.MAX_BOOST, maxBoost);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("{\n");
        StringBuilder spatialInfo = new StringBuilder();
        StringBuilder temporalInfo = new StringBuilder();
        StringBuilder otherInfo = new StringBuilder();
        this.paramMap.keySet();
        for (KEY key : this.paramMap.keySet()) {
            if (DEFAULTS_SPATIAL.containsKey((Object)key)) {
                this.buildParamStr(spatialInfo, key);
                continue;
            }
            if (DEFAULTS_TEMPORAL.containsKey((Object)key)) {
                this.buildParamStr(temporalInfo, key);
                continue;
            }
            this.buildParamStr(otherInfo, key);
        }
        if (spatialInfo.length() > 0) {
            result.append("\tSpatial: {\n").append((CharSequence)spatialInfo).append("\t}\n");
        }
        if (temporalInfo.length() > 0) {
            result.append("\tTemporal: {\n").append((CharSequence)temporalInfo).append("\t}\n");
        }
        if (otherInfo.length() > 0) {
            result.append("\tOther: {\n").append((CharSequence)otherInfo).append("\t}\n");
        }
        return result.append("}").toString();
    }

    private void buildParamStr(StringBuilder spatialInfo, KEY key) {
        Object value = this.get(key);
        if (value instanceof int[]) {
            value = ArrayUtils.intArrayToString(value);
        }
        spatialInfo.append("\t\t").append(key.getFieldName()).append(":").append(value).append("\n");
    }

    public Parameters readForNetwork(FSTObjectInput in) throws Exception {
        Parameters result = (Parameters)in.readObject(new Class[]{Parameters.class});
        return result;
    }

    public void writeForNetwork(FSTObjectOutput out) throws IOException {
        out.writeObject((Object)this, new Class[]{Parameters.class});
        out.close();
    }

    public int hashCode() {
        Random rnd = (Random)this.paramMap.remove((Object)KEY.RANDOM);
        int hc = DeepEquals.deepHashCode(this.paramMap);
        this.paramMap.put(KEY.RANDOM, rnd);
        return hc;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameters other = (Parameters)obj;
        if (this.paramMap == null) {
            if (other.paramMap != null) {
                return false;
            }
        } else {
            Class[] classArray = new Class[]{Object.class};
            try {
                for (KEY key : this.paramMap.keySet()) {
                    if (this.paramMap.get((Object)key) == null || other.paramMap.get((Object)key) == null) continue;
                    Class<?> thisValueClass = this.paramMap.get((Object)key).getClass();
                    Class<?> otherValueClass = other.paramMap.get((Object)key).getClass();
                    boolean isSpecial = this.isSpecial(key, thisValueClass);
                    if (!isSpecial && (thisValueClass.getMethod("equals", classArray).getDeclaringClass() != thisValueClass || otherValueClass.getMethod("equals", classArray).getDeclaringClass() != otherValueClass) || !(isSpecial ? (int[].class.isAssignableFrom(thisValueClass) ? !Arrays.equals((int[])this.paramMap.get((Object)key), (int[])other.paramMap.get((Object)key)) : key == KEY.FIELD_ENCODING_MAP && !DeepEquals.deepEquals((Object)this.paramMap.get((Object)key), (Object)other.paramMap.get((Object)key))) : !other.paramMap.containsKey((Object)key) || !this.paramMap.get((Object)key).equals(other.paramMap.get((Object)key)))) continue;
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private boolean isSpecial(KEY key, Class<?> klazz) {
        return int[].class.isAssignableFrom(klazz) || key == KEY.FIELD_ENCODING_MAP;
    }

    static {
        ParametersMap defaultParams = new ParametersMap();
        defaultParams.put(KEY.SEED, 42);
        defaultParams.put(KEY.RANDOM, new MersenneTwister(((Integer)defaultParams.get((Object)KEY.SEED)).intValue()));
        ParametersMap defaultTemporalParams = new ParametersMap();
        defaultTemporalParams.put(KEY.COLUMN_DIMENSIONS, new int[]{2048});
        defaultTemporalParams.put(KEY.CELLS_PER_COLUMN, 32);
        defaultTemporalParams.put(KEY.ACTIVATION_THRESHOLD, 13);
        defaultTemporalParams.put(KEY.LEARNING_RADIUS, 2048);
        defaultTemporalParams.put(KEY.MIN_THRESHOLD, 10);
        defaultTemporalParams.put(KEY.MAX_NEW_SYNAPSE_COUNT, 20);
        defaultTemporalParams.put(KEY.MAX_SYNAPSES_PER_SEGMENT, 255);
        defaultTemporalParams.put(KEY.MAX_SEGMENTS_PER_CELL, 255);
        defaultTemporalParams.put(KEY.INITIAL_PERMANENCE, 0.21);
        defaultTemporalParams.put(KEY.CONNECTED_PERMANENCE, 0.5);
        defaultTemporalParams.put(KEY.PERMANENCE_INCREMENT, 0.1);
        defaultTemporalParams.put(KEY.PERMANENCE_DECREMENT, 0.1);
        defaultTemporalParams.put(KEY.PREDICTED_SEGMENT_DECREMENT, 0.0);
        defaultTemporalParams.put(KEY.LEARN, true);
        DEFAULTS_TEMPORAL = Collections.unmodifiableMap(defaultTemporalParams);
        defaultParams.putAll(DEFAULTS_TEMPORAL);
        ParametersMap defaultSpatialParams = new ParametersMap();
        defaultSpatialParams.put(KEY.INPUT_DIMENSIONS, new int[]{64});
        defaultSpatialParams.put(KEY.POTENTIAL_RADIUS, -1);
        defaultSpatialParams.put(KEY.POTENTIAL_PCT, 0.5);
        defaultSpatialParams.put(KEY.GLOBAL_INHIBITION, false);
        defaultSpatialParams.put(KEY.INHIBITION_RADIUS, 0);
        defaultSpatialParams.put(KEY.LOCAL_AREA_DENSITY, -1.0);
        defaultSpatialParams.put(KEY.NUM_ACTIVE_COLUMNS_PER_INH_AREA, 10.0);
        defaultSpatialParams.put(KEY.STIMULUS_THRESHOLD, 0.0);
        defaultSpatialParams.put(KEY.SYN_PERM_INACTIVE_DEC, 0.008);
        defaultSpatialParams.put(KEY.SYN_PERM_ACTIVE_INC, 0.05);
        defaultSpatialParams.put(KEY.SYN_PERM_CONNECTED, 0.1);
        defaultSpatialParams.put(KEY.SYN_PERM_BELOW_STIMULUS_INC, 0.01);
        defaultSpatialParams.put(KEY.SYN_PERM_TRIM_THRESHOLD, 0.05);
        defaultSpatialParams.put(KEY.MIN_PCT_OVERLAP_DUTY_CYCLES, 0.001);
        defaultSpatialParams.put(KEY.MIN_PCT_ACTIVE_DUTY_CYCLES, 0.001);
        defaultSpatialParams.put(KEY.DUTY_CYCLE_PERIOD, 1000);
        defaultSpatialParams.put(KEY.MAX_BOOST, 10.0);
        defaultSpatialParams.put(KEY.WRAP_AROUND, true);
        defaultSpatialParams.put(KEY.LEARN, true);
        DEFAULTS_SPATIAL = Collections.unmodifiableMap(defaultSpatialParams);
        defaultParams.putAll(DEFAULTS_SPATIAL);
        ParametersMap defaultEncoderParams = new ParametersMap();
        defaultEncoderParams.put(KEY.N, 500);
        defaultEncoderParams.put(KEY.W, 21);
        defaultEncoderParams.put(KEY.MIN_VAL, 0.0);
        defaultEncoderParams.put(KEY.MAX_VAL, 1000.0);
        defaultEncoderParams.put(KEY.RADIUS, 21.0);
        defaultEncoderParams.put(KEY.RESOLUTION, 1.0);
        defaultEncoderParams.put(KEY.PERIODIC, false);
        defaultEncoderParams.put(KEY.CLIP_INPUT, false);
        defaultEncoderParams.put(KEY.FORCED, false);
        defaultEncoderParams.put(KEY.FIELD_NAME, "UNSET");
        defaultEncoderParams.put(KEY.FIELD_TYPE, "int");
        defaultEncoderParams.put(KEY.ENCODER, "ScalarEncoder");
        defaultEncoderParams.put(KEY.FIELD_ENCODING_MAP, Collections.emptyMap());
        defaultEncoderParams.put(KEY.AUTO_CLASSIFY, Boolean.FALSE);
        DEFAULTS_ENCODER = Collections.unmodifiableMap(defaultEncoderParams);
        defaultParams.putAll(DEFAULTS_ENCODER);
        DEFAULTS_ALL = Collections.unmodifiableMap(defaultParams);
    }

    private static class ParametersMap
    extends EnumMap<KEY, Object> {
        private static final long serialVersionUID = 1L;

        ParametersMap() {
            super(KEY.class);
        }

        @Override
        public Object put(KEY key, Object value) {
            if (value != null) {
                if (!key.getFieldType().isInstance(value)) {
                    throw new IllegalArgumentException("Can not set Parameters Property '" + key.getFieldName() + "' because of type mismatch. The required type is " + key.getFieldType());
                }
                if (value instanceof Number && !key.checkRange((Number)value)) {
                    throw new IllegalArgumentException("Can not set Parameters Property '" + key.getFieldName() + "' because of value '" + value + "' not in range. Range[" + key.getMin() + "-" + key.getMax() + "]");
                }
            }
            return super.put(key, value);
        }
    }

    public static enum KEY {
        COLUMN_DIMENSIONS("columnDimensions", int[].class),
        CELLS_PER_COLUMN("cellsPerColumn", Integer.class, 1, null),
        LEARN("learn", Boolean.class),
        RANDOM("random", Random.class),
        SEED("seed", Integer.class),
        ACTIVATION_THRESHOLD("activationThreshold", Integer.class, 0, null),
        LEARNING_RADIUS("learningRadius", Integer.class, 0, null),
        MIN_THRESHOLD("minThreshold", Integer.class, 0, null),
        MAX_NEW_SYNAPSE_COUNT("maxNewSynapseCount", Integer.class),
        MAX_SYNAPSES_PER_SEGMENT("maxSynapsesPerSegment", Integer.class),
        MAX_SEGMENTS_PER_CELL("maxSegmentsPerCell", Integer.class),
        INITIAL_PERMANENCE("initialPermanence", Double.class, 0.0, 1.0),
        CONNECTED_PERMANENCE("connectedPermanence", Double.class, 0.0, 1.0),
        PERMANENCE_INCREMENT("permanenceIncrement", Double.class, 0.0, 1.0),
        PERMANENCE_DECREMENT("permanenceDecrement", Double.class, 0.0, 1.0),
        PREDICTED_SEGMENT_DECREMENT("predictedSegmentDecrement", Double.class, 0.0, 9.0),
        INPUT_DIMENSIONS("inputDimensions", int[].class),
        POTENTIAL_RADIUS("potentialRadius", Integer.class),
        POTENTIAL_PCT("potentialPct", Double.class),
        GLOBAL_INHIBITION("globalInhibition", Boolean.class),
        INHIBITION_RADIUS("inhibitionRadius", Integer.class, 0, null),
        LOCAL_AREA_DENSITY("localAreaDensity", Double.class),
        NUM_ACTIVE_COLUMNS_PER_INH_AREA("numActiveColumnsPerInhArea", Double.class),
        STIMULUS_THRESHOLD("stimulusThreshold", Double.class),
        SYN_PERM_INACTIVE_DEC("synPermInactiveDec", Double.class, 0.0, 1.0),
        SYN_PERM_ACTIVE_INC("synPermActiveInc", Double.class, 0.0, 1.0),
        SYN_PERM_CONNECTED("synPermConnected", Double.class, 0.0, 1.0),
        SYN_PERM_BELOW_STIMULUS_INC("synPermBelowStimulusInc", Double.class, 0.0, 1.0),
        SYN_PERM_TRIM_THRESHOLD("synPermTrimThreshold", Double.class, 0.0, 1.0),
        MIN_PCT_OVERLAP_DUTY_CYCLES("minPctOverlapDutyCycles", Double.class),
        MIN_PCT_ACTIVE_DUTY_CYCLES("minPctActiveDutyCycles", Double.class),
        DUTY_CYCLE_PERIOD("dutyCyclePeriod", Integer.class),
        MAX_BOOST("maxBoost", Double.class),
        WRAP_AROUND("wrapAround", Boolean.class),
        SP_PRIMER_DELAY("sp_primer_delay", Integer.class),
        N("n", Integer.class),
        W("w", Integer.class),
        MIN_VAL("minVal", Double.class),
        MAX_VAL("maxVal", Double.class),
        RADIUS("radius", Double.class),
        RESOLUTION("resolution", Double.class),
        PERIODIC("periodic", Boolean.class),
        CLIP_INPUT("clipInput", Boolean.class),
        FORCED("forced", Boolean.class),
        FIELD_NAME("fieldName", String.class),
        FIELD_TYPE("fieldType", String.class),
        ENCODER("encoderType", String.class),
        FIELD_ENCODING_MAP("fieldEncodings", Map.class),
        CATEGORY_LIST("categoryList", List.class),
        AUTO_CLASSIFY("hasClassifiers", Boolean.class),
        DATEFIELD_SEASON("season", Tuple.class),
        DATEFIELD_DOFW("dayOfWeek", Tuple.class),
        DATEFIELD_WKEND("weekend", Tuple.class),
        DATEFIELD_HOLIDAY("holiday", Tuple.class),
        DATEFIELD_TOFD("timeOfDay", Tuple.class),
        DATEFIELD_CUSTOM("customDays", Tuple.class),
        DATEFIELD_PATTERN("formatPattern", String.class);

        private static final Map<String, KEY> fieldMap;
        private final String fieldName;
        private final Class<?> fieldType;
        private final Number min;
        private final Number max;

        public static KEY getKeyByFieldName(String fieldName) {
            return fieldMap.get(fieldName);
        }

        private KEY(String fieldName, Class<?> fieldType) {
            this(fieldName, fieldType, null, null);
        }

        private KEY(String fieldName, Class<?> fieldType, Number min, Number max) {
            this.fieldName = fieldName;
            this.fieldType = fieldType;
            this.min = min;
            this.max = max;
        }

        public Class<?> getFieldType() {
            return this.fieldType;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Number getMin() {
            return this.min;
        }

        public Number getMax() {
            return this.max;
        }

        public boolean checkRange(Number value) {
            if (value == null) {
                throw new IllegalArgumentException("checkRange argument can not be null");
            }
            return this.min == null && this.max == null || this.min != null && this.max == null && value.doubleValue() >= this.min.doubleValue() || this.max != null && this.min == null && value.doubleValue() <= this.max.doubleValue() || this.min != null && value.doubleValue() >= this.min.doubleValue() && this.max != null && value.doubleValue() <= this.max.doubleValue();
        }

        static {
            fieldMap = new HashMap<String, KEY>();
            for (KEY key : KEY.values()) {
                fieldMap.put(key.getFieldName(), key);
            }
        }
    }
}

