/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.algorithms;

import gnu.trove.list.TDoubleList;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.map.TObjectDoubleMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.joda.time.DateTime;
import org.numenta.nupic.algorithms.Anomaly;
import org.numenta.nupic.algorithms.AnomalyLikelihoodMetrics;
import org.numenta.nupic.algorithms.MovingAverage;
import org.numenta.nupic.algorithms.Sample;
import org.numenta.nupic.algorithms.Statistic;
import org.numenta.nupic.util.ArrayUtils;
import org.numenta.nupic.util.NamedTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnomalyLikelihood
extends Anomaly {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AnomalyLikelihood.class);
    private int claLearningPeriod = 300;
    private int estimationSamples = 300;
    private int probationaryPeriod;
    private int iteration;
    private int reestimationPeriod;
    private boolean isWeighted;
    private List<Sample> historicalScores = new ArrayList<Sample>();
    private AnomalyParams distribution;
    private static double[] Q = new double[71];

    public AnomalyLikelihood(boolean useMovingAvg, int windowSize, boolean isWeighted, int claLearningPeriod, int estimationSamples) {
        super(useMovingAvg, windowSize);
        this.isWeighted = isWeighted;
        this.claLearningPeriod = claLearningPeriod == -1 ? this.claLearningPeriod : claLearningPeriod;
        this.estimationSamples = estimationSamples == -1 ? this.estimationSamples : estimationSamples;
        this.probationaryPeriod = this.claLearningPeriod + this.estimationSamples;
        this.reestimationPeriod = 100;
    }

    public static double computeLogLikelihood(double likelihood) {
        return Math.log(1.0000000001 - likelihood) / -23.02585084720009;
    }

    public double anomalyProbability(double value, double anomalyScore, DateTime timestamp) {
        double likelihoodRetval;
        if (timestamp == null) {
            timestamp = new DateTime();
        }
        Sample dataPoint = new Sample(timestamp, value, anomalyScore);
        if (this.historicalScores.size() < this.probationaryPeriod) {
            likelihoodRetval = 0.5;
        } else {
            if (this.distribution == null || this.iteration % this.reestimationPeriod == 0) {
                this.distribution = this.estimateAnomalyLikelihoods(this.historicalScores, 10, this.claLearningPeriod).getParams();
            }
            AnomalyLikelihoodMetrics metrics = this.updateAnomalyLikelihoods(Arrays.asList(dataPoint), this.distribution);
            this.distribution = metrics.getParams();
            likelihoodRetval = 1.0 - metrics.getLikelihoods()[0];
        }
        this.historicalScores.add(dataPoint);
        ++this.iteration;
        return likelihoodRetval;
    }

    public AnomalyLikelihoodMetrics estimateAnomalyLikelihoods(List<Sample> anomalyScores, int averagingWindow, int skipRecords) {
        Statistic distribution;
        if (anomalyScores.size() == 0) {
            throw new IllegalArgumentException("Must have at least one anomaly score.");
        }
        Anomaly.AveragedAnomalyRecordList records = this.anomalyScoreMovingAverage(anomalyScores, averagingWindow);
        if (records.averagedRecords.size() <= skipRecords) {
            distribution = this.nullDistribution();
        } else {
            TDoubleList samples = records.getMetrics();
            int numRecordsToCopy = samples.size() - skipRecords;
            distribution = this.estimateNormal(samples.toArray(skipRecords, numRecordsToCopy), true);
            samples = records.getSamples();
            Statistic metricDistribution = this.estimateNormal(samples.toArray(skipRecords, numRecordsToCopy), false);
            if (metricDistribution.variance < 1.5E-5) {
                distribution = this.nullDistribution();
            }
        }
        int i = 0;
        double[] likelihoods = new double[records.averagedRecords.size()];
        for (Sample sample : records.averagedRecords) {
            likelihoods[i++] = this.normalProbability(sample.score, distribution);
        }
        double[] filteredLikelihoods = this.filterLikelihoods(likelihoods);
        int len = likelihoods.length;
        AnomalyParams params = new AnomalyParams(new String[]{"distribution", "movingAverage", "historicalLikelihoods"}, new Object[]{distribution, new MovingAverage(records.historicalValues, records.total, averagingWindow), len > 0 ? Arrays.copyOfRange(likelihoods, len - Math.min(averagingWindow, len), len) : new double[]{}});
        if (LOG.isDebugEnabled()) {
            LOG.debug("Discovered params={} Number of likelihoods:{}  First 20 likelihoods:{}", new Object[]{params, len, Arrays.copyOfRange(filteredLikelihoods, 0, 20)});
        }
        return new AnomalyLikelihoodMetrics(filteredLikelihoods, records, params);
    }

    public AnomalyLikelihoodMetrics updateAnomalyLikelihoods(List<Sample> anomalyScores, NamedTuple params) {
        double[] histLikelihoods;
        int anomalySize = anomalyScores.size();
        if (LOG.isDebugEnabled()) {
            LOG.debug("in updateAnomalyLikelihoods");
            LOG.debug("Number of anomaly scores: {}", (Object)anomalySize);
            LOG.debug("First 20: {}", anomalyScores.subList(0, Math.min(20, anomalySize)));
            LOG.debug("Params: {}", (Object)params);
        }
        if (anomalyScores.size() == 0) {
            throw new IllegalArgumentException("Must have at least one anomaly score.");
        }
        if (!this.isValidEstimatorParams(params)) {
            throw new IllegalArgumentException("\"params\" is not a valid parameter structure");
        }
        if (!params.hasKey("historicalLikelihoods") || (histLikelihoods = (double[])params.get("historicalLikelihoods")) == null || histLikelihoods.length == 0) {
            Object[] objectArray = new Object[3];
            objectArray[0] = params.get("distribution");
            objectArray[1] = params.get("movingAverage");
            histLikelihoods = new double[]{1.0};
            objectArray[2] = histLikelihoods;
            params = new NamedTuple(new String[]{"distribution", "movingAverage", "historicalLikelihoods"}, objectArray);
        }
        MovingAverage mvgAvg = (MovingAverage)params.get("movingAverage");
        TDoubleList historicalValues = mvgAvg.getSlidingWindow();
        double total = mvgAvg.getTotal();
        int windowSize = mvgAvg.getWindowSize();
        ArrayList<Sample> aggRecordList = new ArrayList<Sample>(anomalySize);
        double[] likelihoods = new double[anomalySize];
        int i = 0;
        for (Sample sample : anomalyScores) {
            MovingAverage.Calculation calc = MovingAverage.compute(historicalValues, total, sample.score, windowSize);
            aggRecordList.add(new Sample(sample.date, sample.value, calc.getAverage()));
            total = calc.getTotal();
            likelihoods[i++] = this.normalProbability(calc.getAverage(), (Statistic)params.get("distribution"));
        }
        double[] likelihoods2 = ArrayUtils.concat(histLikelihoods, likelihoods);
        double[] filteredLikelihoods = this.filterLikelihoods(likelihoods2);
        likelihoods = Arrays.copyOfRange(filteredLikelihoods, filteredLikelihoods.length - likelihoods.length, filteredLikelihoods.length);
        double[] historicalLikelihoods = Arrays.copyOf(likelihoods2, likelihoods2.length - Math.min(windowSize, likelihoods2.length));
        AnomalyParams newParams = new AnomalyParams(new String[]{"distribution", "movingAverage", "historicalLikelihoods"}, new Object[]{params.get("distribution"), new MovingAverage(historicalValues, total, windowSize), historicalLikelihoods});
        return new AnomalyLikelihoodMetrics(likelihoods, new Anomaly.AveragedAnomalyRecordList(aggRecordList, historicalValues, total), newParams);
    }

    public double[] filterLikelihoods(double[] likelihoods) {
        return this.filterLikelihoods(likelihoods, 0.99999, 0.999);
    }

    public double[] filterLikelihoods(double[] likelihoods, double redThreshold, double yellowThreshold) {
        redThreshold = 1.0 - redThreshold;
        yellowThreshold = 1.0 - yellowThreshold;
        double[] filteredLikelihoods = new double[likelihoods.length];
        filteredLikelihoods[0] = likelihoods[0];
        for (int i = 0; i < likelihoods.length - 1; ++i) {
            double v = likelihoods[i + 1];
            if (v <= redThreshold) {
                if (likelihoods[i] > redThreshold) {
                    filteredLikelihoods[i + 1] = v;
                    continue;
                }
                filteredLikelihoods[i + 1] = yellowThreshold;
                continue;
            }
            filteredLikelihoods[i + 1] = v;
        }
        return filteredLikelihoods;
    }

    public Anomaly.AveragedAnomalyRecordList anomalyScoreMovingAverage(List<Sample> anomalyScores, int windowSize) {
        TDoubleArrayList historicalValues = new TDoubleArrayList();
        double total = 0.0;
        ArrayList<Sample> averagedRecordList = new ArrayList<Sample>();
        for (Sample record : anomalyScores) {
            MovingAverage.Calculation calc = MovingAverage.compute((TDoubleList)historicalValues, total, record.score, windowSize);
            Sample avgRecord = new Sample(record.date, record.value, calc.getAverage());
            averagedRecordList.add(avgRecord);
            total = calc.getTotal();
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Aggregating input record: {}, Result: {}", (Object)record, averagedRecordList.get(averagedRecordList.size() - 1));
        }
        return new Anomaly.AveragedAnomalyRecordList(averagedRecordList, (TDoubleList)historicalValues, total);
    }

    public Statistic estimateNormal(double[] sampleData, boolean performLowerBoundCheck) {
        double d = ArrayUtils.average(sampleData);
        double v = ArrayUtils.variance(sampleData, d);
        if (performLowerBoundCheck) {
            if (d < 0.03) {
                d = 0.03;
            }
            if (v < 3.0E-4) {
                v = 3.0E-4;
            }
        }
        double s = v > 0.0 ? Math.sqrt(v) : 0.0;
        return new Statistic(d, v, s);
    }

    public Statistic nullDistribution() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Returning nullDistribution");
        }
        return new Statistic(0.5, 1000000.0, 1000.0);
    }

    public double normalProbability(double x, TObjectDoubleMap<String> named) {
        return this.normalProbability(x, new Statistic(named.get((Object)KEY_MEAN), named.get((Object)KEY_VARIANCE), named.get((Object)KEY_STDEV)));
    }

    public double normalProbability(double x, Statistic s) {
        if (x < s.mean) {
            double xp = 2.0 * s.mean - x;
            return 1.0 - this.normalProbability(xp, s);
        }
        double xs = 10.0 * (x - s.mean) / s.stdev;
        if ((xs = (double)Math.round(xs)) > 70.0) {
            return 0.0;
        }
        return Q[(int)xs];
    }

    @Override
    public double compute(int[] activeColumns, int[] predictedColumns, double inputValue, long timestamp) {
        if (inputValue == 0.0) {
            throw new IllegalArgumentException("Selected anomaly mode Mode.LIKELIHOOD requires an \"inputValue\" to the compute() method.");
        }
        DateTime time = timestamp > 0L ? new DateTime(timestamp) : new DateTime();
        double retVal = AnomalyLikelihood.computeRawAnomalyScore(activeColumns, predictedColumns);
        double probability = this.anomalyProbability(inputValue, retVal, time);
        double d = retVal = this.isWeighted ? retVal * (1.0 - probability) : 1.0 - probability;
        if (this.useMovingAverage) {
            retVal = this.movingAverage.next(retVal);
        }
        return retVal;
    }

    public boolean isValidEstimatorParams(NamedTuple params) {
        if (params.get("distribution") == null || params.get("movingAverage") == null) {
            return false;
        }
        Statistic stat = (Statistic)params.get("distribution");
        return stat.mean != 0.0 && stat.variance != 0.0 && stat.stdev != 0.0;
    }

    static {
        AnomalyLikelihood.Q[0] = 0.5;
        AnomalyLikelihood.Q[1] = 0.460172163;
        AnomalyLikelihood.Q[2] = 0.420740291;
        AnomalyLikelihood.Q[3] = 0.382088578;
        AnomalyLikelihood.Q[4] = 0.344578258;
        AnomalyLikelihood.Q[5] = 0.308537539;
        AnomalyLikelihood.Q[6] = 0.274253118;
        AnomalyLikelihood.Q[7] = 0.241963652;
        AnomalyLikelihood.Q[8] = 0.211855399;
        AnomalyLikelihood.Q[9] = 0.184060125;
        AnomalyLikelihood.Q[10] = 0.158655254;
        AnomalyLikelihood.Q[11] = 0.135666061;
        AnomalyLikelihood.Q[12] = 0.11506967;
        AnomalyLikelihood.Q[13] = 0.096800485;
        AnomalyLikelihood.Q[14] = 0.080756659;
        AnomalyLikelihood.Q[15] = 0.066807201;
        AnomalyLikelihood.Q[16] = 0.054799292;
        AnomalyLikelihood.Q[17] = 0.044565463;
        AnomalyLikelihood.Q[18] = 0.035930319;
        AnomalyLikelihood.Q[19] = 0.02871656;
        AnomalyLikelihood.Q[20] = 0.022750132;
        AnomalyLikelihood.Q[21] = 0.017864421;
        AnomalyLikelihood.Q[22] = 0.013903448;
        AnomalyLikelihood.Q[23] = 0.01072411;
        AnomalyLikelihood.Q[24] = 0.008197536;
        AnomalyLikelihood.Q[25] = 0.006209665;
        AnomalyLikelihood.Q[26] = 0.004661188;
        AnomalyLikelihood.Q[27] = 0.003466974;
        AnomalyLikelihood.Q[28] = 0.00255513;
        AnomalyLikelihood.Q[29] = 0.001865813;
        AnomalyLikelihood.Q[30] = 0.001349898;
        AnomalyLikelihood.Q[31] = 9.67603E-4;
        AnomalyLikelihood.Q[32] = 6.87138E-4;
        AnomalyLikelihood.Q[33] = 4.83424E-4;
        AnomalyLikelihood.Q[34] = 3.36929E-4;
        AnomalyLikelihood.Q[35] = 2.32629E-4;
        AnomalyLikelihood.Q[36] = 1.59109E-4;
        AnomalyLikelihood.Q[37] = 1.078E-4;
        AnomalyLikelihood.Q[38] = 7.2348E-5;
        AnomalyLikelihood.Q[39] = 4.8096E-5;
        AnomalyLikelihood.Q[40] = 3.1671E-5;
        AnomalyLikelihood.Q[41] = 2.1771135897E-5;
        AnomalyLikelihood.Q[42] = 1.4034063752E-5;
        AnomalyLikelihood.Q[43] = 8.961673661E-6;
        AnomalyLikelihood.Q[44] = 5.668743475E-6;
        AnomalyLikelihood.Q[45] = 3.551942468E-6;
        AnomalyLikelihood.Q[46] = 2.204533058E-6;
        AnomalyLikelihood.Q[47] = 1.355281953E-6;
        AnomalyLikelihood.Q[48] = 8.25270644E-7;
        AnomalyLikelihood.Q[49] = 4.97747091E-7;
        AnomalyLikelihood.Q[50] = 2.97343903E-7;
        AnomalyLikelihood.Q[51] = 1.75930101E-7;
        AnomalyLikelihood.Q[52] = 1.03096834E-7;
        AnomalyLikelihood.Q[53] = 5.9836778E-8;
        AnomalyLikelihood.Q[54] = 3.439559E-8;
        AnomalyLikelihood.Q[55] = 1.9581382E-8;
        AnomalyLikelihood.Q[56] = 1.1040394E-8;
        AnomalyLikelihood.Q[57] = 6.164833E-9;
        AnomalyLikelihood.Q[58] = 3.409172E-9;
        AnomalyLikelihood.Q[59] = 1.867079E-9;
        AnomalyLikelihood.Q[60] = 1.012647E-9;
        AnomalyLikelihood.Q[61] = 5.43915E-10;
        AnomalyLikelihood.Q[62] = 2.8932E-10;
        AnomalyLikelihood.Q[63] = 1.52404E-10;
        AnomalyLikelihood.Q[64] = 7.9502E-11;
        AnomalyLikelihood.Q[65] = 4.107E-11;
        AnomalyLikelihood.Q[66] = 2.101E-11;
        AnomalyLikelihood.Q[67] = 1.0644E-11;
        AnomalyLikelihood.Q[68] = 5.34E-12;
        AnomalyLikelihood.Q[69] = 2.653E-12;
        AnomalyLikelihood.Q[70] = 1.305E-12;
    }

    public static class AnomalyParams
    extends NamedTuple {
        private static final long serialVersionUID = 1L;
        private final Statistic distribution;
        private final MovingAverage movingAverage;
        private final double[] historicalLikelihoods;
        private final int windowSize;

        public AnomalyParams(String[] keys, Object ... values) {
            super(keys, values);
            if (keys.length != 3 || values.length != 3) {
                throw new IllegalArgumentException("AnomalyParams must have \"distribution\", \"movingAverage\", and \"historicalLikelihoods\" parameters. keys.length != 3 or values.length != 3");
            }
            this.distribution = (Statistic)this.get(Anomaly.KEY_DIST);
            this.movingAverage = (MovingAverage)this.get(Anomaly.KEY_MVG_AVG);
            this.historicalLikelihoods = (double[])this.get(Anomaly.KEY_HIST_LIKE);
            this.windowSize = this.movingAverage.getWindowSize();
        }

        public Statistic distribution() {
            return this.distribution;
        }

        public MovingAverage movingAverage() {
            return this.movingAverage;
        }

        public double[] historicalLikelihoods() {
            return this.historicalLikelihoods;
        }

        public int windowSize() {
            return this.windowSize;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.distribution == null ? 0 : this.distribution.hashCode());
            result = 31 * result + Arrays.hashCode(this.historicalLikelihoods);
            result = 31 * result + (this.movingAverage == null ? 0 : this.movingAverage.hashCode());
            result = 31 * result + this.windowSize;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AnomalyParams other = (AnomalyParams)obj;
            if (this.distribution == null ? other.distribution != null : !this.distribution.equals(other.distribution)) {
                return false;
            }
            if (!Arrays.equals(this.historicalLikelihoods, other.historicalLikelihoods)) {
                return false;
            }
            if (this.movingAverage == null ? other.movingAverage != null : !this.movingAverage.equals(other.movingAverage)) {
                return false;
            }
            return this.windowSize == other.windowSize;
        }
    }
}

