/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.encoders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.numenta.nupic.encoders.CoordinateOrder;
import org.numenta.nupic.encoders.Encoder;
import org.numenta.nupic.util.ArrayUtils;
import org.numenta.nupic.util.MersenneTwister;
import org.numenta.nupic.util.SortablePair;
import org.numenta.nupic.util.Tuple;

public class CoordinateEncoder
extends Encoder<Tuple>
implements CoordinateOrder {
    private static final long serialVersionUID = 1L;
    private static MersenneTwister random = new MersenneTwister();

    CoordinateEncoder() {
        Tuple desc = new Tuple("coordinate", 0);
        Tuple desc2 = new Tuple("radius", 1);
        this.description.add(desc);
        this.description.add(desc2);
    }

    @Override
    public int getWidth() {
        return this.n;
    }

    @Override
    public boolean isDelta() {
        return false;
    }

    public static Encoder.Builder<Builder, CoordinateEncoder> builder() {
        return new Builder();
    }

    public List<int[]> neighbors(int[] coordinate, double radius) {
        int[][] ranges = new int[coordinate.length][];
        for (int i = 0; i < coordinate.length; ++i) {
            ranges[i] = ArrayUtils.range(coordinate[i] - (int)radius, coordinate[i] + (int)radius + 1);
        }
        ArrayList<int[]> retVal = new ArrayList<int[]>();
        int len = ranges.length == 1 ? 1 : ranges[0].length;
        for (int k = 0; k < ranges[0].length; ++k) {
            for (int j = 0; j < len; ++j) {
                int[] entry = new int[ranges.length];
                entry[0] = ranges[0][k];
                for (int i = 1; i < ranges.length; ++i) {
                    entry[i] = ranges[i][j];
                }
                retVal.add(entry);
            }
        }
        return retVal;
    }

    public int[][] topWCoordinates(CoordinateOrder co, int[][] coordinates, int w) {
        Object[] pairs = new SortablePair[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            pairs[i] = new SortablePair<Double, Integer>(co.orderForCoordinate(coordinates[i]), i);
        }
        Arrays.sort(pairs);
        int[][] topCoordinates = new int[w][];
        int i = 0;
        int wIdx = pairs.length - w;
        while (i < w) {
            int index = (Integer)((SortablePair)pairs[wIdx]).second();
            topCoordinates[i] = coordinates[index];
            ++i;
            ++wIdx;
        }
        return topCoordinates;
    }

    @Override
    public double orderForCoordinate(int[] coordinate) {
        random.setSeed(coordinate);
        return random.nextDouble();
    }

    public static int bitForCoordinate(int[] coordinate, int n) {
        random.setSeed(coordinate);
        return random.nextInt(n);
    }

    @Override
    public void encodeIntoArray(Tuple inputData, int[] output) {
        List<int[]> neighs = this.neighbors((int[])inputData.get(0), (Double)inputData.get(1));
        int[][] neighbors = new int[neighs.size()][];
        for (int i = 0; i < neighs.size(); ++i) {
            neighbors[i] = neighs.get(i);
        }
        int[][] winners = this.topWCoordinates(this, neighbors, this.w);
        for (int i = 0; i < winners.length; ++i) {
            int bit = CoordinateEncoder.bitForCoordinate(winners[i], this.n);
            output[bit] = 1;
        }
    }

    @Override
    public <T> List<T> getBucketValues(Class<T> returnType) {
        return null;
    }

    public static class Builder
    extends Encoder.Builder<Builder, CoordinateEncoder> {
        private Builder() {
        }

        @Override
        public CoordinateEncoder build() {
            this.encoder = new CoordinateEncoder();
            super.build();
            if (this.w <= 0 || this.w % 2 == 0) {
                throw new IllegalArgumentException("w must be odd, and must be a positive integer");
            }
            if (this.n <= 6 * this.w) {
                throw new IllegalArgumentException("n must be an int strictly greater than 6*w. For good results we recommend n be strictly greater than 11*w");
            }
            if (this.name == null || this.name.equals("None")) {
                this.name = "[" + this.n + ":" + this.w + "]";
            }
            return (CoordinateEncoder)this.encoder;
        }
    }
}

