/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.encoders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.numenta.nupic.FieldMetaType;
import org.numenta.nupic.encoders.Encoder;
import org.numenta.nupic.util.ArrayUtils;
import org.numenta.nupic.util.Tuple;
import org.numenta.nupic.util.UniversalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomDistributedScalarEncoder
extends Encoder<Double> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RandomDistributedScalarEncoder.class);
    public static final long DEFAULT_SEED = 42L;
    UniversalRandom rng;
    int maxOverlap;
    int maxBuckets;
    Double offset;
    long seed;
    int minIndex;
    int maxIndex;
    int numRetry;
    ConcurrentHashMap<Integer, List<Integer>> bucketMap;

    RandomDistributedScalarEncoder() {
    }

    public static Encoder.Builder<Builder, RandomDistributedScalarEncoder> builder() {
        return new Builder();
    }

    public void init() throws IllegalStateException {
        if (this.getW() <= 0 || this.getW() % 2 == 0) {
            throw new IllegalStateException("W must be an odd positive integer (to eliminate centering difficulty)");
        }
        this.setHalfWidth((this.getW() - 1) / 2);
        if (this.getResolution() <= 0.0) {
            throw new IllegalStateException("Resolution must be a positive number");
        }
        if (this.n <= 6 * this.getW()) {
            throw new IllegalStateException("n must be strictly greater than 6*w. For good results we recommend n be strictly greater than 11*w.");
        }
        this.initEncoder(this.getResolution(), this.getW(), this.getN(), this.getOffset(), this.getSeed());
    }

    public void initEncoder(double resolution, int w, int n, Double offset, long seed) {
        this.rng = seed == -1L ? new UniversalRandom(42L) : new UniversalRandom(seed);
        this.initializeBucketMap(this.getMaxBuckets(), this.getOffset());
        if (this.getName() == null || this.getName().isEmpty()) {
            this.setName("[" + this.getResolution() + "]");
        }
        LOG.debug(this.toString());
    }

    public void initializeBucketMap(int maxBuckets, Double offset) {
        this.setMaxBuckets(maxBuckets);
        this.setMinIndex(maxBuckets / 2);
        this.setMaxIndex(maxBuckets / 2);
        this.setOffset(offset);
        this.bucketMap = new ConcurrentHashMap();
        int[] t = ArrayUtils.range(0, this.getN());
        this.rng.shuffle(t);
        this.bucketMap.put(this.getMinIndex(), Arrays.stream(t).boxed().limit(this.getW()).collect(Collectors.toList()));
        this.setNumRetry(0);
    }

    public void createBucket(int index) throws IllegalStateException {
        if (index < this.getMinIndex()) {
            if (index == this.getMinIndex() - 1) {
                this.bucketMap.put(index, this.newRepresentation(this.getMinIndex(), index));
                this.setMinIndex(index);
            } else {
                this.createBucket(index + 1);
                this.createBucket(index);
            }
        } else if (index == this.getMaxIndex() + 1) {
            this.bucketMap.put(index, this.newRepresentation(this.getMaxIndex(), index));
            this.setMaxIndex(index);
        } else {
            this.createBucket(index - 1);
            this.createBucket(index);
        }
    }

    public List<Integer> newRepresentation(int index, int newIndex) throws IllegalStateException {
        ArrayList<Integer> newRepresentation = new ArrayList<Integer>((Collection)this.bucketMap.get(index));
        int ri = newIndex % this.getW();
        int newBit = this.rng.nextInt(this.getN());
        newRepresentation.set(ri, newBit);
        while (this.bucketMap.get(index).contains(newBit) || !this.newRepresentationOK(newRepresentation, newIndex)) {
            this.setNumRetry(this.getNumRetry() + 1);
            newBit = this.rng.nextInt(this.getN());
            newRepresentation.set(ri, newBit);
        }
        return newRepresentation;
    }

    public boolean newRepresentationOK(List<Integer> newRep, int newIndex) {
        int newBit;
        int i;
        if (newRep.size() != this.getW()) {
            return false;
        }
        if (newIndex < this.getMinIndex() - 1 || newIndex > this.getMaxIndex() + 1) {
            throw new IllegalStateException("newIndex must be within one of existing indices");
        }
        boolean[] newRepBinary = new boolean[this.getN()];
        Arrays.fill(newRepBinary, false);
        for (int index : newRep) {
            newRepBinary[index] = true;
        }
        int midIdx = this.getMaxBuckets() / 2;
        int runningOverlap = this.countOverlap(this.bucketMap.get(this.getMinIndex()), newRep);
        if (!this.overlapOK(this.getMinIndex(), newIndex, runningOverlap)) {
            return false;
        }
        for (i = this.getMinIndex() + 1; i < midIdx + 1; ++i) {
            newBit = (i - 1) % this.getW();
            if (newRepBinary[this.bucketMap.get(i - 1).get(newBit)]) {
                --runningOverlap;
            }
            if (newRepBinary[this.bucketMap.get(i).get(newBit)]) {
                ++runningOverlap;
            }
            if (this.overlapOK(i, newIndex, runningOverlap)) continue;
            return false;
        }
        for (i = midIdx + 1; i <= this.getMaxIndex(); ++i) {
            newBit = i % this.getW();
            if (newRepBinary[this.bucketMap.get(i - 1).get(newBit)]) {
                --runningOverlap;
            }
            if (newRepBinary[this.bucketMap.get(i).get(newBit)]) {
                ++runningOverlap;
            }
            if (this.overlapOK(i, newIndex, runningOverlap)) continue;
            return false;
        }
        return true;
    }

    public int countOverlap(List<Integer> rep1, List<Integer> rep2) {
        int overlap = 0;
        for (int index : rep1) {
            for (int index2 : rep2) {
                if (index != index2) continue;
                ++overlap;
            }
        }
        return overlap;
    }

    public int countOverlap(int[] rep1, int[] rep2) {
        int overlap = 0;
        for (int index : rep1) {
            for (int index2 : rep2) {
                if (index != index2) continue;
                ++overlap;
            }
        }
        return overlap;
    }

    public boolean overlapOK(int i, int j, int overlap) {
        if (Math.abs(i - j) < this.getW() && overlap == this.getW() - Math.abs(i - j)) {
            return true;
        }
        return Math.abs(i - j) >= this.getW() && overlap <= this.getMaxOverlap();
    }

    public boolean overlapOK(int i, int j) throws IllegalStateException {
        return this.overlapOK(i, j, this.countOverlapIndices(i, j));
    }

    public int countOverlapIndices(int i, int j) throws IllegalStateException {
        boolean containsI = this.bucketMap.containsKey(i);
        boolean containsJ = this.bucketMap.containsKey(j);
        if (containsI && containsJ) {
            List<Integer> rep1 = this.bucketMap.get(i);
            List<Integer> rep2 = this.bucketMap.get(j);
            return this.countOverlap(rep1, rep2);
        }
        if (!containsI && !containsJ) {
            throw new IllegalStateException("index " + i + " and " + j + " don't exist");
        }
        if (!containsI) {
            throw new IllegalStateException("index " + i + " doesn't exist");
        }
        throw new IllegalStateException("index " + j + " doesn't exist");
    }

    public List<Integer> mapBucketIndexToNonZeroBits(int index) throws IllegalStateException {
        if (index < 0) {
            index = 0;
        }
        if (index >= this.getMaxBuckets()) {
            index = this.getMaxBuckets() - 1;
        }
        if (!this.bucketMap.containsKey(index)) {
            LOG.trace("Adding additional buckets to handle index={} ", (Object)index);
            this.createBucket(index);
        }
        return this.bucketMap.get(index);
    }

    @Override
    public int[] getBucketIndices(double x) {
        int test;
        if (Double.isNaN(x)) {
            x = Double.NaN;
        }
        if ((test = Double.compare(x, Double.NaN)) == 0) {
            return new int[0];
        }
        if (this.getOffset() == null) {
            this.setOffset(x);
        }
        double deltaIndex = (x - this.getOffset()) / this.getResolution();
        int sign = (int)(deltaIndex / Math.abs(deltaIndex));
        int bucketIdx = this.getMaxBuckets() / 2 + sign * (int)Math.round(Math.abs(deltaIndex));
        if (bucketIdx < 0) {
            bucketIdx = 0;
        } else if (bucketIdx >= this.getMaxBuckets()) {
            bucketIdx = this.getMaxBuckets() - 1;
        }
        int[] bucketIdxArray = new int[]{bucketIdx};
        return bucketIdxArray;
    }

    @Override
    public int getWidth() {
        return this.getN();
    }

    @Override
    public boolean isDelta() {
        return false;
    }

    @Override
    public void setLearning(boolean learningEnabled) {
        this.setLearningEnabled(learningEnabled);
    }

    @Override
    public List<Tuple> getDescription() {
        String name = this.getName();
        if (name == null || name.isEmpty()) {
            this.setName("[" + this.getResolution() + "]");
        }
        name = this.getName();
        return new ArrayList<Tuple>(Arrays.asList(new Tuple(name, 0)));
    }

    public int getMaxOverlap() {
        return this.maxOverlap;
    }

    public int getMaxBuckets() {
        return this.maxBuckets;
    }

    public long getSeed() {
        return this.seed;
    }

    public Double getOffset() {
        return this.offset;
    }

    private int getMinIndex() {
        return this.minIndex;
    }

    private int getMaxIndex() {
        return this.maxIndex;
    }

    public int getNumRetry() {
        return this.numRetry;
    }

    public void setMaxOverlap(int maxOverlap) {
        this.maxOverlap = maxOverlap;
    }

    public void setMaxBuckets(int maxBuckets) {
        this.maxBuckets = maxBuckets;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setOffset(Double offset) {
        this.offset = offset;
    }

    private void setMinIndex(int minIndex) {
        this.minIndex = minIndex;
    }

    private void setMaxIndex(int maxIndex) {
        this.maxIndex = maxIndex;
    }

    public void setNumRetry(int numRetry) {
        this.numRetry = numRetry;
    }

    public String toString() {
        StringBuilder dumpString = new StringBuilder(50);
        dumpString.append("RandomDistributedScalarEncoder:\n");
        dumpString.append("  minIndex: " + this.getMinIndex() + "\n");
        dumpString.append("  maxIndex: " + this.getMaxIndex() + "\n");
        dumpString.append("  w: " + this.getW() + "\n");
        dumpString.append("  n: " + this.getWidth() + "\n");
        dumpString.append("  resolution: " + this.getResolution() + "\n");
        dumpString.append("  offset: " + this.getOffset() + "\n");
        dumpString.append("  numTries: " + this.getNumRetry() + "\n");
        dumpString.append("  name: " + this.getName() + "\n");
        dumpString.append("  buckets : \n");
        Iterator iterator = ((ConcurrentHashMap.KeySetView)this.bucketMap.keySet()).iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            dumpString.append("  [ " + index + " ]: " + Arrays.deepToString(this.bucketMap.get(index).toArray()) + "\n");
        }
        return dumpString.toString();
    }

    @Override
    public void encodeIntoArray(Double inputData, int[] output) {
        int[] bucketIdx = this.getBucketIndices(inputData);
        Arrays.fill(output, 0);
        if (bucketIdx.length == 0) {
            return;
        }
        if (bucketIdx[0] != Integer.MIN_VALUE) {
            try {
                List<Integer> indices = this.mapBucketIndexToNonZeroBits(bucketIdx[0]);
                for (int index : indices) {
                    output[index] = 1;
                }
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public <S> List<S> getBucketValues(Class<S> returnType) {
        return new ArrayList<List<Integer>>(this.bucketMap.values());
    }

    @Override
    public Set<FieldMetaType> getDecoderOutputFieldTypes() {
        return new LinkedHashSet<FieldMetaType>(Arrays.asList(FieldMetaType.FLOAT, FieldMetaType.INTEGER));
    }

    public static class Builder
    extends Encoder.Builder<Builder, RandomDistributedScalarEncoder> {
        private int maxOverlap;
        private int maxBuckets;
        private Double offset;
        private long seed;
        int minIndex;
        int maxIndex;

        private Builder() {
            this.n(400);
            this.w(21);
            this.seed = 42L;
            this.maxBuckets = 1000;
            this.maxOverlap = 2;
            this.offset = null;
        }

        private Builder(int n, int w) {
            this();
            this.n(n);
            this.w(w);
        }

        @Override
        public RandomDistributedScalarEncoder build() {
            this.encoder = new RandomDistributedScalarEncoder();
            RandomDistributedScalarEncoder partialBuild = (RandomDistributedScalarEncoder)super.build();
            partialBuild.setSeed(this.seed);
            partialBuild.setMaxOverlap(this.maxOverlap);
            partialBuild.setMaxBuckets(this.maxBuckets);
            partialBuild.setOffset(this.offset);
            partialBuild.setNumRetry(0);
            partialBuild.init();
            return partialBuild;
        }

        public Builder setOffset(double offset) {
            this.offset = offset;
            return this;
        }

        public Builder setMaxBuckets(int maxBuckets) {
            this.maxBuckets = maxBuckets;
            return this;
        }

        public Builder setMaxOverlap(int maxOverlap) {
            this.maxOverlap = maxOverlap;
            return this;
        }

        public Builder setSeed(long seed) {
            this.seed = seed;
            return this;
        }
    }
}

